/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.el;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import com.intellij.psi.impl.source.jsp.el.impl.ELFunctionCallExpressionImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELLambdaExpressionImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELListConstructionExpressionImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELLiteralExpressionImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELMapConstructionExpressionImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELMethodCallExpressionImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELSetConstructionExpressionImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELVariableImpl;
import com.intellij.psi.jsp.el.ELCallExpression;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELLambdaExpression;
import com.intellij.psi.jsp.el.ELLambdaParameters;
import com.intellij.psi.jsp.el.ELMethodCallExpression;
import com.intellij.psi.jsp.el.ELParameterList;
import com.intellij.psi.jsp.el.ELSelectExpression;
import com.intellij.psi.jsp.el.ELTokenType;
import com.intellij.psi.jsp.el.ELUnaryExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ELParserUtil {
    public static final Key<Object> KEY = Key.create((String)"inside conditional");

    public static boolean push(PsiBuilder builder_, int i, int i1) {
        builder_.putUserData(KEY, (Object)i1);
        return true;
    }

    public static boolean pop(PsiBuilder builder_, int i) {
        builder_.putUserData(KEY, null);
        return true;
    }

    public static boolean peek(PsiBuilder builder_, int i, int i1) {
        return builder_.getUserData(KEY) != null;
    }

    @Nullable
    public static ELVariable getField(ELSelectExpression expression) {
        List<ELExpression> list = expression.getELExpressionList();
        if (list.size() < 2) {
            return null;
        }
        ELExpression elExpression = list.get(1);
        return elExpression instanceof ELVariable ? (ELVariable)elExpression : null;
    }

    public static ELExpression[] getParameters(ELParameterList list) {
        List<ELExpression> expressions = list.getELExpressionList();
        return expressions.toArray(new ELExpression[0]);
    }

    public static String getFunctionName(ELCallExpression expression) {
        ELVariable method = expression.getMethod();
        return method == null ? null : method.getText();
    }

    public static ELParameterList getParameterList(ELFunctionCallExpressionImpl expression) {
        return expression.getELParameterList();
    }

    public static ELParameterList getParameterList(ELMethodCallExpressionImpl expression) {
        return expression.getELParameterList();
    }

    public static IElementType getOperationSign(ELUnaryExpression expression) {
        ASTNode[] nodes = expression.getNode().getChildren(ELTokenType.JSP_EL_UNARY_OPERATIONS);
        return nodes.length == 1 ? nodes[0].getElementType() : null;
    }

    public static ELExpression getQualifier(ELMethodCallExpression expression) {
        ELExpression select = expression.getELExpression();
        if (select instanceof ELSelectExpression) {
            return ((ELSelectExpression)select).getFrom();
        }
        return select == expression.getMethod() ? null : select;
    }

    @Nullable
    public static ELVariable getMethod(ELMethodCallExpression expression) {
        PsiElement sibling = expression.getELParameterList().getPrevSibling();
        if (sibling instanceof ELSelectExpression) {
            return ((ELSelectExpression)sibling).getField();
        }
        if (sibling instanceof ELVariable) {
            return (ELVariable)sibling;
        }
        return null;
    }

    public static List<ELVariable> getVariables(ELLambdaExpressionImpl expression) {
        PsiElement child = expression.getFirstChild();
        if (child instanceof ELLambdaParameters) {
            return ((ELLambdaParameters)child).getELVariableList();
        }
        return Collections.singletonList((ELVariable)child);
    }

    public static PsiNamedElement setName(ELVariableImpl variable, String name) throws IncorrectOperationException {
        ELVariable newElement = ELParserUtil.createVariable(name, variable.getProject());
        if (newElement == null) {
            throw new IncorrectOperationException("Cannot create variable with name '" + name + "'");
        }
        variable.replace((PsiElement)newElement);
        return newElement;
    }

    public static String getName(ELVariableImpl variable) {
        return variable.getText();
    }

    @Nullable
    public static ELVariable createVariable(String name, Project project) {
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(ELLanguage.INSTANCE, (CharSequence)("${" + name + "}"));
        return (ELVariable)file.getFirstChild().getChildren()[0];
    }

    @NotNull
    public static SearchScope getUseScope(ELVariableImpl variable) {
        ELLambdaExpression lambdaExpression = (ELLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)variable, ELLambdaExpression.class);
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)(lambdaExpression == null ? variable.getContainingFile() : lambdaExpression));
        if (localSearchScope == null) {
            ELParserUtil.$$$reportNull$$$0(0);
        }
        return localSearchScope;
    }

    public static Class getTypeClass(ELListConstructionExpressionImpl expression) {
        return List.class;
    }

    public static Class getTypeClass(ELLiteralExpressionImpl expression) {
        IElementType type = expression.getNode().getFirstChildNode().getElementType();
        if (type == ELTokenType.JSP_EL_STRING_LITERAL || type == ELTokenType.JSP_EL_ESCAPED_STRING_LITERAL) {
            return String.class;
        }
        if (type == ELTokenType.JSP_EL_INTEGER_LITERAL) {
            return Integer.class;
        }
        if (type == ELTokenType.JSP_EL_FLOATING_POINT_LITERAL) {
            return Float.class;
        }
        if (type == ELTokenType.JSP_EL_TRUE || type == ELTokenType.JSP_EL_FALSE) {
            return Boolean.class;
        }
        return Object.class;
    }

    public static Class getTypeClass(ELMapConstructionExpressionImpl expression) {
        return Map.class;
    }

    public static Class getTypeClass(ELSetConstructionExpressionImpl expression) {
        return Set.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/el/ELParserUtil", "getUseScope"));
    }
}

