/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.el.impl;

import com.intellij.jsp.impl.TldAttributeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.jsp.TaglibUriCacheProvider;
import com.intellij.psi.impl.source.jsp.el.impl.ELMethodSignature;
import com.intellij.psi.impl.source.jsp.el.impl.MethodSignatureFilter;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringMethodSignatureFilter
extends MethodSignatureFilter {
    private final ELMethodSignature mySignature;
    private final boolean myAllowAnyNonVoidReturnType;
    private final boolean myAllowVoid;

    public StringMethodSignatureFilter(@NotNull @NonNls String signature, boolean allowVoid) {
        if (signature == null) {
            StringMethodSignatureFilter.$$$reportNull$$$0(0);
        }
        this.myAllowVoid = allowVoid;
        this.mySignature = new ELMethodSignature(signature);
        this.myAllowAnyNonVoidReturnType = signature.startsWith("java.lang.Object");
    }

    @Override
    public boolean isAcceptable(PsiMethod method) {
        PsiType methodReturnType = method.getReturnType();
        if (methodReturnType == null) {
            return false;
        }
        String typeText = methodReturnType.getCanonicalText();
        if (typeText == null) {
            return false;
        }
        if (!typeText.equals(this.mySignature.getReturnType())) {
            if (typeText.equals("void")) {
                if (!this.myAllowVoid) {
                    return false;
                }
            } else if (!this.myAllowAnyNonVoidReturnType) {
                if (this.mySignature.getReturnType() != null) {
                    try {
                        PsiType type = JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeFromText(this.mySignature.getReturnType(), (PsiElement)method);
                        return type.isConvertibleFrom(methodReturnType);
                    }
                    catch (IncorrectOperationException e) {
                        return false;
                    }
                }
                return false;
            }
        }
        ArrayList<String> parameters = this.mySignature.getParameters();
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        PsiType[] parameterTypes = methodSignature.getParameterTypes();
        if (parameterTypes.length != parameters.size()) {
            return false;
        }
        int parameterIndex = 0;
        for (PsiType type : parameterTypes) {
            String name;
            PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)type);
            String string = name = psiClass == null ? type.getCanonicalText() : psiClass.getQualifiedName();
            if (name == null || !name.equals(parameters.get(parameterIndex))) {
                return false;
            }
            ++parameterIndex;
        }
        return true;
    }

    @Override
    public String getSignature() {
        return this.mySignature.getSignature();
    }

    @Nullable
    public static MethodSignatureFilter getDeferredMethodSignatureFilter(ELExpressionHolder elHolder) {
        XmlAttributeDescriptor descriptor;
        XmlAttribute attr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)elHolder, XmlAttribute.class);
        if (attr != null && (descriptor = attr.getDescriptor()) instanceof TldAttributeDescriptor) {
            TldAttributeDescriptor tldAttributeDescriptor = (TldAttributeDescriptor)descriptor;
            String signature = tldAttributeDescriptor.getMethodSignature();
            if (signature != null) {
                boolean allowVoid = StringMethodSignatureFilter.isVoidAllowed(tldAttributeDescriptor);
                return new StringMethodSignatureFilter(signature, allowVoid);
            }
            String type = tldAttributeDescriptor.getType();
            if (type != null) {
                return new StringMethodSignatureFilter(type + " action()", StringMethodSignatureFilter.isVoidAllowed(tldAttributeDescriptor));
            }
        }
        return null;
    }

    private static boolean isVoidAllowed(TldAttributeDescriptor tldAttributeDescriptor) {
        boolean allowVoid = false;
        PsiElement element = tldAttributeDescriptor.getDeclaration();
        String name = ((XmlTag)element).getSubTagText("name");
        if (name != null && name.trim().equals("action")) {
            PsiFile file = element.getContainingFile();
            String uri = TaglibUriCacheProvider.getUri((XmlFile)file);
            allowVoid = uri != null && Arrays.asList(XmlUtil.JSF_HTML_URIS).contains(uri);
        }
        return allowVoid;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/psi/impl/source/jsp/el/impl/StringMethodSignatureFilter", "<init>"));
    }
}

