/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.el.impl;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.jsp.JspImplicitVariableImpl;
import com.intellij.psi.impl.source.jsp.el.impl.ELReference;
import com.intellij.psi.impl.source.jsp.el.impl.ELResolveUtil;
import com.intellij.psi.impl.source.jsp.jspXml.JspExpression;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.jsp.el.ELFunctionCallExpression;
import com.intellij.psi.jsp.el.ELSliceExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NotNullFunction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TagImplicitVariable
extends JspImplicitVariableImpl {
    @NonNls
    private static final String SET_TAG_NAME = "set";
    private final NotNullFunction<XmlTag, String> myDefaultVarTypeProvider;

    public TagImplicitVariable(XmlTag tag, XmlAttribute attribute, String range, NotNullFunction<XmlTag, String> defaultVarTypeProvider) {
        super((PsiElement)tag, attribute.getValue(), null, (PsiElement)attribute.getValueElement(), range);
        this.myDefaultVarTypeProvider = defaultVarTypeProvider;
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        if (this.getDeclarationRange() == 1) {
            LocalSearchScope localSearchScope = new LocalSearchScope(this.getDeclarationScope());
            if (localSearchScope == null) {
                TagImplicitVariable.$$$reportNull$$$0(0);
            }
            return localSearchScope;
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            TagImplicitVariable.$$$reportNull$$$0(1);
        }
        return searchScope;
    }

    @NotNull
    public PsiType getType() {
        XmlTag tag = (XmlTag)this.getDeclarationScope();
        String localName = tag.getLocalName();
        String typeQName = (String)this.myDefaultVarTypeProvider.fun((Object)tag);
        if ("forTokens".equals(localName) || SET_TAG_NAME.equals(localName)) {
            typeQName = "java.lang.String";
        } else if ("catch".equals(localName)) {
            typeQName = "java.lang.Exception";
        }
        PsiType varType = null;
        PsiType componentType = TagImplicitVariable.tryDoEvalTypeFromAttributeValue(tag, "items", true, "forEach".equals(localName));
        if (componentType != null) {
            varType = componentType;
        } else {
            componentType = TagImplicitVariable.tryDoEvalTypeFromAttributeValue(tag, "value", !SET_TAG_NAME.equals(localName), false);
            if (componentType != null) {
                varType = componentType;
            }
        }
        if (varType != null) {
            varType = GenericsUtil.eliminateWildcards((PsiType)varType, (boolean)false);
        }
        if (varType == null) {
            varType = JavaPsiFacade.getElementFactory((Project)tag.getProject()).createTypeByFQClassName(typeQName);
        }
        PsiType psiType = varType;
        if (psiType == null) {
            TagImplicitVariable.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    @Nullable
    private static PsiType tryDoEvalTypeFromAttributeValue(XmlTag tag, @NonNls String attrName, boolean evaluateComponentType, boolean treatMapComponentTypeAsEntry) {
        PsiElement[] itemsValueChildren;
        if (tag.getAttributeValue(attrName) == null) {
            return null;
        }
        XmlAttribute attribute = tag.getAttribute(attrName, null);
        XmlAttributeValue value = attribute != null ? attribute.getValueElement() : null;
        PsiElement[] psiElementArray = itemsValueChildren = value != null ? value.getChildren() : PsiElement.EMPTY_ARRAY;
        if (itemsValueChildren.length > 2) {
            PsiElement child = itemsValueChildren[1];
            if (child instanceof ELExpressionHolder) {
                PsiElement[] expressionHolderChildren = child.getChildren();
                if (expressionHolderChildren.length > 0) {
                    Object expressionElement = expressionHolderChildren[0];
                    if (expressionElement instanceof ELFunctionCallExpression) {
                        expressionElement = ((ELFunctionCallExpression)expressionElement).getMethod();
                    } else if (expressionElement instanceof ELSliceExpression) {
                        expressionElement = ((ELSliceExpression)expressionElement).getFrom();
                        evaluateComponentType = true;
                    }
                    PsiReference psiReference = expressionElement.findReferenceAt(expressionElement.getTextLength() - 1);
                    if (psiReference instanceof ELReference) {
                        return TagImplicitVariable.handleType(tag, evaluateComponentType, treatMapComponentTypeAsEntry, ELResolveUtil.resolveContextAsType(((ELReference)psiReference).getElement()));
                    }
                }
            } else if (child instanceof JspExpression) {
                PsiElement at;
                int offset = child.getTextOffset() + "<%=".length();
                while ((at = tag.getContainingFile().getViewProvider().findElementAt(offset, (Language)JavaLanguage.INSTANCE)) != null) {
                    ++offset;
                    if (at instanceof PsiWhiteSpace) continue;
                }
                if (at != null) {
                    PsiExpression currentExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)at, PsiExpression.class, (boolean)false);
                    PsiExpression expression = null;
                    PsiExpression prevexpression = null;
                    while (currentExpression != null) {
                        prevexpression = expression;
                        expression = currentExpression;
                        currentExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)currentExpression, PsiExpression.class);
                    }
                    if (prevexpression != null) {
                        return TagImplicitVariable.handleType(tag, evaluateComponentType, treatMapComponentTypeAsEntry, prevexpression.getType());
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    static PsiType handleType(XmlTag tag, boolean evaluateComponentType, boolean treatMapComponentTypeAsEntry, PsiType type) {
        if (type == null) {
            return null;
        }
        if (evaluateComponentType) {
            if (treatMapComponentTypeAsEntry && type instanceof PsiClassType) {
                PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)type).resolveGenerics();
                PsiFile file = tag.getContainingFile();
                if (TagImplicitVariable.isInheritor(TagImplicitVariable.getCachedClass(file, "java.util.Map"), classResolveResult)) {
                    PsiSubstitutor classSubstitutor = TagImplicitVariable.getSubstitutions(classResolveResult);
                    JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)file.getProject());
                    PsiClass entryClass = facade.findClass("java.util.Map.Entry", TagImplicitVariable.getElementDependenciesScope((PsiElement)file));
                    assert (entryClass != null);
                    PsiSubstitutor entrySubstitutor = GenericsUtil.substituteByParameterName((PsiClass)entryClass, (PsiSubstitutor)classSubstitutor);
                    return facade.getElementFactory().createType(entryClass, entrySubstitutor);
                }
            }
            return TagImplicitVariable.evaluateComponentType(type, (PsiElement)tag);
        }
        return type;
    }

    @Nullable
    static PsiClass getCachedClass(PsiFile psiFile, String clazzName) {
        return JavaPsiFacade.getInstance((Project)psiFile.getProject()).findClass(clazzName, TagImplicitVariable.getElementDependenciesScope((PsiElement)psiFile));
    }

    static GlobalSearchScope getElementDependenciesScope(PsiElement psiFile) {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)psiFile);
        return module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false) : GlobalSearchScope.allScope((Project)psiFile.getProject());
    }

    static PsiSubstitutor fillSubstitutionMapFromSupers(PsiClass psiClass, PsiSubstitutor substitutor) {
        return TagImplicitVariable.fillSubstitutionMapFromSupers(psiClass, substitutor, new HashSet<PsiClass>(Collections.singleton(psiClass)));
    }

    private static PsiSubstitutor fillSubstitutionMapFromSupers(PsiClass psiClass, PsiSubstitutor substitutor, Set<PsiClass> visited) {
        PsiClassType[] classTypes;
        for (PsiClassType superType : classTypes = psiClass.getSuperTypes()) {
            if (superType == null) continue;
            PsiClassType.ClassResolveResult classResolveResult = superType.resolveGenerics();
            substitutor = substitutor.putAll(classResolveResult.getSubstitutor());
            PsiClass superClass = classResolveResult.getElement();
            if (superClass == null || visited.contains(superClass)) continue;
            substitutor = TagImplicitVariable.fillSubstitutionMapFromSupers(superClass, substitutor);
        }
        return substitutor;
    }

    @Nullable
    static PsiType evaluateComponentType(PsiType fromResolved, PsiElement context) {
        PsiClassType psiClassType;
        PsiClassType.ClassResolveResult classResolveResult;
        if (fromResolved instanceof PsiArrayType) {
            return ((PsiArrayType)fromResolved).getComponentType();
        }
        if (fromResolved instanceof PsiClassType && (classResolveResult = (psiClassType = (PsiClassType)fromResolved).resolveGenerics()).getElement() != null) {
            PsiFile psiFile = context.getContainingFile();
            Project project = psiFile.getProject();
            PsiManager manager = PsiManager.getInstance((Project)project);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            PsiType type = TagImplicitVariable.evaluateSpecialType(TagImplicitVariable.getCachedClass(psiFile, "java.util.List"), classResolveResult, manager, scope, 0);
            if (type != null) {
                return type;
            }
            type = TagImplicitVariable.evaluateSpecialType(TagImplicitVariable.getCachedClass(psiFile, "java.util.Collection"), classResolveResult, manager, scope, 0);
            if (type != null) {
                return type;
            }
            return TagImplicitVariable.evaluateSpecialType(TagImplicitVariable.getCachedClass(psiFile, "java.util.Map"), classResolveResult, manager, scope, 1);
        }
        return null;
    }

    @Nullable
    static PsiType evaluateSpecialType(PsiClass listClass, PsiClassType.ClassResolveResult classResolveResult, PsiManager manager, GlobalSearchScope scope, int typeParameterIndex) {
        if (TagImplicitVariable.isInheritor(listClass, classResolveResult)) {
            PsiTypeParameter[] typeParameters = listClass.getTypeParameters();
            if (typeParameters.length > typeParameterIndex) {
                PsiSubstitutor psiSubstitutor = TagImplicitVariable.getSubstitutions(classResolveResult);
                PsiType type = (PsiType)psiSubstitutor.getSubstitutionMap().get(typeParameters[typeParameterIndex]);
                if (type != null) {
                    return type;
                }
                PsiClass psiClass = classResolveResult.getElement();
                assert (psiClass != null);
                PsiTypeParameter[] typeParametersFromResolveResult = psiClass.getTypeParameters();
                if (typeParametersFromResolveResult.length > typeParameterIndex && (type = (PsiType)psiSubstitutor.getSubstitutionMap().get(typeParametersFromResolveResult[typeParameterIndex])) != null) {
                    return type;
                }
            }
            return JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeByFQClassName("java.lang.Object", scope);
        }
        return null;
    }

    static PsiSubstitutor getSubstitutions(PsiClassType.ClassResolveResult classResolveResult) {
        PsiSubstitutor psiSubstitutor = classResolveResult.getSubstitutor();
        if (psiSubstitutor.getSubstitutionMap().isEmpty()) {
            psiSubstitutor = TagImplicitVariable.fillSubstitutionMapFromSupers(classResolveResult.getElement(), psiSubstitutor);
        }
        return psiSubstitutor;
    }

    static boolean isInheritor(PsiClass listClass, PsiClassType.ClassResolveResult classResolveResult) {
        PsiClass element = classResolveResult.getElement();
        return listClass != null && (element == listClass || element != null && element.isInheritor(listClass, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/source/jsp/el/impl/TagImplicitVariable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

