/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.testAssistant.TestDataNavigationElement;
import org.jetbrains.idea.devkit.testAssistant.TestDataUtil;
import org.jetbrains.idea.devkit.testAssistant.vfs.TestDataGroupVirtualFile;

public class TestDataNavigationElementFactory {
    private static final int CREATE_MISSING_FILES_WITHOUT_CONFIRMATION_LIMIT = 3;

    private TestDataNavigationElementFactory() {
    }

    @NotNull
    public static TestDataNavigationElement createForFile(@NotNull Project project, @NotNull String path) {
        if (project == null) {
            TestDataNavigationElementFactory.$$$reportNull$$$0(0);
        }
        if (path == null) {
            TestDataNavigationElementFactory.$$$reportNull$$$0(1);
        }
        TestDataFileNavigationElement testDataFileNavigationElement = new TestDataFileNavigationElement(project, path);
        if (testDataFileNavigationElement == null) {
            TestDataNavigationElementFactory.$$$reportNull$$$0(2);
        }
        return testDataFileNavigationElement;
    }

    @NotNull
    public static TestDataNavigationElement createForGroup(@NotNull Project project, @NotNull TestDataGroupVirtualFile group) {
        if (project == null) {
            TestDataNavigationElementFactory.$$$reportNull$$$0(3);
        }
        if (group == null) {
            TestDataNavigationElementFactory.$$$reportNull$$$0(4);
        }
        TestDataGroupNavigationElement testDataGroupNavigationElement = new TestDataGroupNavigationElement(project, group);
        if (testDataGroupNavigationElement == null) {
            TestDataNavigationElementFactory.$$$reportNull$$$0(5);
        }
        return testDataGroupNavigationElement;
    }

    @NotNull
    public static TestDataNavigationElement createForCreateMissingFilesOption(@NotNull List<String> filePaths) {
        if (filePaths == null) {
            TestDataNavigationElementFactory.$$$reportNull$$$0(6);
        }
        CreateMissingTestDataFilesNavigationElement createMissingTestDataFilesNavigationElement = new CreateMissingTestDataFilesNavigationElement(filePaths);
        if (createMissingTestDataFilesNavigationElement == null) {
            TestDataNavigationElementFactory.$$$reportNull$$$0(7);
        }
        return createMissingTestDataFilesNavigationElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationElementFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationElementFactory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createForFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createForGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createForCreateMissingFilesOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createForFile";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createForGroup";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createForCreateMissingFilesOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TestDataFileNavigationElement
    implements TestDataNavigationElement {
        private final Project myProject;
        private final String myPath;

        private TestDataFileNavigationElement(Project project, String path) {
            this.myProject = project;
            this.myPath = path;
        }

        @Override
        public void performAction(@NotNull Project project) {
            if (project == null) {
                TestDataFileNavigationElement.$$$reportNull$$$0(0);
            }
            TestDataUtil.openOrAskToCreateFile(project, this.myPath);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return TestDataUtil.getIcon(this.myPath);
        }

        @Override
        @NotNull
        public List<Pair<String, SimpleTextAttributes>> getTitleFragments() {
            VirtualFile file = TestDataUtil.getFileByPath(this.myPath);
            if (file == null) {
                Pair<String, String> relativePath = TestDataUtil.getRelativePathPairForMissingFile(this.myProject, this.myPath);
                List list = ContainerUtil.list((Object[])new Pair[]{new Pair((Object)(PathUtil.getFileName((String)this.myPath) + " ("), (Object)SimpleTextAttributes.GRAYED_ATTRIBUTES), new Pair((Object)(relativePath.first == null ? "" : (String)relativePath.first), (Object)SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES), new Pair((Object)(relativePath.first == null ? "" : "/" + (String)relativePath.second + ")"), (Object)SimpleTextAttributes.GRAYED_ATTRIBUTES)});
                if (list == null) {
                    TestDataFileNavigationElement.$$$reportNull$$$0(1);
                }
                return list;
            }
            Pair<String, String> relativePath = TestDataUtil.getModuleOrProjectRelativeParentPath(this.myProject, file);
            if (relativePath == null) {
                List<Pair<String, SimpleTextAttributes>> list = Collections.singletonList(new Pair((Object)String.format("%s (%s)", file.getName(), PathUtil.getParentPath((String)this.myPath) + "/"), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                if (list == null) {
                    TestDataFileNavigationElement.$$$reportNull$$$0(2);
                }
                return list;
            }
            ImmutableList immutableList = ImmutableList.of((Object)new Pair((Object)(file.getName() + " ("), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES), (Object)new Pair(relativePath.getFirst(), (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES), (Object)new Pair((Object)("/" + (String)relativePath.getSecond() + "/)"), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
            if (immutableList == null) {
                TestDataFileNavigationElement.$$$reportNull$$$0(3);
            }
            return immutableList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationElementFactory$TestDataFileNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationElementFactory$TestDataFileNavigationElement";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitleFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "performAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TestDataGroupNavigationElement
    implements TestDataNavigationElement {
        private final Project myProject;
        private final TestDataGroupVirtualFile myGroup;

        private TestDataGroupNavigationElement(Project project, TestDataGroupVirtualFile group) {
            this.myProject = project;
            this.myGroup = group;
        }

        @Override
        public void performAction(@NotNull Project project) {
            if (project == null) {
                TestDataGroupNavigationElement.$$$reportNull$$$0(0);
            }
            new OpenFileDescriptor(project, (VirtualFile)this.myGroup).navigate(true);
        }

        @Override
        @Nullable
        public Icon getIcon() {
            return AllIcons.Nodes.TestSourceFolder;
        }

        @Override
        @NotNull
        public List<Pair<String, SimpleTextAttributes>> getTitleFragments() {
            VirtualFile beforeFile = this.myGroup.getBeforeFile();
            VirtualFile afterFile = this.myGroup.getAfterFile();
            String beforeName = beforeFile.getName();
            String afterName = afterFile.getName();
            ArrayList<Pair<String, SimpleTextAttributes>> result = new ArrayList<Pair<String, SimpleTextAttributes>>();
            result.add(new Pair((Object)(TestDataUtil.getGroupDisplayName(beforeName, afterName) + " ("), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
            Pair<String, String> beforeRelativePath = TestDataUtil.getModuleOrProjectRelativeParentPath(this.myProject, beforeFile);
            Pair<String, String> afterRelativePath = TestDataUtil.getModuleOrProjectRelativeParentPath(this.myProject, afterFile);
            if (beforeRelativePath != null && afterRelativePath != null) {
                String beforeBase = (String)beforeRelativePath.getFirst();
                String afterBase = (String)afterRelativePath.getFirst();
                String beforeBaseRelativePath = (String)beforeRelativePath.getSecond();
                String afterBaseRelativePath = (String)afterRelativePath.getSecond();
                if (beforeBase.equals(afterBase)) {
                    result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)beforeBase, (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                    if (beforeBaseRelativePath.equals(afterBaseRelativePath)) {
                        result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)("/" + beforeBaseRelativePath + "/)"), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                    } else {
                        result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)"/", (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                        String commonPrefix = StringUtil.commonPrefix((String)beforeBaseRelativePath, (String)afterBaseRelativePath);
                        if (!commonPrefix.isEmpty()) {
                            result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)commonPrefix, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                        }
                        String beforeUniqueSuffix = beforeBaseRelativePath.substring(commonPrefix.length());
                        String afterUniqueSuffix = afterBaseRelativePath.substring(commonPrefix.length());
                        result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)("<" + beforeUniqueSuffix + "/, " + afterUniqueSuffix + "/>"), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                    }
                } else {
                    result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)beforeBase, (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                    result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)("/" + beforeBaseRelativePath + "/, "), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                    result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)afterBase, (Object)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
                    result.add((Pair<String, SimpleTextAttributes>)new Pair((Object)("/" + afterBaseRelativePath + "/"), (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                }
            }
            ArrayList<Pair<String, SimpleTextAttributes>> arrayList = result;
            if (arrayList == null) {
                TestDataGroupNavigationElement.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationElementFactory$TestDataGroupNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationElementFactory$TestDataGroupNavigationElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitleFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "performAction";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class CreateMissingTestDataFilesNavigationElement
    implements TestDataNavigationElement {
        private final List<String> myFilePaths;

        private CreateMissingTestDataFilesNavigationElement(List<String> filePaths) {
            this.myFilePaths = filePaths;
        }

        @Override
        public void performAction(@NotNull Project project) {
            if (project == null) {
                CreateMissingTestDataFilesNavigationElement.$$$reportNull$$$0(0);
            }
            HashSet<String> filePathsToCreate = new HashSet<String>();
            for (String string : this.myFilePaths) {
                if (LocalFileSystem.getInstance().refreshAndFindFileByPath(string) != null) continue;
                filePathsToCreate.add(string);
            }
            if (filePathsToCreate.size() > 3) {
                ArrayList<String> displayPaths = new ArrayList<String>();
                for (String path3 : filePathsToCreate) {
                    displayPaths.add(TestDataUtil.getHtmlDisplayPathForMissingFile(project, path3));
                }
                displayPaths.sort(String.CASE_INSENSITIVE_ORDER);
                String string = StringUtil.join(displayPaths, (String)"\n");
                int code = Messages.showOkCancelDialog((Project)project, (String)DevKitBundle.message("testdata.confirm.create.missing.files.dialog.message", string), (String)DevKitBundle.message("testdata.create.missing.files", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (code != 0) {
                    return;
                }
            }
            filePathsToCreate.forEach(path -> {
                if (project == null) {
                    CreateMissingTestDataFilesNavigationElement.$$$reportNull$$$0(2);
                }
                VirtualFile file = TestDataUtil.createFileByName(project, path);
                new OpenFileDescriptor(project, file).navigate(true);
            });
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        @NotNull
        public List<Pair<String, SimpleTextAttributes>> getTitleFragments() {
            List<Pair<String, SimpleTextAttributes>> list = Collections.singletonList(new Pair((Object)DevKitBundle.message("testdata.create.missing.files", new Object[0]), (Object)SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
            if (list == null) {
                CreateMissingTestDataFilesNavigationElement.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationElementFactory$CreateMissingTestDataFilesNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataNavigationElementFactory$CreateMissingTestDataFilesNavigationElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitleFragments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "performAction";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$performAction$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

