/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.model.common;

import com.intellij.jsf.model.common.JsfCommonConverter;
import com.intellij.jsf.model.common.JsfConvertersDiscoverer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JsfPredefinedConvertersDiscoverer
implements JsfConvertersDiscoverer {
    private static Set<Trinity<String, String, String>> set = new HashSet<Trinity<String, String, String>>();
    private static final Key<CachedValue<Set<JsfCommonConverter>>> CONVERTERS_VARS = Key.create((String)"jsf predefined converters");

    @Override
    public void addJsfConverters(@NotNull Module module, @NotNull Set<JsfCommonConverter> converters) {
        CachedValue cachedVars;
        if (module == null) {
            JsfPredefinedConvertersDiscoverer.$$$reportNull$$$0(0);
        }
        if (converters == null) {
            JsfPredefinedConvertersDiscoverer.$$$reportNull$$$0(1);
        }
        if ((cachedVars = (CachedValue)module.getUserData(CONVERTERS_VARS)) == null) {
            cachedVars = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> {
                if (module == null) {
                    JsfPredefinedConvertersDiscoverer.$$$reportNull$$$0(7);
                }
                HashSet<JsfCommonConverter> converterSet = new HashSet<JsfCommonConverter>();
                for (Trinity<String, String, String> entry : set) {
                    converterSet.add(JsfPredefinedConvertersDiscoverer.createConverter((String)entry.first, (String)entry.second, (String)entry.third, module));
                }
                return CachedValueProvider.Result.create(converterSet, (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject()), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }, false);
            module.putUserData(CONVERTERS_VARS, (Object)cachedVars);
        }
        converters.addAll((Collection)cachedVars.getValue());
    }

    @NotNull
    private static JsfCommonConverter createConverter(final @NotNull String converterId, @NotNull String converterClass, @NotNull String converterForClass, @NotNull Module module) {
        if (converterId == null) {
            JsfPredefinedConvertersDiscoverer.$$$reportNull$$$0(2);
        }
        if (converterClass == null) {
            JsfPredefinedConvertersDiscoverer.$$$reportNull$$$0(3);
        }
        if (converterForClass == null) {
            JsfPredefinedConvertersDiscoverer.$$$reportNull$$$0(4);
        }
        if (module == null) {
            JsfPredefinedConvertersDiscoverer.$$$reportNull$$$0(5);
        }
        final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        final PsiClass converterPsiClass = facade.findClass(converterClass, GlobalSearchScope.moduleWithLibrariesScope((Module)module));
        final PsiClass converterForPsiClass = facade.findClass(converterForClass, GlobalSearchScope.moduleWithLibrariesScope((Module)module));
        JsfCommonConverter jsfCommonConverter = new JsfCommonConverter(){

            @Override
            public String getConverterId() {
                return converterId;
            }

            @Override
            public PsiType getForClass() {
                return converterForPsiClass == null ? null : facade.getElementFactory().createType(converterForPsiClass);
            }

            @Override
            public PsiElement getIdentifyingElement() {
                return converterPsiClass;
            }
        };
        if (jsfCommonConverter == null) {
            JsfPredefinedConvertersDiscoverer.$$$reportNull$$$0(6);
        }
        return jsfCommonConverter;
    }

    static {
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.BigDecimal", (Object)"javax.faces.convert.BigDecimalConverter", (Object)BigDecimal.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.BigInteger", (Object)"javax.faces.convert.BigIntegerConverter", (Object)BigInteger.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Boolean", (Object)"javax.faces.convert.BooleanConverter", (Object)Boolean.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Byte", (Object)"javax.faces.convert.ByteConverter", (Object)Byte.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Character", (Object)"javax.faces.convert.CharacterConverter", (Object)Character.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.DateTime", (Object)"javax.faces.convert.DateTimeConverter", (Object)""));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Double", (Object)"javax.faces.convert.DoubleConverter", (Object)Double.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Enum", (Object)"javax.faces.convert.EnumConverter", (Object)Enum.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Float", (Object)"javax.faces.convert.FloatConverter", (Object)Float.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Integer", (Object)"javax.faces.convert.IntegerConverter", (Object)Integer.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Long", (Object)"javax.faces.convert.LongConverter", (Object)Long.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Number", (Object)"javax.faces.convert.NumberConverter", (Object)Number.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Short", (Object)"javax.faces.convert.ShortConverter", (Object)Short.class.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converterId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converterClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converterForClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsf/model/common/JsfPredefinedConvertersDiscoverer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsf/model/common/JsfPredefinedConvertersDiscoverer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addJsfConverters";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createConverter";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addJsfConverters$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

