/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph;

import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFacesGraphDataModel
extends GraphDataModel<String, NavigationCase> {
    public static final String EMPTY_NODE = "EMPTY_NODE";
    private final FacesConfig myFacesConfig;
    private final Collection<String> myNodes = new HashSet<String>();
    private final Collection<NavigationCase> myEdges = new HashSet<NavigationCase>();
    private final HashMap<NavigationCase, Pair<String, String>> myEdgeEnds = new HashMap();

    public AbstractFacesGraphDataModel(FacesConfig facesConfig) {
        this.myFacesConfig = facesConfig;
    }

    @NotNull
    public Collection<String> getNodes() {
        this.refreshDataModel();
        Collection<String> collection = this.myNodes;
        if (collection == null) {
            AbstractFacesGraphDataModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<NavigationCase> getEdges() {
        Collection<NavigationCase> collection = this.myEdges;
        if (collection == null) {
            AbstractFacesGraphDataModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public String getSourceNode(NavigationCase navigationCase) {
        return (String)this.myEdgeEnds.get(navigationCase).getFirst();
    }

    public String getTargetNode(NavigationCase navigationCase) {
        return (String)this.myEdgeEnds.get(navigationCase).getSecond();
    }

    public String getNodeName(String s) {
        return s;
    }

    @NotNull
    public String getEdgeName(NavigationCase navigationCase) {
        String result = "";
        if (navigationCase.isValid()) {
            String outcome;
            String fromAction = navigationCase.getFromAction().getStringValue();
            if (fromAction != null) {
                result = fromAction;
            }
            if ((outcome = navigationCase.getFromOutcome().getStringValue()) != null) {
                result = result.length() == 0 ? outcome : result + "/" + outcome;
            }
        }
        String string = result;
        if (string == null) {
            AbstractFacesGraphDataModel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void refreshDataModel() {
        this.clearAll();
        this.updateDataModel();
    }

    public abstract void updateDataModel();

    private void clearAll() {
        this.myNodes.clear();
        this.myEdges.clear();
        this.myEdgeEnds.clear();
    }

    protected void addNode(String node) {
        this.myNodes.add(node);
    }

    protected void addEdge(NavigationCase edge, String from, String to) {
        this.myEdges.add(edge);
        this.myEdgeEnds.put(edge, (Pair<String, String>)Pair.create((Object)from, (Object)to));
    }

    public FacesConfig getFacesConfig() {
        return this.myFacesConfig;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jsf/yfilesGraph/AbstractFacesGraphDataModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

