/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph.renderer;

import com.intellij.jsf.yfilesGraph.renderer.BasicPageTreeNode;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import icons.J2EEIcons;
import java.awt.event.InputEvent;
import org.jetbrains.annotations.NotNull;

public class ManagedBeanNode
extends BasicPageTreeNode {
    private final XmlTag myTag;

    public ManagedBeanNode(XmlTag tag) {
        assert (tag.getName().equals("managed-bean"));
        this.myTag = tag;
    }

    protected void doUpdate() {
        XmlTag nameTag = this.myTag.findFirstSubTag("managed-bean-name");
        String text = nameTag != null ? nameTag.getValue().getTrimmedText() : "";
        this.setPlainText(text.length() == 0 ? "no name" : text);
        this.setUniformIcon(J2EEIcons.ManagedBean);
    }

    public SimpleNode[] getChildren() {
        return NO_CHILDREN;
    }

    @NotNull
    public Object[] getEqualityObjects() {
        if (NONE == null) {
            ManagedBeanNode.$$$reportNull$$$0(0);
        }
        return NONE;
    }

    @Override
    public boolean canGotoSource() {
        return this.getPsiClass() != null;
    }

    @Override
    public boolean canGotoDeclaration() {
        return true;
    }

    @Override
    public void gotoSource() {
        PsiClass psiClass = this.getPsiClass();
        if (psiClass != null) {
            FileEditorManager.getInstance((Project)this.myTag.getProject()).openTextEditor(new OpenFileDescriptor(this.myTag.getProject(), psiClass.getContainingFile().getVirtualFile()), true);
        }
    }

    @Override
    public void gotoDeclaration() {
        VirtualFile file = this.myTag.getContainingFile().getVirtualFile();
        int offset = this.myTag.getTextOffset();
        FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.myTag.getProject());
        editorManager.openTextEditor(new OpenFileDescriptor(this.getProject(), file, offset), true);
    }

    private PsiClass getPsiClass() {
        String clazz;
        XmlTag classTag = this.myTag.findFirstSubTag("managed-bean-class");
        if (classTag != null && (clazz = classTag.getValue().getTrimmedText()).length() != 0) {
            return JavaPsiFacade.getInstance((Project)this.myTag.getProject()).findClass(clazz, GlobalSearchScope.allScope((Project)this.myTag.getProject()));
        }
        return null;
    }

    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        this.gotoDeclaration();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/renderer/ManagedBeanNode", "getEqualityObjects"));
    }
}

