/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.dependencies;

import com.intellij.cdi.dependencies.CdiDependenciesDataModel;
import com.intellij.cdi.dependencies.edges.CdiEdge;
import com.intellij.cdi.dependencies.edges.CdiEdgeType;
import com.intellij.cdi.dependencies.edges.CdiInjectionPointEdge;
import com.intellij.cdi.dependencies.edges.CdiProducerEdge;
import com.intellij.cdi.dependencies.nodes.CdiDescriptorNode;
import com.intellij.cdi.dependencies.nodes.CdiManagedBeanDescriptorNode;
import com.intellij.cdi.dependencies.nodes.CdiNode;
import com.intellij.cdi.dependencies.nodes.CdiProducerDescriptorNode;
import com.intellij.cdi.dependencies.nodes.CdiProductTypeDescriptorNode;
import com.intellij.cdi.dependencies.nodes.CdiPsiClassNode;
import com.intellij.cdi.dependencies.renderers.CdiNodeRenderer;
import com.intellij.cdi.dependencies.renderers.CdiProducerNodeRenderer;
import com.intellij.cdi.dependencies.renderers.CdiProductTypeNodeRenderer;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.SelectionDependenciesPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Arrow;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LineType;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PolyLineEdgeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.OpenSourceUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiDependenciesPresentation
extends SelectionDependenciesPresentationModel<CdiNode, CdiEdge> {
    private final Project myProject;
    private final CdiDependenciesDataModel myDataModel;
    private CdiNodeRenderer myRenderer;
    private CdiProducerNodeRenderer myProducerRenderer;
    private CdiProductTypeNodeRenderer myProductTypeRenderer;

    public CdiDependenciesPresentation(Graph2D graph, CdiDependenciesDataModel dataModel) {
        super((Graph)graph, false);
        this.myDataModel = dataModel;
        this.myProject = dataModel.getPsiClass().getProject();
        this.setShowEdgeLabels(true);
    }

    @NotNull
    public NodeRealizer getNodeRealizer(CdiNode node) {
        NodeRealizer nodeRealizer = GraphViewUtil.createNodeRealizer((String)"CdiNodeRenderer", (NodeCellRenderer)this.getNodeCellRenderer(node));
        if (nodeRealizer == null) {
            CdiDependenciesPresentation.$$$reportNull$$$0(0);
        }
        return nodeRealizer;
    }

    private NodeCellRenderer getNodeCellRenderer(CdiNode node) {
        if (node instanceof CdiProducerDescriptorNode) {
            return this.getProducerRenderer();
        }
        if (node instanceof CdiProductTypeDescriptorNode) {
            return this.getProductTypeRenderer();
        }
        return this.getCommonRenderer();
    }

    private NodeCellRenderer getProductTypeRenderer() {
        if (this.myProductTypeRenderer == null) {
            this.myProductTypeRenderer = new CdiProductTypeNodeRenderer((GraphBuilder<CdiNode, CdiEdge>)this.getGraphBuilder(), this.getModificationTracker());
        }
        return this.myProductTypeRenderer;
    }

    private NodeCellRenderer getCommonRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new CdiNodeRenderer((GraphBuilder<CdiNode, CdiEdge>)this.getGraphBuilder(), this.getModificationTracker());
        }
        return this.myRenderer;
    }

    private NodeCellRenderer getProducerRenderer() {
        if (this.myProducerRenderer == null) {
            this.myProducerRenderer = new CdiProducerNodeRenderer((GraphBuilder<CdiNode, CdiEdge>)this.getGraphBuilder(), this.getModificationTracker());
        }
        return this.myProducerRenderer;
    }

    public ModificationTracker getModificationTracker() {
        return PsiManager.getInstance((Project)this.getProject()).getModificationTracker();
    }

    @NotNull
    public EdgeRealizer getEdgeRealizer(@Nullable CdiEdge edge) {
        PolyLineEdgeRealizer edgeRealizer = GraphManager.getGraphManager().createPolyLineEdgeRealizer();
        edgeRealizer.setLineType(LineType.LINE_1);
        if (edge == null) {
            PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
            if (polyLineEdgeRealizer == null) {
                CdiDependenciesPresentation.$$$reportNull$$$0(1);
            }
            return polyLineEdgeRealizer;
        }
        CdiEdgeType edgeType = edge.getType();
        switch (edgeType) {
            case PRODUCES: {
                edgeRealizer.setLineColor(JBColor.BLUE.darker());
                edgeRealizer.setTargetArrow(Arrow.WHITE_DELTA);
                edgeRealizer.setSourceArrow(Arrow.NONE);
                edgeRealizer.setLineType(LineType.DASHED_1);
                break;
            }
            default: {
                edgeRealizer.setLineType(LineType.LINE_1);
                edgeRealizer.setLineColor((Color)(edge.isValidDependency() ? JBColor.GRAY : JBColor.RED.darker()));
                edgeRealizer.setArrow(Arrow.STANDARD);
            }
        }
        PolyLineEdgeRealizer polyLineEdgeRealizer = edgeRealizer;
        if (polyLineEdgeRealizer == null) {
            CdiDependenciesPresentation.$$$reportNull$$$0(2);
        }
        return polyLineEdgeRealizer;
    }

    public boolean editEdge(CdiEdge cdiEdge) {
        Object element;
        if (cdiEdge != null && (element = cdiEdge.getIdentifyingElement()) instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)element});
            return true;
        }
        return super.editEdge((Object)cdiEdge);
    }

    public boolean editNode(CdiNode cdiNode) {
        Object element;
        if (cdiNode != null && (element = cdiNode.getIdentifyingElement()) instanceof Navigatable) {
            OpenSourceUtil.navigate((Navigatable[])new Navigatable[]{(Navigatable)element});
            return true;
        }
        return super.editNode((Object)cdiNode);
    }

    public String getEdgeTooltip(@Nullable CdiEdge cdiEdge) {
        if (cdiEdge != null) {
            if (cdiEdge instanceof CdiInjectionPointEdge) {
                PsiParameter psiParameter;
                PsiMethod psiMethod;
                CdiInjectionPointEdge injectionPointEdge = (CdiInjectionPointEdge)cdiEdge;
                PsiElement identifyingElement = injectionPointEdge.getIdentifyingElement();
                if (identifyingElement instanceof PsiField) {
                    return CdiDependenciesPresentation.formatPsiField((PsiField)identifyingElement);
                }
                if (identifyingElement instanceof PsiParameter && (psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(psiParameter = (PsiParameter)identifyingElement), PsiMethod.class)) != null) {
                    return CdiDependenciesPresentation.formatMethod(psiMethod, psiParameter, false);
                }
            } else if (cdiEdge instanceof CdiProducerEdge) {
                CdiProducerEdge producerEdge = (CdiProducerEdge)cdiEdge;
                PsiElement element = producerEdge.getIdentifyingElement();
                if (element instanceof PsiField) {
                    return element.getText();
                }
                if (element instanceof PsiMethod) {
                    return CdiDependenciesPresentation.formatMethod((PsiMethod)element, null, true);
                }
            }
        }
        return super.getEdgeTooltip((Object)cdiEdge);
    }

    private static String formatPsiField(PsiField psiField) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append(psiField.getText());
        buffer.append("</html>");
        return buffer.toString();
    }

    private static String formatMethod(@NotNull PsiMethod method, @Nullable PsiParameter highlightParameter, boolean highlightReturnType) {
        PsiClass containingClass;
        if (method == null) {
            CdiDependenciesPresentation.$$$reportNull$$$0(3);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        for (PsiAnnotation psiAnnotation : method.getModifierList().getAnnotations()) {
            String fqName = psiAnnotation.getQualifiedName();
            if (fqName == null) continue;
            if (highlightReturnType) {
                buffer.append("<strong>");
            }
            buffer.append("@");
            buffer.append(StringUtil.getShortName((String)fqName));
            if (highlightReturnType) {
                buffer.append("</strong>");
            }
            buffer.append("<br>");
        }
        PsiType returnType = method.getReturnType();
        if (returnType != null) {
            if (highlightReturnType) {
                buffer.append("<strong>");
            }
            buffer.append(returnType.getPresentableText());
            buffer.append(" ");
            if (highlightReturnType) {
                buffer.append("</strong>");
            }
        }
        if ((containingClass = method.getContainingClass()) != null) {
            buffer.append(containingClass.getName());
            buffer.append("");
        }
        buffer.append(method.getName());
        buffer.append("(");
        PsiParameter[] psiParameters = method.getParameterList().getParameters();
        for (int i = 0; i < psiParameters.length; ++i) {
            PsiParameter psiParameter;
            if (i != 0) {
                buffer.append(", ");
            }
            if ((psiParameter = psiParameters[i]).equals(highlightParameter)) {
                buffer.append("<strong>");
                buffer.append(psiParameter.getText());
                buffer.append("</strong>");
                continue;
            }
            buffer.append(psiParameter.getText());
        }
        buffer.append(") {...}");
        buffer.append("</html>");
        return buffer.toString();
    }

    private static String formatPsiClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiDependenciesPresentation.$$$reportNull$$$0(4);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation psiAnnotation : modifierList.getAnnotations()) {
                String fqName = psiAnnotation.getQualifiedName();
                if (fqName == null) continue;
                buffer.append("@");
                buffer.append(StringUtil.getShortName((String)fqName));
                buffer.append("<br>");
            }
        }
        buffer.append(psiClass.getQualifiedName());
        return buffer.toString();
    }

    public String getNodeTooltip(@Nullable CdiNode cdiNode) {
        CdiManagedBeanDescriptorNode descriptorNodeCdi;
        PsiMember member;
        if (cdiNode instanceof CdiPsiClassNode) {
            return CdiDependenciesPresentation.formatPsiClass(((CdiPsiClassNode)cdiNode).getIdentifyingElement());
        }
        if (cdiNode instanceof CdiProducerDescriptorNode || cdiNode instanceof CdiProductTypeDescriptorNode) {
            Object member2 = ((CdiDescriptorNode)cdiNode).getBeanDescriptor().getIdentifyingElement();
            if (member2 instanceof PsiField) {
                return CdiDependenciesPresentation.formatPsiField((PsiField)member2);
            }
            if (member2 instanceof PsiMethod) {
                return CdiDependenciesPresentation.formatMethod((PsiMethod)member2, null, true);
            }
        } else if (cdiNode instanceof CdiManagedBeanDescriptorNode && (member = (descriptorNodeCdi = (CdiManagedBeanDescriptorNode)cdiNode).getIdentifyingElement()) instanceof PsiClass) {
            return CdiDependenciesPresentation.formatPsiClass((PsiClass)member);
        }
        return super.getNodeTooltip((Object)cdiNode);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void customizeSettings(Graph2DView view, EditMode editMode) {
        view.setAntialiasedPainting(false);
        editMode.allowEdgeCreation(false);
        editMode.allowBendCreation(false);
        editMode.setPopupMode(null);
        editMode.allowMoveSelection(false);
        view.setFitContentOnResize(false);
        view.setGridVisible(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/dependencies/CdiDependenciesPresentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeRealizer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeRealizer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/dependencies/CdiDependenciesPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "formatPsiClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

