/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionValidator {
    public static final ExtensionPointName<InspectionValidator> EP_NAME = ExtensionPointName.create((String)"com.intellij.compiler.inspectionValidator");
    private final String myDescription;
    private final String myProgressIndicatorText;
    @Nullable
    private final Class<? extends LocalInspectionTool>[] myInspectionToolClasses;
    @Nullable
    private final InspectionToolProvider myInspectionToolProvider;

    protected InspectionValidator(@NotNull String description, @NotNull String progressIndicatorText) {
        if (description == null) {
            InspectionValidator.$$$reportNull$$$0(0);
        }
        if (progressIndicatorText == null) {
            InspectionValidator.$$$reportNull$$$0(1);
        }
        this.myDescription = description;
        this.myProgressIndicatorText = progressIndicatorText;
        this.myInspectionToolClasses = null;
        this.myInspectionToolProvider = null;
    }

    @SafeVarargs
    protected InspectionValidator(@NotNull String description, @NotNull String progressIndicatorText, Class<? extends LocalInspectionTool> ... inspectionToolClasses) {
        if (description == null) {
            InspectionValidator.$$$reportNull$$$0(2);
        }
        if (progressIndicatorText == null) {
            InspectionValidator.$$$reportNull$$$0(3);
        }
        this.myDescription = description;
        this.myProgressIndicatorText = progressIndicatorText;
        this.myInspectionToolClasses = inspectionToolClasses;
        this.myInspectionToolProvider = null;
    }

    protected InspectionValidator(@NotNull String description, @NotNull String progressIndicatorText, InspectionToolProvider provider) {
        if (description == null) {
            InspectionValidator.$$$reportNull$$$0(4);
        }
        if (progressIndicatorText == null) {
            InspectionValidator.$$$reportNull$$$0(5);
        }
        this.myDescription = description;
        this.myProgressIndicatorText = progressIndicatorText;
        this.myInspectionToolClasses = null;
        this.myInspectionToolProvider = provider;
    }

    protected InspectionValidator(@NotNull String description, @NotNull String progressIndicatorText, Class<? extends InspectionToolProvider> providerClass) throws IllegalAccessException, InstantiationException {
        if (description == null) {
            InspectionValidator.$$$reportNull$$$0(6);
        }
        if (progressIndicatorText == null) {
            InspectionValidator.$$$reportNull$$$0(7);
        }
        this(description, progressIndicatorText, providerClass.newInstance());
    }

    public abstract boolean isAvailableOnScope(@NotNull CompileScope var1);

    public abstract Collection<VirtualFile> getFilesToProcess(Project var1, CompileContext var2);

    @NotNull
    public Collection<? extends PsiElement> getDependencies(PsiFile psiFile) {
        List list = Collections.emptyList();
        if (list == null) {
            InspectionValidator.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        if (this.myInspectionToolClasses != null) {
            if (this.myInspectionToolClasses == null) {
                InspectionValidator.$$$reportNull$$$0(9);
            }
            return this.myInspectionToolClasses;
        }
        assert (this.myInspectionToolProvider != null) : "getInspectionToolClasses() must be overridden";
        Class[] classArray = this.myInspectionToolProvider.getInspectionClasses();
        if (classArray == null) {
            InspectionValidator.$$$reportNull$$$0(10);
        }
        return classArray;
    }

    public final String getDescription() {
        return this.myDescription;
    }

    public final String getProgressIndicatorText() {
        return this.myProgressIndicatorText;
    }

    public CompilerMessageCategory getCategoryByHighlightDisplayLevel(@NotNull HighlightDisplayLevel severity, @NotNull VirtualFile virtualFile, @NotNull CompileContext context) {
        if (severity == null) {
            InspectionValidator.$$$reportNull$$$0(11);
        }
        if (virtualFile == null) {
            InspectionValidator.$$$reportNull$$$0(12);
        }
        if (context == null) {
            InspectionValidator.$$$reportNull$$$0(13);
        }
        if (severity == HighlightDisplayLevel.ERROR) {
            return CompilerMessageCategory.ERROR;
        }
        if (severity == HighlightDisplayLevel.WARNING) {
            return CompilerMessageCategory.WARNING;
        }
        return CompilerMessageCategory.INFORMATION;
    }

    @NotNull
    public Map<ProblemDescriptor, HighlightDisplayLevel> checkAdditionally(PsiFile file) {
        Map<ProblemDescriptor, HighlightDisplayLevel> map = Collections.emptyMap();
        if (map == null) {
            InspectionValidator.$$$reportNull$$$0(14);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicatorText";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/compiler/util/InspectionValidator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/compiler/util/InspectionValidator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionToolClasses";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAdditionally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCategoryByHighlightDisplayLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

