/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.model;

import com.android.layoutinspector.model.ViewNode;
import com.android.layoutinspector.model.ViewProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ViewNodeTableModel
implements TableModel {
    private final List<TableModelListener> mListeners = Lists.newArrayList();
    private final List<ViewProperty> mEntries = Lists.newArrayList();
    private final Map<String, List<ViewProperty>> mGroupedProperties = Maps.newHashMap();

    public void setNode(ViewNode node) {
        this.mEntries.clear();
        this.mEntries.addAll(node.properties);
        this.mGroupedProperties.clear();
        this.mGroupedProperties.putAll(node.groupedProperties);
        this.notifyChange(new TableModelEvent(this));
    }

    @Override
    public int getRowCount() {
        return this.mEntries.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columnIndex == 0 ? "Property" : "Value";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ViewProperty p = this.mEntries.get(rowIndex);
        return columnIndex == 0 ? p.name : p.getValue();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.mListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.mListeners.remove(l);
    }

    private void notifyChange(TableModelEvent event) {
        for (TableModelListener l : this.mListeners) {
            l.tableChanged(event);
        }
    }

    public Map<String, List<ViewProperty>> getGroupedProperties() {
        return this.mGroupedProperties;
    }
}

