/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.model;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Objects;

public class ViewProperty
implements Comparable<ViewProperty> {
    private static final Comparator<String> CATEGORY_COMPARATOR = Ordering.natural().nullsFirst();
    public final String fullName;
    public final String name;
    public final String category;
    private String myValue;

    ViewProperty(String fullName) {
        this.fullName = fullName;
        int colonIndex = fullName.indexOf(58);
        if (colonIndex != -1) {
            this.category = fullName.substring(0, colonIndex);
            this.name = fullName.substring(colonIndex + 1);
        } else {
            this.category = null;
            this.name = fullName;
        }
    }

    public String toString() {
        return this.fullName + '=' + this.myValue;
    }

    @Override
    public int compareTo(ViewProperty other) {
        return ComparisonChain.start().compare((Object)this.category, (Object)other.category, CATEGORY_COMPARATOR).compare((Comparable)((Object)this.name), (Comparable)((Object)other.name)).result();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ViewProperty)) {
            return false;
        }
        ViewProperty other = (ViewProperty)obj;
        return Objects.equals(this.category, other.category) && this.name.equals(other.name);
    }

    public void setValue(String value) {
        this.myValue = value;
    }

    public String getValue() {
        return this.myValue;
    }
}

