/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.SdkInfo;
import com.google.common.annotations.Beta;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/client/api/DefaultSdkInfo;", "Lcom/android/tools/lint/client/api/SdkInfo;", "()V", "getInterface", "", "cls", "getParent", "layout", "getParentViewClass", "fqcn", "getParentViewName", "name", "getRawType", "type", "implementsInterface", "", "className", "interfaceName", "isLayout", "tag", "isSubViewOf", "parentViewFqcn", "childViewFqcn", "android.sdktools.lint-api"})
@Beta
public final class DefaultSdkInfo
extends SdkInfo {
    @Override
    @Nullable
    public String getParentViewName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String string = this.getRawType(name);
        if (string == null) {
            return null;
        }
        String rawType = string;
        return this.getParent(rawType);
    }

    @Override
    @Nullable
    public String getParentViewClass(@NotNull String fqcn) {
        Intrinsics.checkParameterIsNotNull((Object)fqcn, (String)"fqcn");
        String simpleName = fqcn;
        int index = StringsKt.lastIndexOf$default((CharSequence)simpleName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (index != -1) {
            String string = simpleName;
            int n = index + 1;
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            simpleName = string2;
        }
        String string = this.getParent(simpleName);
        if (string == null) {
            return null;
        }
        String parent = string;
        return Intrinsics.areEqual((Object)parent, (Object)"View") || Intrinsics.areEqual((Object)parent, (Object)"ViewGroup") || Intrinsics.areEqual((Object)parent, (Object)"SurfaceView") ? "android.view." + parent : "android.widget." + parent;
    }

    @Override
    public boolean isSubViewOf(@NotNull String parentViewFqcn, @NotNull String childViewFqcn) {
        int n;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)parentViewFqcn, (String)"parentViewFqcn");
        Intrinsics.checkParameterIsNotNull((Object)childViewFqcn, (String)"childViewFqcn");
        String string2 = this.getRawType(parentViewFqcn);
        if (string2 == null) {
            return false;
        }
        String parent = string2;
        String child = this.getRawType(childViewFqcn);
        if (StringsKt.indexOf$default((CharSequence)parent, (char)'.', (int)0, (boolean)false, (int)6, null) != -1) {
            string = parent;
            n = StringsKt.lastIndexOf$default((CharSequence)parent, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            String string3 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            parent = string4;
        }
        String string5 = child;
        if (string5 == null) {
            Intrinsics.throwNpe();
        }
        if (StringsKt.indexOf$default((CharSequence)string5, (char)'.', (int)0, (boolean)false, (int)6, null) != -1) {
            string = child;
            n = StringsKt.lastIndexOf$default((CharSequence)child, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
            String string6 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            child = string6;
        }
        if (Intrinsics.areEqual((Object)parent, (Object)"View")) {
            return true;
        }
        while (Intrinsics.areEqual((Object)child, (Object)"View") ^ true) {
            if (Intrinsics.areEqual((Object)parent, (Object)child)) {
                return true;
            }
            String string7 = child;
            if (string7 == null) {
                Intrinsics.throwNpe();
            }
            if (this.implementsInterface(string7, parent)) {
                return true;
            }
            if ((child = this.getParent(child)) != null) continue;
            return true;
        }
        return false;
    }

    private final boolean implementsInterface(String className, String interfaceName) {
        return Intrinsics.areEqual((Object)interfaceName, (Object)this.getInterface(className));
    }

    private final String getRawType(String type) {
        int index;
        if (type != null && (index = StringsKt.indexOf$default((CharSequence)type, (char)'<', (int)0, (boolean)false, (int)6, null)) != -1) {
            String string = type;
            int n = 0;
            String string2 = string.substring(n, index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string2;
        }
        return type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLayout(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (super.isLayout(tag)) {
            return true;
        }
        String string = tag;
        switch (string.hashCode()) {
            case 2114116224: {
                if (!string.equals("MediaController")) return false;
                return true;
            }
            case 1205660831: {
                if (!string.equals("SlidingDrawer")) return false;
                return true;
            }
            case 1969230692: {
                if (!string.equals("RadioGroup")) return false;
                return true;
            }
            case 110685885: {
                if (!string.equals("TabHost")) return false;
                return true;
            }
            case 2079947068: {
                if (!string.equals("ImageSwitcher")) return false;
                return true;
            }
            case -581606887: {
                if (!string.equals("TabWidget")) return false;
                return true;
            }
            case 1204826236: {
                if (!string.equals("AdapterViewFlipper")) return false;
                return true;
            }
            case -217496378: {
                if (!string.equals("ViewSwitcher")) return false;
                return true;
            }
            case 1098563093: {
                if (!string.equals("DialerFilter")) return false;
                return true;
            }
            case 886763275: {
                if (!string.equals("ViewFlipper")) return false;
                return true;
            }
            case 1410352259: {
                if (!string.equals("ListView")) return false;
                return true;
            }
            case -927422260: {
                if (!string.equals("ViewAnimator")) return false;
                return true;
            }
            case 2059813682: {
                if (!string.equals("ScrollView")) return false;
                return true;
            }
            case 1283054733: {
                if (!string.equals("SearchView")) return false;
                return true;
            }
            case -830787764: {
                if (!string.equals("TableRow")) return false;
                return true;
            }
            case -189184178: {
                if (!string.equals("TextSwitcher")) return false;
                return true;
            }
            case 382765867: {
                if (!string.equals("GridView")) return false;
                return true;
            }
            case -563016403: {
                if (!string.equals("StackView")) return false;
                return true;
            }
            case -1125439882: {
                if (!string.equals("HorizontalScrollView")) return false;
                return true;
            }
            case -1958124649: {
                if (!string.equals("ExpandableListView")) return false;
                return true;
            }
        }
        return false;
    }

    private final String getParent(String layout) {
        switch (layout) {
            case "CompoundButton": {
                return "Button";
            }
            case "AbsSpinner": {
                return "AdapterView";
            }
            case "AbsListView": {
                return "AdapterView";
            }
            case "AbsSeekBar": {
                return "ProgressBar";
            }
            case "AdapterView": {
                return "ViewGroup";
            }
            case "ViewGroup": {
                return "View";
            }
            case "TextView": {
                return "View";
            }
            case "CheckedTextView": {
                return "TextView";
            }
            case "RadioButton": {
                return "CompoundButton";
            }
            case "Spinner": {
                return "AbsSpinner";
            }
            case "ImageButton": {
                return "ImageView";
            }
            case "ImageView": {
                return "View";
            }
            case "EditText": {
                return "TextView";
            }
            case "ProgressBar": {
                return "View";
            }
            case "ToggleButton": {
                return "CompoundButton";
            }
            case "ViewStub": {
                return "View";
            }
            case "Button": {
                return "TextView";
            }
            case "SeekBar": {
                return "AbsSeekBar";
            }
            case "CheckBox": {
                return "CompoundButton";
            }
            case "Switch": {
                return "CompoundButton";
            }
            case "Gallery": {
                return "AbsSpinner";
            }
            case "SurfaceView": {
                return "View";
            }
            case "AbsoluteLayout": {
                return "ViewGroup";
            }
            case "LinearLayout": {
                return "ViewGroup";
            }
            case "RelativeLayout": {
                return "ViewGroup";
            }
            case "ListView": {
                return "AbsListView";
            }
            case "ViewSwitcher": {
                return "ViewAnimator";
            }
            case "FrameLayout": {
                return "ViewGroup";
            }
            case "HorizontalScrollView": {
                return "FrameLayout";
            }
            case "ViewAnimator": {
                return "FrameLayout";
            }
            case "TabHost": {
                return "FrameLayout";
            }
            case "TableRow": {
                return "LinearLayout";
            }
            case "RadioGroup": {
                return "LinearLayout";
            }
            case "TabWidget": {
                return "LinearLayout";
            }
            case "ExpandableListView": {
                return "ListView";
            }
            case "TableLayout": {
                return "LinearLayout";
            }
            case "ScrollView": {
                return "FrameLayout";
            }
            case "GridView": {
                return "AbsListView";
            }
            case "WebView": {
                return "AbsoluteLayout";
            }
            case "AutoCompleteTextView": {
                return "EditText";
            }
            case "MultiAutoCompleteTextView": {
                return "AutoCompleteTextView";
            }
            case "MediaController": {
                return "FrameLayout";
            }
            case "SlidingDrawer": {
                return "ViewGroup";
            }
            case "DialerFilter": {
                return "RelativeLayout";
            }
            case "DigitalClock": {
                return "TextView";
            }
            case "Chronometer": {
                return "TextView";
            }
            case "ImageSwitcher": {
                return "ViewSwitcher";
            }
            case "TextSwitcher": {
                return "ViewSwitcher";
            }
            case "AnalogClock": {
                return "View";
            }
            case "TwoLineListItem": {
                return "RelativeLayout";
            }
            case "ZoomControls": {
                return "LinearLayout";
            }
            case "DatePicker": {
                return "FrameLayout";
            }
            case "TimePicker": {
                return "FrameLayout";
            }
            case "VideoView": {
                return "SurfaceView";
            }
            case "ZoomButton": {
                return "ImageButton";
            }
            case "RatingBar": {
                return "AbsSeekBar";
            }
            case "ViewFlipper": {
                return "ViewAnimator";
            }
            case "NumberPicker": {
                return "LinearLayout";
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getInterface(String cls) {
        String string = cls;
        switch (string.hashCode()) {
            case -1455429095: {
                if (!string.equals("CheckedTextView")) return null;
                return "Checkable";
            }
            case 1705213149: {
                if (!string.equals("CompoundButton")) return null;
                return "Checkable";
            }
        }
        return null;
    }
}

