/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.google.common.annotations.Beta;
import org.w3c.dom.Element;

@Beta
public abstract class LayoutDetector
extends ResourceXmlDetector {
    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.LAYOUT;
    }

    private static boolean isFillParent(Element element, String dimension) {
        String width = element.getAttributeNS("http://schemas.android.com/apk/res/android", dimension);
        return width.equals("match_parent") || width.equals("fill_parent");
    }

    protected static boolean isWidthFillParent(Element element) {
        return LayoutDetector.isFillParent(element, "layout_width");
    }

    protected static boolean isHeightFillParent(Element element) {
        return LayoutDetector.isFillParent(element, "layout_height");
    }

    protected static boolean hasPadding(Element root) {
        return root.hasAttributeNS("http://schemas.android.com/apk/res/android", "padding") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingLeft") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingRight") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingTop") || root.hasAttributeNS("http://schemas.android.com/apk/res/android", "paddingBottom");
    }
}

