/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api.interprocedural;

import com.android.tools.lint.detector.api.interprocedural.CallGraph;
import com.android.tools.lint.detector.api.interprocedural.CallGraphKt;
import com.android.tools.lint.detector.api.interprocedural.CallTarget;
import com.android.tools.lint.detector.api.interprocedural.MutableCallGraph;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/MutableCallGraph;", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph;", "()V", "nodeMap", "Ljava/util/LinkedHashMap;", "Lcom/intellij/psi/PsiElement;", "Lcom/android/tools/lint/detector/api/interprocedural/MutableCallGraph$MutableNode;", "Lkotlin/collections/LinkedHashMap;", "nodes", "", "getNodes", "()Ljava/util/Collection;", "getNode", "element", "Lorg/jetbrains/uast/UElement;", "toString", "", "MutableNode", "android.sdktools.lint-api"})
public final class MutableCallGraph
implements CallGraph {
    private final LinkedHashMap<PsiElement, MutableNode> nodeMap = new LinkedHashMap();

    @NotNull
    public Collection<MutableNode> getNodes() {
        return this.nodeMap.values();
    }

    @Override
    @NotNull
    public MutableNode getNode(@NotNull UElement element) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        PsiElement psi = element.getPsi();
        if (psi == null) {
            throw (Throwable)new Error("Expected psi for element " + element);
        }
        Map $receiver$iv = this.nodeMap;
        Object value$iv = $receiver$iv.get(psi);
        if (value$iv == null) {
            CallTarget callTarget;
            UElement uElement = element;
            if (uElement instanceof UMethod) {
                callTarget = new CallTarget.Method((UMethod)element);
            } else if (uElement instanceof ULambdaExpression) {
                callTarget = new CallTarget.Lambda((ULambdaExpression)element);
            } else if (uElement instanceof UClass) {
                callTarget = new CallTarget.DefaultCtor((UClass)element);
            } else {
                throw (Throwable)new Error("Unexpected UElement type " + element.getClass());
            }
            CallTarget caller = callTarget;
            MutableNode answer$iv = new MutableNode(caller, null, 2, null);
            $receiver$iv.put(psi, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (MutableNode)object;
    }

    @NotNull
    public String toString() {
        int numEdges2 = SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getNodes()), (Function1)toString.numEdges.1.INSTANCE));
        return "Call graph: " + this.nodeMap.size() + " nodes, " + numEdges2 + " edges";
    }

    @Override
    @NotNull
    public String dump(@NotNull Function1<? super CallGraph.Edge, Boolean> filter) {
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        return CallGraph.DefaultImpls.dump(this, filter);
    }

    @Override
    public void outputToDotFile(@NotNull String file, @NotNull Function1<? super CallGraph.Edge, Boolean> filter) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        CallGraph.DefaultImpls.outputToDotFile(this, file, filter);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/detector/api/interprocedural/MutableCallGraph$MutableNode;", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Node;", "target", "Lcom/android/tools/lint/detector/api/interprocedural/CallTarget;", "edges", "", "Lcom/android/tools/lint/detector/api/interprocedural/CallGraph$Edge;", "(Lcom/android/tools/lint/detector/api/interprocedural/CallTarget;Ljava/util/Collection;)V", "getEdges", "()Ljava/util/Collection;", "getTarget", "()Lcom/android/tools/lint/detector/api/interprocedural/CallTarget;", "toString", "", "android.sdktools.lint-api"})
    public static final class MutableNode
    implements CallGraph.Node {
        @NotNull
        private final CallTarget target;
        @NotNull
        private final Collection<CallGraph.Edge> edges;

        @NotNull
        public String toString() {
            return CallGraphKt.getShortName(this);
        }

        @Override
        @NotNull
        public CallTarget getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public Collection<CallGraph.Edge> getEdges() {
            return this.edges;
        }

        public MutableNode(@NotNull CallTarget target, @NotNull Collection<CallGraph.Edge> edges) {
            Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
            Intrinsics.checkParameterIsNotNull(edges, (String)"edges");
            this.target = target;
            this.edges = edges;
        }

        public /* synthetic */ MutableNode(CallTarget callTarget, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                collection = new ArrayList();
            }
            this(callTarget, collection);
        }

        @Override
        @NotNull
        public Collection<CallGraph.Edge> getLikelyEdges() {
            return CallGraph.Node.DefaultImpls.getLikelyEdges(this);
        }
    }
}

