/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import com.intellij.util.ui.classpath.SimpleClasspathElementFactory;
import com.intellij.util.xmlb.annotations.Tag;
import icons.AndroidIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.android.database.AndroidRemoteDataBaseManager;
import org.jetbrains.annotations.NotNull;

class AndroidDataSource
extends LocalDataSource
implements DatabaseSystem,
ModificationTracker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.database.AndroidDataSource");
    private State myState = new State();

    public AndroidDataSource() {
        super("", "org.sqlite.JDBC", "", null, null);
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            AndroidDataSource.$$$reportNull$$$0(0);
        }
        return state;
    }

    @NotNull
    public State buildFullState() {
        this.myState.name = this.getName();
        this.myState.comment = this.getComment();
        this.myState.classpathElements = this.serializeClasspathElements();
        State state = this.myState;
        if (state == null) {
            AndroidDataSource.$$$reportNull$$$0(1);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            AndroidDataSource.$$$reportNull$$$0(2);
        }
        this.myState = state;
        this.setName(state.name);
        this.setComment(state.comment);
        this.setClasspathElements(this.deserializeClasspathElements());
        this.resetUrl();
    }

    @NotNull
    private Element[] serializeClasspathElements() {
        List elements = this.getClasspathElements();
        if (elements.isEmpty()) {
            Element[] elementArray = new Element[]{};
            if (elementArray == null) {
                AndroidDataSource.$$$reportNull$$$0(3);
            }
            return elementArray;
        }
        Element[] serializedElements = new Element[elements.size()];
        int i = 0;
        for (SimpleClasspathElement element : elements) {
            Element serializedElement = new Element("element");
            try {
                element.serialize(serializedElement);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            serializedElements[i++] = serializedElement;
        }
        if (serializedElements == null) {
            AndroidDataSource.$$$reportNull$$$0(4);
        }
        return serializedElements;
    }

    @NotNull
    private List<SimpleClasspathElement> deserializeClasspathElements() {
        Element[] serializedElements = this.myState.classpathElements;
        if (serializedElements == null || serializedElements.length == 0) {
            List<SimpleClasspathElement> list = Collections.emptyList();
            if (list == null) {
                AndroidDataSource.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<SimpleClasspathElement> elements = new ArrayList<SimpleClasspathElement>(serializedElements.length);
        for (Element serializedElement : serializedElements) {
            elements.addAll(SimpleClasspathElementFactory.createElements(null, (Element)serializedElement));
        }
        ArrayList<SimpleClasspathElement> arrayList = elements;
        if (arrayList == null) {
            AndroidDataSource.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    void resetUrl() {
        this.setUrl(this.buildUrl());
    }

    @NotNull
    public String buildUrl() {
        String path = this.buildLocalDbFileOsPath();
        String string = StringUtil.isEmpty((String)path) ? "" : "jdbc:sqlite:" + FileUtil.toSystemDependentName((String)FileUtil.toCanonicalPath((String)path));
        if (string == null) {
            AndroidDataSource.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String buildLocalDbFileOsPath() {
        State state = this.getState();
        String string = AndroidRemoteDataBaseManager.buildLocalDbFileOsPath(state.deviceId, state.packageName, state.databaseName, state.external);
        if (string == null) {
            AndroidDataSource.$$$reportNull$$$0(8);
        }
        return string;
    }

    public long getModificationCount() {
        return 0L;
    }

    @NotNull
    public AndroidDataSource copy() {
        AndroidDataSource newSource = new AndroidDataSource();
        newSource.setName(this.getName());
        newSource.setDatabaseDriver(this.getDatabaseDriver());
        State newState = newSource.getState();
        State state = this.buildFullState();
        newState.name = state.name;
        newState.deviceId = state.deviceId;
        newState.packageName = state.packageName;
        newState.databaseName = state.databaseName;
        newState.external = state.external;
        newState.classpathElements = AndroidDataSource.cloneElementsArray(state.classpathElements);
        newSource.resetUrl();
        AndroidDataSource androidDataSource = newSource;
        if (androidDataSource == null) {
            AndroidDataSource.$$$reportNull$$$0(9);
        }
        return androidDataSource;
    }

    @NotNull
    private static Element[] cloneElementsArray(@NotNull Element[] list) {
        if (list == null) {
            AndroidDataSource.$$$reportNull$$$0(10);
        }
        Element[] copy = new Element[list.length];
        for (int i = 0; i < list.length; ++i) {
            copy[i] = list[i].clone();
        }
        if (copy == null) {
            AndroidDataSource.$$$reportNull$$$0(11);
        }
        return copy;
    }

    public Icon getBaseIcon() {
        return AndroidIcons.Android;
    }

    public boolean equalConfiguration(@NotNull LocalDataSource o) {
        if (o == null) {
            AndroidDataSource.$$$reportNull$$$0(12);
        }
        if (!(o instanceof AndroidDataSource)) {
            return super.equalConfiguration(o);
        }
        if (!Comparing.equal((String)this.getComment(), (String)o.getComment())) {
            return false;
        }
        State s = ((AndroidDataSource)o).getState();
        if (!Comparing.equal((String)this.myState.deviceId, (String)s.deviceId)) {
            return false;
        }
        if (!Comparing.equal((String)this.myState.packageName, (String)s.packageName)) {
            return false;
        }
        if (!Comparing.equal((String)this.myState.databaseName, (String)s.databaseName)) {
            return false;
        }
        return Comparing.equal((Object)this.myState.external, (Object)s.external);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 10: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 10: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidDataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFullState";
                break;
            }
            case 2: 
            case 10: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidDataSource";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeClasspathElements";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "deserializeClasspathElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLocalDbFileOsPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneElementsArray";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cloneElementsArray";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="data-source")
    public static class State {
        public String deviceId = "";
        public String name = "";
        public String comment = "";
        public String packageName = "";
        public String databaseName = "";
        public boolean external = false;
        @Tag(value="classpath-elements")
        public Element[] classpathElements = new Element[0];
    }
}

