/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.ejbc;

import com.intellij.javaee.weblogic.ejbc.AbstractOutputParser;
import com.intellij.javaee.weblogic.ejbc.EjbcError;
import com.intellij.openapi.diagnostic.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;

class EjbcOutputParser
extends AbstractOutputParser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.javaee.weblogic.ejbc.EjbcOutputParser");
    @NonNls
    protected static final String MESSAGE_PATTERN = "(?: Error from ejbc:\\s+)?((In EJB '?(\\S+)'?,)?\\s*\\S[^\\n\\r]+)[\\r\\n]*(.*)";
    @NonNls
    protected static final String ERROR_PATTERN = "^\\s*ERROR:(.+[^\\r\\n])?[\\r\\n]+(ERROR.*)";
    @NonNls
    protected static final String FOOTER_PATTERN = "^\\s*ERROR: (ejbc found errors)|(ejbc couldn't invoke compiler)\\s*$";

    EjbcOutputParser() {
    }

    @Override
    public synchronized void parseAvailableOutput() {
        String text = this.myOutput.substring(this.myCurrentPosition);
        LOG.debug(text);
        Pattern messagePattern = Pattern.compile(MESSAGE_PATTERN, 32);
        Pattern generalErrorPattern = Pattern.compile(ERROR_PATTERN, 32);
        Pattern footerPattern = Pattern.compile(FOOTER_PATTERN, 32);
        while (text != null) {
            Matcher matcher = footerPattern.matcher(text);
            if (matcher.matches()) {
                this.myCurrentPosition += text.length();
                break;
            }
            matcher = generalErrorPattern.matcher(text);
            if (!matcher.matches()) break;
            String message = matcher.group(1);
            text = matcher.group(2);
            this.myCurrentPosition += matcher.start(2);
            this.addMessage(new EjbcError(message));
        }
    }
}

