/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime;

import com.intellij.javaee.weblogic.agent.version9.mbeansModel.AbstractWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.DomainWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.DomainRuntimeWL9MBean;
import com.intellij.javaee.weblogic.agent.version9.mbeansModel.runtime.ServerRuntimeWL9MBean;
import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class DomainRuntimeServiceWL9MBean
extends AbstractWL9MBean {
    private static final String SERVER_RUNTIMES_ATTRIBUTE_NAME = "ServerRuntimes";
    private static final String DOMAIN_RUNTIME_ATTRIBUTE_NAME = "DomainRuntime";
    private static final String DOMAIN_CONFIGURATION_ATTRIBUTE_NAME = "DomainConfiguration";

    public DomainRuntimeServiceWL9MBean(MBeanServerConnection connection, ObjectName beanName) {
        super(connection, beanName);
    }

    public ServerRuntimeWL9MBean findServerRuntimeByName(String serverName) throws IOException, JMException {
        ObjectName[] children;
        for (ObjectName objectName : children = this.getChildren(SERVER_RUNTIMES_ATTRIBUTE_NAME)) {
            ServerRuntimeWL9MBean serverRuntime = new ServerRuntimeWL9MBean(this.getConnection(), objectName);
            if (!serverName.equals(serverRuntime.getName())) continue;
            return serverRuntime;
        }
        return null;
    }

    public ServerRuntimeWL9MBean[] getServers() throws IOException, JMException {
        ObjectName[] children = this.getChildren(SERVER_RUNTIMES_ATTRIBUTE_NAME);
        ServerRuntimeWL9MBean[] servers = new ServerRuntimeWL9MBean[children.length];
        for (int i = 0; i < children.length; ++i) {
            servers[i] = new ServerRuntimeWL9MBean(this.getConnection(), children[i]);
        }
        return servers;
    }

    public DomainRuntimeWL9MBean getDomainRuntime() throws IOException, JMException {
        return new DomainRuntimeWL9MBean(this.getConnection(), this.getChild(DOMAIN_RUNTIME_ATTRIBUTE_NAME));
    }

    public DomainWL9MBean getDomainConfiguration() throws IOException, JMException {
        return new DomainWL9MBean(this.getConnection(), this.getChild(DOMAIN_CONFIGURATION_ATTRIBUTE_NAME));
    }
}

