/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.commons.util.parser.Part;
import com.intellij.spring.data.commons.util.parser.PartTree;
import com.intellij.spring.data.commons.util.parser.SpringDataParserUtil;
import com.intellij.spring.data.commons.util.parser.domain.PropertyPath;
import com.intellij.spring.data.commons.util.parser.domain.Sort;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringDataIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataCommonsCompletionContributor
extends CompletionContributor {
    public SpringDataCommonsCompletionContributor() {
        PsiJavaElementPattern.Capture psiIdentifierCapture = (PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiIdentifier.class).withParent(PsiField.class)).with((PatternCondition)new PatternCondition<PsiElement>("SpringDataRepository"){

            public boolean accepts(@NotNull PsiElement psiElement, ProcessingContext context) {
                PsiClass psiClass;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class)) != null && SpringDataUtil.isRepository(psiClass);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$1", "accepts"));
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)psiIdentifierCapture, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                Pair repositoryTypes;
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((repositoryTypes = SpringDataCommonsCompletionContributor.getRepositoryTypes(parameters)) != null) {
                    result.addAllElements((Iterable)SpringDataCommonsCompletionContributor.getCompletionVariants((Pair<PsiClass, ? extends PsiType>)repositoryTypes, SpringDataCommonsCompletionContributor.getPsiMemberName(parameters), result.getPrefixMatcher()));
                    result.stopHere();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$2";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    private static Set<LookupElement> getCompletionVariants(@NotNull Pair<PsiClass, ? extends PsiType> typesPair, @Nullable String methodName, @NotNull PrefixMatcher matcher) {
        if (typesPair == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(0);
        }
        if (matcher == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(1);
        }
        if (methodName == null) {
            Set<LookupElement> set = Collections.emptySet();
            if (set == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(2);
            }
            return set;
        }
        String prefix = matcher.getPrefix();
        PsiClass domainClass = (PsiClass)typesPair.getFirst();
        if (domainClass == null) {
            Set<LookupElement> set = Collections.emptySet();
            if (set == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(3);
            }
            return set;
        }
        PartTree partTree = new PartTree(methodName, domainClass);
        int offset = prefix.length();
        Position[] ranges = SpringDataCommonsCompletionContributor.getPartTreeTextRanges(partTree).toArray(new Position[1]);
        if (ranges.length == 1 && ranges[0] instanceof PartPosition) {
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getSubjectVariants(domainClass, "");
            if (set == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(4);
            }
            return set;
        }
        for (int i = 0; i < ranges.length; ++i) {
            Position nextPosition;
            Position currentPosition = ranges[i];
            Position position = nextPosition = i + 1 < ranges.length ? ranges[i + 1] : null;
            if (currentPosition.getRange().contains(offset)) {
                Set<LookupElement> set = SpringDataCommonsCompletionContributor.getPositionVariants(methodName, domainClass, currentPosition);
                if (set == null) {
                    SpringDataCommonsCompletionContributor.$$$reportNull$$$0(5);
                }
                return set;
            }
            if (currentPosition.getRange().getEndOffset() == offset) {
                Set<LookupElement> set = SpringDataCommonsCompletionContributor.getPositionEndOffsetVariants(methodName, domainClass, currentPosition, nextPosition, offset);
                if (set == null) {
                    SpringDataCommonsCompletionContributor.$$$reportNull$$$0(6);
                }
                return set;
            }
            if (SpringDataCommonsCompletionContributor.isOffsetBetweenKnownPositions(offset, currentPosition, nextPosition)) {
                if (!(nextPosition instanceof PartPosition)) continue;
                Set<LookupElement> set = SpringDataCommonsCompletionContributor.getBetweenPartCompletionVariantsElements(methodName, domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, currentPosition.getRange().getEndOffset()), SpringDataCommonsCompletionContributor.getSuffix(methodName, nextPosition.getRange()));
                if (set == null) {
                    SpringDataCommonsCompletionContributor.$$$reportNull$$$0(7);
                }
                return set;
            }
            if (nextPosition != null || !SpringDataCommonsCompletionContributor.isIncompleteOrderByKeyword(partTree)) continue;
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getEmptyOrderByVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, methodName.indexOf("OrderBy")), "");
            if (set == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(8);
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static boolean isIncompleteOrderByKeyword(PartTree partTree) {
        return partTree.getOrderBySource() != null && partTree.getOrderBySource().getOrders().size() == 0;
    }

    private static boolean isOffsetBetweenKnownPositions(int offset, @NotNull Position currentPosition, @Nullable Position nextPosition) {
        if (currentPosition == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(10);
        }
        return nextPosition != null && currentPosition.getRange().getEndOffset() < offset && nextPosition.getRange().getStartOffset() > offset;
    }

    @NotNull
    private static Set<LookupElement> getPositionEndOffsetVariants(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull Position currentPosition, @Nullable Position nextPosition, int offset) {
        if (methodName == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(11);
        }
        if (domainClass == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(12);
        }
        if (currentPosition == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(13);
        }
        TextRange textRange = currentPosition.getRange();
        if (currentPosition instanceof SubjectPosition) {
            if (nextPosition == null) {
                Set<LookupElement> set = SpringDataCommonsCompletionContributor.getPropertyWithKeywordVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), "");
                if (set == null) {
                    SpringDataCommonsCompletionContributor.$$$reportNull$$$0(14);
                }
                return set;
            }
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getPositionVariants(methodName, domainClass, nextPosition);
            if (set == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(15);
            }
            return set;
        }
        if (currentPosition instanceof PartPosition) {
            HashSet variants = ContainerUtil.newHashSet();
            Set<String> propertiesWithKeywords = SpringDataCommonsCompletionContributor.getLastPartPositionVariantsStrings(methodName, domainClass, (PartPosition)currentPosition, offset);
            variants.addAll(SpringDataCommonsCompletionContributor.getCompletionVariants(propertiesWithKeywords, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), SpringDataCommonsCompletionContributor.getSuffix(methodName, textRange)));
            variants.addAll(SpringDataCommonsCompletionContributor.getOperationVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), SpringDataCommonsCompletionContributor.getSuffix(methodName, textRange)));
            if (nextPosition == null) {
                variants.addAll(SpringDataCommonsCompletionContributor.getEmptyOrderByVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), SpringDataCommonsCompletionContributor.getSuffix(methodName, textRange)));
            }
            variants.addAll(SpringDataCommonsCompletionContributor.getPropertyChainVariants((PartPosition)currentPosition, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), SpringDataCommonsCompletionContributor.getSuffix(methodName, textRange)));
            HashSet hashSet = variants;
            if (hashSet == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(16);
            }
            return hashSet;
        }
        if (currentPosition instanceof SortPosition && nextPosition == null) {
            HashSet variants = ContainerUtil.newHashSet();
            Sort.Order order = ((SortPosition)currentPosition).getOrder();
            if (SpringDataCommonsCompletionContributor.isSortPropertyResolved(order)) {
                variants.addAll(SpringDataCommonsCompletionContributor.getSortVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getEndOffset()), ""));
            }
            variants.addAll(SpringDataCommonsCompletionContributor.getSortVariants(domainClass, SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getStartOffset()), ""));
            HashSet hashSet = variants;
            if (hashSet == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(17);
            }
            return hashSet;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(18);
        }
        return set;
    }

    @NotNull
    private static Set<String> getLastPartPositionVariantsStrings(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull PartPosition currentPosition, int offset) {
        if (methodName == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(19);
        }
        if (domainClass == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(20);
        }
        if (currentPosition == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(21);
        }
        Set<String> propertiesWithKeywords = SpringDataCommonsCompletionContributor.getAllPropertiesWithKeywords(SpringDataUtil.getProperties(domainClass));
        propertiesWithKeywords.remove(currentPosition.getPart().getSource());
        if (methodName.length() == offset) {
            if (methodName.endsWith("And")) {
                propertiesWithKeywords.remove("And");
            }
            if (methodName.endsWith("Or")) {
                propertiesWithKeywords.remove("Or");
            }
        }
        Set<String> set = propertiesWithKeywords;
        if (set == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(22);
        }
        return set;
    }

    private static boolean isSortPropertyResolved(Sort.Order order) {
        return order.getPropertyPath().getLeafProperty().getType() != null;
    }

    @NotNull
    private static Set<LookupElement> getBetweenPartCompletionVariantsElements(@Nullable String methodName, @NotNull PsiClass domainClass, String prefix, String suffix) {
        if (domainClass == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(23);
        }
        Set<LookupElement> set = SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.mergeTails(SpringDataCommonsCompletionContributor.getOperations(), SpringDataCommonsCompletionContributor.getAllPropertiesWithKeywords(SpringDataUtil.getProperties(domainClass))), prefix, suffix);
        if (set == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(24);
        }
        return set;
    }

    private static Set<LookupElement> getEmptyOrderByVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        return SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.mergeTails(Collections.singleton("OrderBy"), SpringDataCommonsCompletionContributor.getCapitalizedProperties(domainClass)), prefixExpression, suffixExpression);
    }

    @NotNull
    private static Set<LookupElement> getCompletionVariants(@NotNull Set<String> strings, @NotNull String prefixExpression, @Nullable String suffixExpression) {
        if (strings == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(25);
        }
        if (prefixExpression == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(26);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("SpringDataCommonsCompletionContributor.complete.repository.name");
        HashSet set = ContainerUtil.newHashSet();
        for (String s : strings) {
            if (StringUtil.isEmptyOrSpaces((String)s)) continue;
            set.add(SpringDataCommonsCompletionContributor.createLookupElement(prefixExpression, s, ""));
            if (StringUtil.isEmptyOrSpaces((String)suffixExpression)) continue;
            set.add(SpringDataCommonsCompletionContributor.createLookupElement(prefixExpression, s, suffixExpression));
        }
        HashSet hashSet = set;
        if (hashSet == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(27);
        }
        return hashSet;
    }

    private static Set<LookupElement> getSortVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        return SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.mergeTails(SpringDataCommonsCompletionContributor.getCapitalizedProperties(domainClass), "Asc", "Desc"), prefixExpression, suffixExpression);
    }

    @NotNull
    private static Set<LookupElement> getPositionVariants(@NotNull String methodName, @NotNull PsiClass domainClass, @NotNull Position position) {
        if (methodName == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(28);
        }
        if (domainClass == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(29);
        }
        if (position == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(30);
        }
        TextRange textRange = position.getRange();
        String prefixExpression = SpringDataCommonsCompletionContributor.getPrefix(methodName, textRange.getStartOffset());
        String suffixExpression = SpringDataCommonsCompletionContributor.getSuffix(methodName, textRange);
        if (position instanceof SubjectPosition) {
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getSubjectVariants(domainClass, suffixExpression);
            if (set == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(31);
            }
            return set;
        }
        if (position instanceof PartPosition) {
            HashSet variants = ContainerUtil.newHashSet();
            variants.addAll(SpringDataCommonsCompletionContributor.getPropertyChainVariants((PartPosition)position, prefixExpression, suffixExpression));
            variants.addAll(SpringDataCommonsCompletionContributor.getPropertyWithKeywordVariants(domainClass, prefixExpression, suffixExpression));
            HashSet hashSet = variants;
            if (hashSet == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(32);
            }
            return hashSet;
        }
        if (position instanceof SortPosition) {
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getSortVariants(domainClass, prefixExpression, suffixExpression);
            if (set == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(33);
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(34);
        }
        return set;
    }

    @NotNull
    private static Set<LookupElement> getPropertyChainVariants(@NotNull PartPosition position, @NotNull String prefixExpression, @NotNull String suffixExpression) {
        PsiClass psiClass;
        Part part;
        PropertyPath leafProperty;
        PsiType propertyType;
        if (position == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(35);
        }
        if (prefixExpression == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(36);
        }
        if (suffixExpression == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(37);
        }
        if ((propertyType = (leafProperty = (part = position.getPart()).getProperty().getLeafProperty()).getType()) instanceof PsiClassType && (psiClass = ((PsiClassType)propertyType).resolve()) != null) {
            HashSet propertyChains = ContainerUtil.newHashSet();
            Set<String> capitalizedProperties = SpringDataCommonsCompletionContributor.getCapitalizedProperties(psiClass);
            String segment = StringUtil.capitalize((String)leafProperty.getSegment());
            String propertyPrefix = StringUtil.substringBefore((String)position.getPart().getSource(), (String)segment);
            String propertySuffix = StringUtil.substringAfter((String)position.getPart().getSource(), (String)segment);
            if (propertyPrefix == null || propertySuffix == null) {
                Set<LookupElement> set = Collections.emptySet();
                if (set == null) {
                    SpringDataCommonsCompletionContributor.$$$reportNull$$$0(38);
                }
                return set;
            }
            if (propertySuffix.startsWith("_")) {
                propertySuffix = StringUtil.substringAfter((String)propertySuffix, (String)"_");
            }
            for (String s : capitalizedProperties) {
                propertyChains.add(segment + s);
                propertyChains.add(segment + "_" + s);
            }
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getCompletionVariants(propertyChains, prefixExpression + propertyPrefix, propertySuffix + suffixExpression);
            if (set == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(39);
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(40);
        }
        return set;
    }

    private static Set<LookupElement> getPropertyWithKeywordVariants(@NotNull PsiClass domainClass, String prefixExpression, String suffixExpression) {
        if (domainClass == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(41);
        }
        return SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.getAllPropertiesWithKeywords(SpringDataUtil.getProperties(domainClass)), prefixExpression, suffixExpression);
    }

    private static Set<LookupElement> getOperationVariants(PsiClass domainClass, String prefixExpression, String suffixExpression) {
        return SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.mergeTails(SpringDataCommonsCompletionContributor.getOperations(), SpringDataCommonsCompletionContributor.getCapitalizedProperties(domainClass)), prefixExpression, suffixExpression);
    }

    private static String getSuffix(@NotNull String methodName, TextRange textRange) {
        if (methodName == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(42);
        }
        return methodName.substring(textRange.getEndOffset());
    }

    @NotNull
    private static Set<LookupElement> getSubjectVariants(@Nullable PsiClass domainClass, @NotNull String suffixExpression) {
        if (suffixExpression == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(43);
        }
        if (domainClass != null) {
            Set<LookupElement> set = SpringDataCommonsCompletionContributor.getCompletionVariants(SpringDataCommonsCompletionContributor.getSubjectVariants(domainClass.getName()), "", suffixExpression);
            if (set == null) {
                SpringDataCommonsCompletionContributor.$$$reportNull$$$0(44);
            }
            return set;
        }
        Set<LookupElement> set = Collections.emptySet();
        if (set == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(45);
        }
        return set;
    }

    @Nullable
    private static Pair<PsiClass, ? extends PsiType> getRepositoryTypes(@NotNull CompletionParameters parameters) {
        PsiClass repositoryClass;
        if (parameters == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(46);
        }
        if ((repositoryClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), PsiClass.class)) == null) {
            return null;
        }
        Pair<PsiClass, ? extends PsiType> pair = SpringDataUtil.substituteRepositoryTypes(repositoryClass);
        return repositoryClass != null ? pair : null;
    }

    @Nullable
    private static String getPsiMemberName(@NotNull CompletionParameters parameters) {
        PsiMember psiMember;
        PsiMember originalElement;
        if (parameters == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(47);
        }
        if ((originalElement = (PsiMember)PsiUtilBase.getOriginalElement((PsiElement)(psiMember = (PsiMember)parameters.getPosition().getParent()), PsiMember.class)) != null) {
            return originalElement.getName();
        }
        return null;
    }

    @NotNull
    private static Set<String> getAllPropertiesWithKeywords(@NotNull Set<String> properties) {
        if (properties == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(48);
        }
        HashSet all = ContainerUtil.newHashSet();
        for (String property : properties) {
            SpringDataCommonsCompletionContributor.addTails((Collection<String>)all, StringUtil.capitalize((String)property), Part.Type.ALL_KEYWORDS);
        }
        HashSet hashSet = all;
        if (hashSet == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(49);
        }
        return hashSet;
    }

    private static LookupElementBuilder createLookupElement(@NotNull String prefixExpression, @NotNull String property, @NotNull String suffixExpression) {
        if (prefixExpression == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(50);
        }
        if (property == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(51);
        }
        if (suffixExpression == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(52);
        }
        String lookupText = prefixExpression + property + suffixExpression;
        return LookupElementBuilder.create((String)lookupText).withPresentableText(property).bold().withTailText(StringUtil.isEmptyOrSpaces((String)suffixExpression) ? "" : suffixExpression, true).withIcon(SpringDataIcons.SpringData).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
            }
        });
    }

    private static Set<String> getSubjectVariants(@Nullable String domainClassName) {
        HashSet<String> strings = new HashSet<String>();
        String[] selectQuery = new String[]{"find", "read", "get", "query", "stream"};
        String[] query = new String[]{"count", "delete", "remove", "exists"};
        for (String s2 : selectQuery) {
            SpringDataCommonsCompletionContributor.addSubjectSimpleTails(strings, s2, domainClassName);
            SpringDataCommonsCompletionContributor.addTails(strings, s2, "First", "Top", "DistinctFirst", "DistinctTop");
        }
        for (String s2 : query) {
            SpringDataCommonsCompletionContributor.addSubjectSimpleTails(strings, s2, domainClassName);
        }
        return strings.stream().map(s -> s + "By").collect(Collectors.toSet());
    }

    private static void addSubjectSimpleTails(Set<String> strings, String base, @Nullable String domainClassName) {
        SpringDataCommonsCompletionContributor.addTails(strings, base, "Distinct", "All");
        if (domainClassName != null) {
            SpringDataCommonsCompletionContributor.addTails(strings, base, domainClassName, StringUtil.pluralize((String)domainClassName));
        }
    }

    private static void addTails(@NotNull Collection<String> strings, @NotNull String base, String ... tails) {
        if (strings == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(53);
        }
        if (base == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(54);
        }
        strings.add(base);
        for (String tail : tails) {
            strings.add(base + tail);
        }
    }

    private static void addTails(@NotNull Collection<String> strings, @NotNull String base, Collection<String> tails) {
        if (strings == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(55);
        }
        if (base == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(56);
        }
        strings.add(base);
        for (String tail : tails) {
            strings.add(base + tail);
        }
    }

    private static Set<String> getCapitalizedProperties(@NotNull PsiClass domainClass) {
        if (domainClass == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(57);
        }
        return SpringDataUtil.getProperties(domainClass).stream().map(s -> StringUtil.capitalize((String)s)).collect(Collectors.toSet());
    }

    private static List<String> getOperations() {
        return Arrays.asList("And", "Or");
    }

    @NotNull
    public static List<Position> getPartTreeTextRanges(@NotNull PartTree partTree) {
        if (partTree == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(58);
        }
        LinkedList textRanges = ContainerUtil.newLinkedList();
        Pair<PartTree.Subject, TextRange> subject = SpringDataCommonsCompletionContributor.getSubject(partTree);
        if (subject != null) {
            textRanges.add(new SubjectPosition((TextRange)subject.getSecond()));
        }
        for (Map.Entry<Part, TextRange> entry : SpringDataParserUtil.getPartTextRanges(partTree).entrySet()) {
            textRanges.add(new PartPosition(entry.getValue(), entry.getKey()));
        }
        for (Map.Entry<Object, TextRange> entry : SpringDataParserUtil.getSortTextRanges(partTree).entrySet()) {
            textRanges.add(new SortPosition(entry.getValue(), (Sort.Order)entry.getKey()));
        }
        List<Position> list = textRanges.stream().sorted((o1, o2) -> Segment.BY_START_OFFSET_THEN_END_OFFSET.compare(o1.getRange(), o2.getRange())).collect(Collectors.toList());
        if (list == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(59);
        }
        return list;
    }

    @Nullable
    private static Pair<PartTree.Subject, TextRange> getSubject(PartTree partTree) {
        PartTree.Subject subject = partTree.getSubject();
        if (subject == null || StringUtil.isEmptyOrSpaces((String)subject.getExpression())) {
            return null;
        }
        return Pair.create((Object)subject, (Object)TextRange.create((int)0, (int)subject.getExpression().length()));
    }

    private static String getPrefix(String methodName, int offset) {
        return methodName.substring(0, offset);
    }

    @NotNull
    private static Set<String> mergeTails(Collection<String> base, Collection<String> tails) {
        Set<String> set = SpringDataCommonsCompletionContributor.mergeTails(base, ArrayUtil.toStringArray(tails));
        if (set == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(60);
        }
        return set;
    }

    @NotNull
    private static Set<String> mergeTails(Collection<String> base, String ... tails) {
        HashSet strings = ContainerUtil.newHashSet();
        for (String property : base) {
            SpringDataCommonsCompletionContributor.addTails((Collection<String>)strings, property, tails);
        }
        HashSet hashSet = strings;
        if (hashSet == null) {
            SpringDataCommonsCompletionContributor.$$$reportNull$$$0(61);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 49: 
            case 59: 
            case 60: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 49: 
            case 59: 
            case 60: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesPair";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 49: 
            case 59: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor";
                break;
            }
            case 10: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPosition";
                break;
            }
            case 11: 
            case 19: 
            case 28: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 12: 
            case 20: 
            case 23: 
            case 29: 
            case 41: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 25: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 26: 
            case 36: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixExpression";
                break;
            }
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 37: 
            case 43: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffixExpression";
                break;
            }
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariants";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionEndOffsetVariants";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastPartPositionVariantsStrings";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getBetweenPartCompletionVariantsElements";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionVariants";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyChainVariants";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubjectVariants";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPropertiesWithKeywords";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartTreeTextRanges";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeTails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionVariants";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 49: 
            case 59: 
            case 60: 
            case 61: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOffsetBetweenKnownPositions";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPositionEndOffsetVariants";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getLastPartPositionVariantsStrings";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getBetweenPartCompletionVariantsElements";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPositionVariants";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyChainVariants";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyWithKeywordVariants";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getSuffix";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSubjectVariants";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryTypes";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getPsiMemberName";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getAllPropertiesWithKeywords";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "addTails";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getCapitalizedProperties";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getPartTreeTextRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 24: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 44: 
            case 45: 
            case 49: 
            case 59: 
            case 60: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SortPosition
    extends Position {
        private Sort.Order myOrder;

        public Sort.Order getOrder() {
            return this.myOrder;
        }

        private SortPosition(@NotNull TextRange range, Sort.Order key) {
            if (range == null) {
                SortPosition.$$$reportNull$$$0(0);
            }
            super(range);
            this.myOrder = key;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$SortPosition", "<init>"));
        }
    }

    private static class PartPosition
    extends Position {
        private Part myPart;

        private PartPosition(@NotNull TextRange range, @NotNull Part part) {
            if (range == null) {
                PartPosition.$$$reportNull$$$0(0);
            }
            if (part == null) {
                PartPosition.$$$reportNull$$$0(1);
            }
            super(range);
            this.myPart = part;
        }

        public Part getPart() {
            return this.myPart;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "part";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$PartPosition";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SubjectPosition
    extends Position {
        private SubjectPosition(@NotNull TextRange range) {
            if (range == null) {
                SubjectPosition.$$$reportNull$$$0(0);
            }
            super(range);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$SubjectPosition", "<init>"));
        }
    }

    private static class Position {
        private TextRange myRange;

        private Position(@NotNull TextRange range) {
            if (range == null) {
                Position.$$$reportNull$$$0(0);
            }
            this.myRange = range;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/spring/data/commons/completion/SpringDataCommonsCompletionContributor$Position", "<init>"));
        }
    }
}

