/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.ql;

import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jpa.DefaultQlModel;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.source.tree.java.PsiLiteralExpressionImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.data.commons.ql.domain.SpringDataDomainModel;
import com.intellij.spring.data.commons.ql.language.SpringDataQLLanguage;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.el.SpringELLanguage;
import com.intellij.spring.el.SpringElTemplateParser;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.TextRangeUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringDataQLInjector
implements ConcatenationAwareInjector {
    public static final Set<String> QUERY_ANNOTATIONS = ContainerUtil.immutableSet((Object[])new String[]{"org.springframework.data.jpa.repository.Query"});

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, PsiElement ... operands) {
        List<PsiLanguageInjectionHost> validOperands;
        if (registrar == null) {
            SpringDataQLInjector.$$$reportNull$$$0(0);
        }
        if (operands == null) {
            SpringDataQLInjector.$$$reportNull$$$0(1);
        }
        if (operands.length == 0) {
            return;
        }
        PsiElement theFirstHost = operands[0];
        if (!SpringDataUtil.hasSpringDataSupport(theFirstHost.getProject())) {
            return;
        }
        if (this.isQueryAnnotationHost(theFirstHost) && !(validOperands = SpringDataQLInjector.getValidLanguageInjectionHosts(operands)).isEmpty()) {
            Language languageToInject = SpringDataQLInjector.getLanguageToInject(theFirstHost);
            HashMap<PsiLanguageInjectionHost, List> spElTextRangeMap = new HashMap<PsiLanguageInjectionHost, List>();
            MultiHostRegistrar qlHostRegistrar = registrar.startInjecting(languageToInject);
            for (PsiLanguageInjectionHost psiLanguageInjectionHost : validOperands) {
                String text = psiLanguageInjectionHost.getText();
                List spElTextRanges = SpringElTemplateParser.parse((String)text);
                if (spElTextRanges.size() != 0) {
                    spElTextRangeMap.put(psiLanguageInjectionHost, spElTextRanges);
                }
                TextRange valueTextRange = ElementManipulators.getValueTextRange((PsiElement)psiLanguageInjectionHost);
                for (TextRange qlRange : TextRangeUtil.excludeRanges((TextRange)valueTextRange, (List)spElTextRanges)) {
                    String suffix = SpringDataQLInjector.hasSpElTextRangeInPosition(qlRange.getEndOffset(), spElTextRanges) ? SpringDataQLInjector.getSuffixString(text, qlRange) : null;
                    qlHostRegistrar.addPlace(null, suffix, psiLanguageInjectionHost, qlRange);
                }
            }
            qlHostRegistrar.doneInjecting();
            for (Map.Entry entry : spElTextRangeMap.entrySet()) {
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)entry.getKey();
                for (TextRange range : (List)entry.getValue()) {
                    registrar.startInjecting((Language)SpringELLanguage.INSTANCE).addPlace(null, null, host, range).doneInjecting();
                }
            }
            theFirstHost.putUserData(QlFile.PERSISTENCE_MODEL_KEY, (Object)SpringDataQLInjector.getQlModel(theFirstHost));
        }
    }

    @NotNull
    private static List<PsiLanguageInjectionHost> getValidLanguageInjectionHosts(PsiElement ... operands) {
        List validOperands = ContainerUtil.newSmartList();
        for (PsiElement operand : operands) {
            if (!(operand instanceof PsiLiteralExpressionImpl) || !(((PsiLiteralExpression)operand).getValue() instanceof String)) continue;
            validOperands.add((PsiLanguageInjectionHost)operand);
        }
        List list = validOperands;
        if (list == null) {
            SpringDataQLInjector.$$$reportNull$$$0(2);
        }
        return list;
    }

    public boolean isQueryAnnotationHost(@NotNull PsiElement host) {
        String annotationParamName;
        PsiElement hostParent;
        if (host == null) {
            SpringDataQLInjector.$$$reportNull$$$0(3);
        }
        if (host instanceof PsiLiteralExpression && (hostParent = PsiTreeUtil.getParentOfType((PsiElement)host, PsiNameValuePair.class)) != null && ((annotationParamName = ((PsiNameValuePair)hostParent).getName()) == null || "value".equals(annotationParamName) || "countQuery".equals(annotationParamName))) {
            PsiElement parent = hostParent.getParent();
            return parent instanceof PsiAnnotationParameterList && !parent.getProject().isDefault() && SpringDataQLInjector.isQueryAnnotation((PsiAnnotation)parent.getParent());
        }
        return false;
    }

    private static boolean isQueryAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            SpringDataQLInjector.$$$reportNull$$$0(4);
        }
        return QUERY_ANNOTATIONS.contains(psiAnnotation.getQualifiedName());
    }

    private static Language getLanguageToInject(PsiElement host) {
        return SpringDataQLInjector.isNativeQuery(host) ? SqlLanguage.INSTANCE : SpringDataQLLanguage.INSTANCE;
    }

    private static boolean isNativeQuery(PsiElement host) {
        PsiElement parent;
        if (host instanceof PsiLiteralExpression && (parent = PsiTreeUtil.getParentOfType((PsiElement)host, PsiAnnotationParameterList.class)) != null && !parent.getProject().isDefault()) {
            for (PsiNameValuePair pair : ((PsiAnnotationParameterList)parent).getAttributes()) {
                if (!"nativeQuery".equals(pair.getName())) continue;
                Boolean value = (Boolean)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)pair.getValue(), Boolean.class);
                return value != null && value != false;
            }
        }
        return false;
    }

    @NotNull
    private static String getSuffixString(String text, TextRange qlRange) {
        String string = qlRange.substring(text).trim().endsWith("?") ? "0" : "SpEl";
        if (string == null) {
            SpringDataQLInjector.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static QlModel getQlModel(PsiElement host) {
        PsiElement originalElement = host.getOriginalElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        if (module != null && JpaUtil.getJpaFacet((Module)module) != null) {
            DefaultQlModel defaultQlModel = new DefaultQlModel(false, module);
            if (defaultQlModel == null) {
                SpringDataQLInjector.$$$reportNull$$$0(6);
            }
            return defaultQlModel;
        }
        SpringDataDomainModel springDataDomainModel = new SpringDataDomainModel(originalElement);
        if (springDataDomainModel == null) {
            SpringDataQLInjector.$$$reportNull$$$0(7);
        }
        return springDataDomainModel;
    }

    private static boolean hasSpElTextRangeInPosition(int offset, List<TextRange> ranges) {
        for (TextRange range : ranges) {
            if (!range.contains(offset)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operands";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/ql/SpringDataQLInjector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/ql/SpringDataQLInjector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidLanguageInjectionHosts";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuffixString";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQlModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotationHost";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

