/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.dataflow.SetUtil;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.DuplocatorSettingsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.CheckBoxListListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntObjectHashMap;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplocatorSettingsDialog
extends DialogWrapper {
    private final Map<String, DuplocatorSettingsEditor> myEditors;
    private final TIntObjectHashMap<DuplocatorSettingsEditor> myItemNumber2Editor;
    private JPanel myLangDependentSettingsPanel;
    private JPanel myContentPanel;
    private JPanel myLangListPanel;
    private CheckBoxList myLangList;
    private final List<Pair<Language, DuplicatesProfile>> myLanguagesAndProfiles;

    DuplocatorSettingsDialog(@NotNull Project project, @NotNull DuplicatesProfile[] profiles, @NotNull AnalysisScope scope) {
        Set<String> languagesFromScope;
        if (project == null) {
            DuplocatorSettingsDialog.$$$reportNull$$$0(0);
        }
        if (profiles == null) {
            DuplocatorSettingsDialog.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            DuplocatorSettingsDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.$$$setupUI$$$();
        this.myEditors = new HashMap<String, DuplocatorSettingsEditor>();
        this.myItemNumber2Editor = new TIntObjectHashMap();
        this.myLanguagesAndProfiles = new ArrayList<Pair<Language, DuplicatesProfile>>();
        assert (profiles.length > 0);
        this.setTitle(DupLocatorBundle.message("duplicate.dialog.title", new Object[0]));
        this.myLangList = new CheckBoxList();
        this.myLangList.setBorder((Border)JBUI.Borders.empty());
        DuplocatorSettings settings = DuplocatorSettings.getInstance();
        DefaultListModel langListModel = (DefaultListModel)this.myLangList.getModel();
        int indexToSelect = -1;
        int index = 0;
        this.myLangList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DuplocatorSettingsDialog.this.updateEditor();
            }
        });
        this.myLangList.setCheckBoxListListener(new CheckBoxListListener(){

            public void checkBoxSelectionChanged(int index, boolean value) {
                DuplocatorSettingsDialog.this.updateOkAction();
            }
        });
        ArrayList<Language> languages = new ArrayList<Language>(DuplocatorSettingsDialog.getLanguages());
        Collections.sort(languages, LanguageUtil.LANGUAGE_COMPARATOR);
        List<Pair<Language, DuplicatesPresentation>> pairs = DuplocatorSettingsDialog.getPresentationsForSupportedLanguages(languages);
        Set<Object> selectedLanguages = new HashSet<String>();
        for (Pair<Language, DuplicatesPresentation> pair : pairs) {
            String langName = ((Language)pair.getFirst()).getDisplayName();
            if (!settings.SELECTED_PROFILES.contains(langName)) continue;
            selectedLanguages.add(langName);
        }
        SearchScope searchScope = scope.toSearchScope();
        if (searchScope instanceof LocalSearchScope && SetUtil.intersect(selectedLanguages, languagesFromScope = DuplocatorSettingsDialog.getLanguagesFromScope((LocalSearchScope)searchScope)).size() == 0) {
            selectedLanguages = languagesFromScope;
        }
        for (Pair<Language, DuplicatesPresentation> pair : pairs) {
            Language language = (Language)pair.getFirst();
            DuplicatesPresentation presentation = (DuplicatesPresentation)pair.getSecond();
            String name = language.getDisplayName();
            DuplocatorSettingsEditor editor = presentation.createEditor(presentation.getProfile().getDuplocatorState(language));
            this.addEditor(name, editor);
            boolean selected = selectedLanguages.contains(name);
            this.myLanguagesAndProfiles.add((Pair<Language, DuplicatesProfile>)Pair.create((Object)language, (Object)presentation.getProfile()));
            JCheckBox checkBox = new JCheckBox(name, selected);
            this.myItemNumber2Editor.put(langListModel.getSize(), (Object)editor);
            langListModel.addElement(checkBox);
            if (selected && (indexToSelect == -1 || name.equals(settings.LAST_SELECTED_LANGUAGE))) {
                indexToSelect = index;
            }
            ++index;
        }
        this.myLangListPanel.add((Component)new JBScrollPane((Component)this.myLangList));
        if (indexToSelect == -1) {
            indexToSelect = 0;
        }
        this.myLangList.setSelectedIndex(indexToSelect);
        UIUtil.scrollListToVisibleIfNeeded((JList)this.myLangList);
        if (profiles.length == 1) {
            this.myLangListPanel.setVisible(false);
        }
        this.updateEditor();
        this.updateOkAction();
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myLangList;
    }

    @NotNull
    public static Set<Language> getLanguages() {
        HashSet<Language> languages = new HashSet<Language>();
        for (FileType fileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
            if (!(fileType instanceof LanguageFileType)) continue;
            Language language = ((LanguageFileType)fileType).getLanguage();
            languages.add(language);
        }
        HashSet<Language> hashSet = languages;
        if (hashSet == null) {
            DuplocatorSettingsDialog.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    private static List<Pair<Language, DuplicatesPresentation>> getPresentationsForSupportedLanguages(@NotNull Collection<Language> languages) {
        if (languages == null) {
            DuplocatorSettingsDialog.$$$reportNull$$$0(4);
        }
        ArrayList<Pair<Language, DuplicatesPresentation>> result = new ArrayList<Pair<Language, DuplicatesPresentation>>();
        for (Language language : languages) {
            DuplicatesPresentation presentation = DuplicatesPresentation.Service.findPresentationForLanguage(language);
            if (presentation == null) continue;
            result.add((Pair<Language, DuplicatesPresentation>)Pair.create((Object)language, (Object)presentation));
        }
        ArrayList<Pair<Language, DuplicatesPresentation>> arrayList = result;
        if (arrayList == null) {
            DuplocatorSettingsDialog.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static Set<String> getLanguagesFromScope(@NotNull LocalSearchScope searchScope) {
        if (searchScope == null) {
            DuplocatorSettingsDialog.$$$reportNull$$$0(6);
        }
        HashSet<String> result = new HashSet<String>();
        for (PsiElement element : searchScope.getScope()) {
            result.add(element.getLanguage().getDisplayName());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            DuplocatorSettingsDialog.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    private void updateOkAction() {
        this.setOKActionEnabled(this.getAllSelectedLanguages().size() > 0);
    }

    private void updateEditor() {
        DuplocatorSettingsEditor editor;
        String languageName;
        JCheckBox selectedCheckBox = (JCheckBox)this.myLangList.getSelectedValue();
        if (selectedCheckBox != null && (languageName = selectedCheckBox.getText()) != null && (editor = this.myEditors.get(languageName)) != null) {
            this.myLangDependentSettingsPanel.setVisible(true);
            CardLayout layout = (CardLayout)this.myLangDependentSettingsPanel.getLayout();
            layout.show(this.myLangDependentSettingsPanel, languageName);
            return;
        }
        this.myLangDependentSettingsPanel.setVisible(false);
    }

    private void addEditor(String name, DuplocatorSettingsEditor editor) {
        JPanel wrappingPanel = new JPanel();
        wrappingPanel.setLayout(new BoxLayout(wrappingPanel, 0));
        this.myEditors.put(name, editor);
        wrappingPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)name, (boolean)false));
        wrappingPanel.add(editor.getComponent());
        this.myLangDependentSettingsPanel.add((Component)wrappingPanel, name);
    }

    @NotNull
    public List<DuplicatesProfile> getAllSelectedProfiles() {
        ArrayList<DuplicatesProfile> result = new ArrayList<DuplicatesProfile>();
        for (int i = 0; i < this.myLanguagesAndProfiles.size(); ++i) {
            if (!this.myLangList.isItemSelected(i)) continue;
            result.add((DuplicatesProfile)this.myLanguagesAndProfiles.get((int)i).second);
        }
        ArrayList<DuplicatesProfile> arrayList = result;
        if (arrayList == null) {
            DuplocatorSettingsDialog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public List<Language> getAllSelectedLanguages() {
        ArrayList<Language> result = new ArrayList<Language>();
        for (int i = 0; i < this.myLanguagesAndProfiles.size(); ++i) {
            if (!this.myLangList.isItemSelected(i)) continue;
            result.add((Language)this.myLanguagesAndProfiles.get((int)i).first);
        }
        return result;
    }

    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    protected void doOKAction() {
        Language language2;
        DuplocatorSettings settings = DuplocatorSettings.getInstance();
        settings.SELECTED_PROFILES.clear();
        for (Language language2 : this.getAllSelectedLanguages()) {
            settings.SELECTED_PROFILES.add(language2.getDisplayName());
        }
        int index = this.myLangList.getSelectedIndex();
        if (index >= 0 && index < this.myLanguagesAndProfiles.size() && (language2 = (Language)this.myLanguagesAndProfiles.get((int)index).first) != null) {
            settings.LAST_SELECTED_LANGUAGE = language2.getDisplayName();
        }
        for (DuplocatorSettingsEditor editor : this.myEditors.values()) {
            editor.apply();
        }
        super.doOKAction();
    }

    protected String getHelpId() {
        return "reference.dialogs.locateDuplicates.settings";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/DuplocatorSettingsDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/DuplocatorSettingsDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationsForSupportedLanguages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguagesFromScope";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSelectedProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationsForSupportedLanguages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesFromScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myContentPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(1, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLangListPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 2, 1, 0, 3, 7, 3, null, null, null));
        this.myLangDependentSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

