/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.DuplicatesIndex;
import com.intellij.dupLocator.index.DuplicatesInspectionBase;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.lang.LighterAST;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesInspection
extends DuplicatesInspectionBase {
    @Override
    protected LocalQuickFix createNavigateToDupeFix(final @NotNull VirtualFile file, final int offsetInOtherFile) {
        if (file == null) {
            DuplicatesInspection.$$$reportNull$$$0(0);
        }
        return new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                if ("Navigate to duplicate" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "Navigate to duplicate";
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                new OpenFileDescriptor(project, file, offsetInOtherFile).navigate(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/dupLocator/index/DuplicatesInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    protected LocalQuickFix createShowOtherDupesFix(final VirtualFile file, final int offset, final int hashOfDuplicate, final int hashOfDuplicate2) {
        return new LocalQuickFix(){
            private String myTitle;

            @NotNull
            public String getFamilyName() {
                if ("View duplicates like this" == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "View duplicates like this";
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(2);
                }
                UsageViewPresentation presentation = new UsageViewPresentation();
                String title = this.buildTitle();
                presentation.setUsagesString(title);
                presentation.setTabName(title);
                presentation.setTabText(title);
                GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                presentation.setScopeText(scope.getDisplayName());
                UsageViewManager.getInstance((Project)project).searchAndShowUsages(new UsageTarget[]{new DupeUsageTarget(file, offset, title, project)}, () -> {
                    if (project == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    return new DupeUsageSearcher(scope, hashOfDuplicate, hashOfDuplicate2, project);
                }, false, false, presentation, null);
            }

            @NotNull
            private String buildTitle() {
                if (this.myTitle == null) {
                    this.myTitle = "Duplicate code like in " + file.getName() + ":" + offset;
                }
                String string = this.myTitle;
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/dupLocator/index/DuplicatesInspection$2";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesInspection$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "buildTitle";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$applyFix$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    protected LocalQuickFix createExtractMethodFix(@NotNull PsiElement targetElement, @Nullable TextRange rangeInElement, int hash, int hash2) {
        DuplicatesPresentation presentation;
        if (targetElement == null) {
            DuplicatesInspection.$$$reportNull$$$0(1);
        }
        return (presentation = DuplicatesPresentation.Service.findPresentationForLanguage(targetElement.getLanguage())) != null ? presentation.createExtractMethodFix(targetElement, rangeInElement, hash, hash2) : null;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(DupLocatorBundle.message("skip.duplicates.in.generated.code", new Object[0]), (InspectionProfileEntry)this, "myFilterOutGeneratedCode");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createNavigateToDupeFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createExtractMethodFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DupeUsageSearcher
    implements UsageSearcher {
        private final GlobalSearchScope myScope;
        private final int myHashOfDuplicate;
        private final int myHashOfDuplicate2;
        private final Project myProject;

        public DupeUsageSearcher(GlobalSearchScope scope, int hashOfDuplicate, int hashOfDuplicate2, Project project) {
            this.myScope = scope;
            this.myHashOfDuplicate = hashOfDuplicate;
            this.myHashOfDuplicate2 = hashOfDuplicate2;
            this.myProject = project;
        }

        public void generate(@NotNull Processor<Usage> processor) {
            if (processor == null) {
                DupeUsageSearcher.$$$reportNull$$$0(0);
            }
            Collection files = (Collection)ReadAction.compute(() -> FileBasedIndex.getInstance().getContainingFiles(DuplicatesIndex.NAME, (Object)this.myHashOfDuplicate, this.myScope));
            for (VirtualFile file : files) {
                ApplicationManager.getApplication().runReadAction(() -> {
                    if (processor == null) {
                        DupeUsageSearcher.$$$reportNull$$$0(1);
                    }
                    if (!file.isValid()) {
                        return;
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
                    if (psiFile == null) {
                        return;
                    }
                    DuplicatesProfile profile = DuplicatesIndex.findDuplicatesProfile(psiFile.getFileType());
                    if (profile == null) {
                        return;
                    }
                    if (profile instanceof LightDuplicateProfile) {
                        LighterAST lighterAST = psiFile.getNode().getLighterAST();
                        ((LightDuplicateProfile)((Object)profile)).process(lighterAST, (hash, hash2, ast, nodes) -> {
                            if (processor == null) {
                                DupeUsageSearcher.$$$reportNull$$$0(3);
                            }
                            if (hash != this.myHashOfDuplicate) {
                                return;
                            }
                            if (hash2 != this.myHashOfDuplicate2) {
                                return;
                            }
                            processor.process((Object)new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)psiFile, nodes[0].getStartOffset(), nodes[nodes.length - 1].getEndOffset())));
                        });
                    } else {
                        DuplocatorState state = profile.getDuplocatorState(psiFile.getLanguage());
                        DuplocateVisitor visitor = profile.createVisitor((hash, cost, frag) -> {
                            if (processor == null) {
                                DupeUsageSearcher.$$$reportNull$$$0(2);
                            }
                            if (hash != this.myHashOfDuplicate || !DuplicatesIndex.isIndexedFragment(frag, cost, profile, state)) {
                                return;
                            }
                            processor.process((Object)new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)psiFile, frag.getStartOffset(), frag.getEndOffset())));
                        }, true);
                        visitor.visitNode((PsiElement)psiFile);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "processor";
            objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesInspection$DupeUsageSearcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "generate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$generate$3";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$2";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DupeUsageTarget
    implements UsageTarget {
        private final VirtualFile myFile;
        private final int myOffset;
        private String myTitle;
        private final Project myProject;

        public DupeUsageTarget(VirtualFile file, int offset, String title, Project project) {
            this.myFile = file;
            this.myOffset = offset;
            this.myTitle = title;
            this.myProject = project;
        }

        public void findUsages() {
        }

        public void findUsagesInEditor(@NotNull FileEditor editor) {
            if (editor == null) {
                DupeUsageTarget.$$$reportNull$$$0(0);
            }
        }

        public void highlightUsages(@NotNull PsiFile file, @NotNull Editor editor, boolean clearHighlights) {
            if (file == null) {
                DupeUsageTarget.$$$reportNull$$$0(1);
            }
            if (editor == null) {
                DupeUsageTarget.$$$reportNull$$$0(2);
            }
        }

        public boolean isValid() {
            return true;
        }

        public boolean isReadOnly() {
            return true;
        }

        @Nullable
        public VirtualFile[] getFiles() {
            return null;
        }

        public void update() {
        }

        @NotNull
        public String getName() {
            String string = this.myTitle;
            if (string == null) {
                DupeUsageTarget.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public ItemPresentation getPresentation() {
            PresentationData presentationData = new PresentationData(this.getName(), "", null, null);
            if (presentationData == null) {
                DupeUsageTarget.$$$reportNull$$$0(4);
            }
            return presentationData;
        }

        public void navigate(boolean requestFocus) {
            new OpenFileDescriptor(this.myProject, this.myFile, this.myOffset).navigate(requestFocus);
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dupLocator/index/DuplicatesInspection$DupeUsageTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dupLocator/index/DuplicatesInspection$DupeUsageTarget";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "findUsagesInEditor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "highlightUsages";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

