/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.downloader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archetype.downloader.DownloadException;
import org.apache.maven.archetype.downloader.DownloadNotFoundException;
import org.apache.maven.archetype.downloader.Downloader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;

public class DefaultDownloader
implements Downloader {
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;

    public File download(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List remoteRepositories) throws DownloadException, DownloadNotFoundException {
        Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, version, "runtime", "jar");
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>(remoteRepositories);
        if (repositories.isEmpty() && archetypeRepository != null) {
            repositories.add(archetypeRepository);
        } else if (repositories.isEmpty() && localRepository != null) {
            repositories.add(localRepository);
        }
        ArtifactRepository localRepo = localRepository;
        try {
            this.artifactResolver.resolve(artifact, repositories, localRepo);
        }
        catch (ArtifactResolutionException e) {
            throw new DownloadException("Error downloading.", e);
        }
        catch (ArtifactNotFoundException e) {
            throw new DownloadNotFoundException("Requested download does not exist.", e);
        }
        return artifact.getFile();
    }

    public File downloadOld(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List remoteRepositories) throws DownloadException, DownloadNotFoundException {
        Artifact artifact = this.artifactFactory.createArtifact(groupId, artifactId, version, "runtime", "jar");
        try {
            this.artifactResolver.resolve(artifact, remoteRepositories, localRepository);
        }
        catch (ArtifactResolutionException e) {
            throw new DownloadException("Error downloading.", e);
        }
        catch (ArtifactNotFoundException e) {
            throw new DownloadNotFoundException("Requested download does not exist.", e);
        }
        return artifact.getFile();
    }
}

