/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.google.protobuf3jarjar.InvalidProtocolBufferException;
import com.intellij.openapi.diagnostic.Logger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilerTable
extends DataStoreTable<ProfilerStatements> {
    private final Object myLock;

    private static Logger getLogger() {
        return Logger.getInstance(ProfilerTable.class);
    }

    public ProfilerTable(@NotNull Map<Common.Session, Long> sesstionIdLookup) {
        if (sesstionIdLookup == null) {
            ProfilerTable.$$$reportNull$$$0(0);
        }
        super(sesstionIdLookup);
        this.myLock = new Object();
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        if (connection == null) {
            ProfilerTable.$$$reportNull$$$0(1);
        }
        super.initialize(connection);
        try {
            this.createTable("Profiler_Bytes", "Id STRING NOT NULL", "Session INTEGER NOT NULL", "Data BLOB");
            this.createTable("Profiler_Devices", "Session STRING", "Data BLOB");
            this.createTable("Profiler_Processes", "Session INTEGER", "ProcessId INTEGER", "StartTime INTEGER", "EndTime INTEGER", "HasAgent INTEGER", "LastKnownAttachedTime INTEGER", "Data BLOB");
            this.createUniqueIndex("Profiler_Processes", "Session", "ProcessId", "StartTime");
            this.createUniqueIndex("Profiler_Bytes", "Id", "Session");
            this.createUniqueIndex("Profiler_Devices", "Session");
        }
        catch (SQLException ex) {
            ProfilerTable.getLogger().error((Throwable)ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            this.createStatement(ProfilerStatements.INSERT_DEVICE, "INSERT INTO Profiler_Devices (Session, Data) values (?, ?)", 1);
            this.createStatement(ProfilerStatements.UPDATE_DEVICE, "UPDATE Profiler_Devices SET Data = ? WHERE Session = ?");
            this.createStatement(ProfilerStatements.INSERT_PROCESS, "INSERT OR REPLACE INTO Profiler_Processes (Session, ProcessId, StartTime, EndTime, Data) values (?, ?, ?, ?, ?)");
            this.createStatement(ProfilerStatements.UPDATE_PROCESS, "UPDATE Profiler_Processes Set EndTime = ?, Data = ? WHERE Session = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.SELECT_PROCESSES, "SELECT Data from Profiler_Processes WHERE Session = ? AND (EndTime > ? OR EndTime = 0) AND StartTime < ?");
            this.createStatement(ProfilerStatements.SELECT_PROCESS_BY_ID, "SELECT Data from Profiler_Processes WHERE Session = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.SELECT_DEVICE, "SELECT Data from Profiler_Devices");
            this.createStatement(ProfilerStatements.FIND_AGENT_STATUS, "SELECT HasAgent, LastKnownAttachedTime from Profiler_Processes WHERE Session = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.UPDATE_AGENT_STATUS, "UPDATE Profiler_Processes SET HasAgent = ?, LastKnownAttachedTime = ? WHERE Session = ? AND ProcessId = ? AND StartTime = ?");
            this.createStatement(ProfilerStatements.INSERT_BYTES, "INSERT OR REPLACE INTO Profiler_Bytes (Id, Session, Data) VALUES (?, ?, ?)");
            this.createStatement(ProfilerStatements.GET_BYTES, "SELECT Data FROM Profiler_Bytes WHERE ID = ? AND Session = ?");
        }
        catch (SQLException ex) {
            ProfilerTable.getLogger().error((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler.GetDevicesResponse getDevices(Profiler.GetDevicesRequest request) {
        if (this.isClosed()) {
            return Profiler.GetDevicesResponse.getDefaultInstance();
        }
        Object object = this.myLock;
        synchronized (object) {
            Profiler.GetDevicesResponse.Builder responseBuilder = Profiler.GetDevicesResponse.newBuilder();
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.SELECT_DEVICE, new Object[0]);
                while (results.next()) {
                    responseBuilder.addDevice(Profiler.Device.parseFrom((byte[])results.getBytes(1)));
                }
            }
            catch (InvalidProtocolBufferException | SQLException ex) {
                ProfilerTable.getLogger().error(ex);
            }
            return responseBuilder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profiler.GetProcessesResponse getProcesses(Profiler.GetProcessesRequest request) {
        if (this.isClosed()) {
            return Profiler.GetProcessesResponse.getDefaultInstance();
        }
        Object object = this.myLock;
        synchronized (object) {
            Profiler.GetProcessesResponse.Builder responseBuilder = Profiler.GetProcessesResponse.newBuilder();
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.SELECT_PROCESSES, request.getSession(), Long.MIN_VALUE, Long.MAX_VALUE);
                while (results.next()) {
                    byte[] data = results.getBytes(1);
                    Profiler.Process process = data == null ? Profiler.Process.getDefaultInstance() : Profiler.Process.parseFrom((byte[])data);
                    responseBuilder.addProcess(process);
                }
            }
            catch (InvalidProtocolBufferException | SQLException ex) {
                ProfilerTable.getLogger().error(ex);
            }
            return responseBuilder.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrUpdateDevice(Profiler.Device device) {
        Object object = this.myLock;
        synchronized (object) {
            Common.Session session = Common.Session.newBuilder().setBootId(device.getBootId()).setDeviceSerial(device.getSerial()).build();
            if (this.mySessionIdLookup.containsKey(session)) {
                this.execute(ProfilerStatements.UPDATE_DEVICE, device.toByteArray(), session.toString());
            } else {
                long id = this.executeWithGeneratedKeys(ProfilerStatements.INSERT_DEVICE, session.toString(), device.toByteArray());
                this.mySessionIdLookup.put(session, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertOrUpdateProcess(Common.Session session, Profiler.Process process) {
        Object object = this.myLock;
        synchronized (object) {
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.SELECT_PROCESS_BY_ID, session, process.getPid(), 0L);
                if (results.next()) {
                    this.execute(ProfilerStatements.UPDATE_PROCESS, 0L, process.toByteArray(), session, process.getPid(), 0L);
                } else {
                    this.execute(ProfilerStatements.INSERT_PROCESS, session, process.getPid(), 0L, 0L, process.toByteArray());
                }
            }
            catch (SQLException ex) {
                ProfilerTable.getLogger().error((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAgentStatus(Common.Session session, Profiler.Process process, Profiler.AgentStatusResponse agentStatus) {
        Object object = this.myLock;
        synchronized (object) {
            try {
                ResultSet results = this.executeQuery(ProfilerStatements.FIND_AGENT_STATUS, session, process.getPid(), 0L);
                if (results.next()) {
                    Profiler.AgentStatusResponse.Status status = Profiler.AgentStatusResponse.Status.forNumber((int)results.getInt(1));
                    switch (status) {
                        case DETACHED: 
                        case UNSPECIFIED: 
                        case UNRECOGNIZED: {
                            status = agentStatus.getStatus();
                            break;
                        }
                    }
                    this.execute(ProfilerStatements.UPDATE_AGENT_STATUS, status.ordinal(), agentStatus.getLastTimestamp(), session, process.getPid(), 0L);
                }
            }
            catch (SQLException ex) {
                ProfilerTable.getLogger().error((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Profiler.AgentStatusResponse getAgentStatus(Profiler.AgentStatusRequest request) {
        Object object = this.myLock;
        // MONITORENTER : object
        Profiler.AgentStatusResponse.Builder responseBuilder = Profiler.AgentStatusResponse.newBuilder();
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.FIND_AGENT_STATUS, request.getSession(), request.getProcessId(), 0L);
            if (results.next()) {
                responseBuilder.setStatusValue(results.getInt(1));
                responseBuilder.setLastTimestamp(results.getLong(2));
            }
        }
        catch (SQLException ex) {
            ProfilerTable.getLogger().error((Throwable)ex);
        }
        Profiler.AgentStatusResponse agentStatusResponse = responseBuilder.build();
        // MONITOREXIT : object
        if (agentStatusResponse != null) return agentStatusResponse;
        ProfilerTable.$$$reportNull$$$0(2);
        return agentStatusResponse;
    }

    public void insertOrUpdateBytes(String id, Common.Session session, Profiler.BytesResponse response) {
        this.execute(ProfilerStatements.INSERT_BYTES, id, session, response.toByteArray());
    }

    @Nullable
    public Profiler.BytesResponse getBytes(Profiler.BytesRequest request) {
        try {
            ResultSet results = this.executeQuery(ProfilerStatements.GET_BYTES, request.getId(), request.getSession());
            if (results.next()) {
                return Profiler.BytesResponse.parseFrom((byte[])results.getBytes(1));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            ProfilerTable.getLogger().error(ex);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sesstionIdLookup";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/database/ProfilerTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/database/ProfilerTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ProfilerStatements {
        INSERT_DEVICE,
        UPDATE_DEVICE,
        INSERT_PROCESS,
        UPDATE_PROCESS,
        SELECT_PROCESSES,
        SELECT_PROCESS_BY_ID,
        SELECT_DEVICE,
        FIND_AGENT_STATUS,
        UPDATE_AGENT_STATUS,
        INSERT_BYTES,
        GET_BYTES;

    }
}

