/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.CpuProfiler;
import com.android.tools.profiler.proto.CpuServiceGrpc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class CpuThreadCountDataSeries
implements DataSeries<Long> {
    @NotNull
    private CpuServiceGrpc.CpuServiceBlockingStub myClient;
    private final int myProcessId;
    private final Common.Session mySession;

    public CpuThreadCountDataSeries(@NotNull CpuServiceGrpc.CpuServiceBlockingStub client, int id, Common.Session session) {
        if (client == null) {
            CpuThreadCountDataSeries.$$$reportNull$$$0(0);
        }
        this.myClient = client;
        this.myProcessId = id;
        this.mySession = session;
    }

    public List<SeriesData<Long>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            CpuThreadCountDataSeries.$$$reportNull$$$0(1);
        }
        long bufferNs = TimeUnit.SECONDS.toNanos(1L);
        CpuProfiler.GetThreadsRequest.Builder request = CpuProfiler.GetThreadsRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin()) - bufferNs).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()) + bufferNs);
        CpuProfiler.GetThreadsResponse response = this.myClient.getThreads(request.build());
        TreeMap<Long, Long> count = new TreeMap<Long, Long>();
        for (CpuProfiler.GetThreadsResponse.Thread thread : response.getThreadsList()) {
            if (thread.getActivitiesCount() <= 0) continue;
            CpuProfiler.GetThreadsResponse.ThreadActivity first = thread.getActivities(0);
            CpuProfiler.GetThreadsResponse.ThreadActivity last = thread.getActivities(thread.getActivitiesCount() - 1);
            Long current = (Long)count.get(first.getTimestamp());
            count.put(first.getTimestamp(), current == null ? 1L : current + 1L);
            if (last.getNewState() != CpuProfiler.GetThreadsResponse.State.DEAD) continue;
            current = (Long)count.get(last.getTimestamp());
            count.put(last.getTimestamp(), current == null ? -1L : current - 1L);
        }
        ArrayList<SeriesData<Long>> data = new ArrayList<SeriesData<Long>>();
        long total = 0L;
        for (Map.Entry entry : count.entrySet()) {
            data.add((SeriesData<Long>)new SeriesData(TimeUnit.NANOSECONDS.toMicros((Long)entry.getKey()), (Object)(total += ((Long)entry.getValue()).longValue())));
        }
        if (count.isEmpty()) {
            data.add(new SeriesData((long)timeCurrentRangeUs.getMin(), (Object)total));
            data.add((SeriesData<Long>)new SeriesData((long)timeCurrentRangeUs.getMax(), (Object)total));
        } else if ((double)((SeriesData)data.get((int)(data.size() - 1))).x < timeCurrentRangeUs.getMax()) {
            data.add((SeriesData<Long>)new SeriesData((long)timeCurrentRangeUs.getMax(), (Object)total));
        }
        return data;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/cpu/CpuThreadCountDataSeries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataForXRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

