/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.chart.hchart.HRenderer;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.MethodModel;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.regex.Pattern;

public class SampledMethodUsageHRenderer
extends HRenderer<MethodModel> {
    private static final int LEFT_MARGIN_PX = 3;
    private static final Pattern dotPattern = Pattern.compile("\\.");

    protected boolean isMethodPlatform(MethodModel method) {
        return method.getClassName().startsWith("android.");
    }

    protected boolean isMethodVendor(MethodModel method) {
        return method.getClassName().startsWith("java.") || method.getClassName().startsWith("sun.") || method.getClassName().startsWith("javax.") || method.getClassName().startsWith("apple.") || method.getClassName().startsWith("com.apple.");
    }

    protected Color getFillColor(MethodModel m) {
        if (this.isMethodVendor(m)) {
            return ProfilerColors.CPU_TREECHART_VENDOR;
        }
        if (this.isMethodPlatform(m)) {
            return ProfilerColors.CPU_TREECHART_PLATFORM;
        }
        return ProfilerColors.CPU_TREECHART_APP;
    }

    protected Color getBordColor(MethodModel m) {
        if (this.isMethodVendor(m)) {
            return ProfilerColors.CPU_TREECHART_VENDOR_BORDER;
        }
        if (this.isMethodPlatform(m)) {
            return ProfilerColors.CPU_TREECHART_PLATFORM_BORDER;
        }
        return ProfilerColors.CPU_TREECHART_APP_BORDER;
    }

    protected String generateFittingText(MethodModel node, Rectangle2D rect, FontMetrics fontMetrics) {
        double maxWidth = rect.getWidth() - 3.0;
        String separator = StringUtil.isEmpty((String)node.getClassName()) ? "" : ".";
        String fullyQualified = node.getClassName() + separator + node.getName();
        if ((double)fontMetrics.stringWidth(fullyQualified) < maxWidth) {
            return fullyQualified;
        }
        String shortPackage = this.getShortPackageName(node.getClassName());
        separator = StringUtil.isEmpty((String)shortPackage) ? "" : ".";
        String abbrevPackage = shortPackage + separator + node.getName();
        if ((double)fontMetrics.stringWidth(abbrevPackage) < maxWidth) {
            return abbrevPackage;
        }
        String name = node.getName();
        if ((double)fontMetrics.stringWidth(name) < maxWidth) {
            return name;
        }
        if (!name.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            if ((double)fontMetrics.stringWidth(stringBuilder.append(name.charAt(0)).append("...").toString()) < maxWidth) {
                return name.charAt(0) + "...";
            }
        }
        return "";
    }

    protected void renderText(Graphics2D g, String text, Rectangle2D.Float rect, FontMetrics fontMetrics) {
        float textPositionX = 3.0f + rect.x;
        float textPositionY = (float)(rect.getY() + (double)fontMetrics.getAscent());
        g.drawString(text, textPositionX, textPositionY);
    }

    protected String getShortPackageName(String nameSpace) {
        if (nameSpace == null || nameSpace.equals("")) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        String[] elements = dotPattern.split(nameSpace);
        String separator = "";
        for (int i = 0; i < elements.length; ++i) {
            b.append(separator);
            b.append(elements[i].charAt(0));
            separator = ".";
        }
        return b.toString();
    }
}

