/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.KeyboardAction;
import com.android.tools.adtui.model.event.KeyboardData;
import com.android.tools.adtui.model.event.SimpleEventType;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.EventProfiler;
import com.android.tools.profiler.proto.EventServiceGrpc;
import com.android.tools.profilers.ProfilerClient;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SimpleEventDataSeries
implements DataSeries<EventAction<SimpleEventType>> {
    @NotNull
    private ProfilerClient myClient;
    private final int myProcessId;
    private final Common.Session mySession;

    public SimpleEventDataSeries(@NotNull ProfilerClient client, int id, Common.Session session) {
        if (client == null) {
            SimpleEventDataSeries.$$$reportNull$$$0(0);
        }
        this.myClient = client;
        this.myProcessId = id;
        this.mySession = session;
    }

    public List<SeriesData<EventAction<SimpleEventType>>> getDataForXRange(@NotNull Range timeCurrentRangeUs) {
        if (timeCurrentRangeUs == null) {
            SimpleEventDataSeries.$$$reportNull$$$0(1);
        }
        ArrayList<SeriesData<EventAction<SimpleEventType>>> seriesData = new ArrayList<SeriesData<EventAction<SimpleEventType>>>();
        EventServiceGrpc.EventServiceBlockingStub eventService = this.myClient.getEventClient();
        EventProfiler.EventDataRequest.Builder dataRequestBuilder = EventProfiler.EventDataRequest.newBuilder().setProcessId(this.myProcessId).setSession(this.mySession).setStartTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMin())).setEndTimestamp(TimeUnit.MICROSECONDS.toNanos((long)timeCurrentRangeUs.getMax()));
        EventProfiler.SystemDataResponse response = eventService.getSystemData(dataRequestBuilder.build());
        for (EventProfiler.SystemData data : response.getDataList()) {
            long actionStart = TimeUnit.NANOSECONDS.toMicros(data.getStartTimestamp());
            long actionEnd = TimeUnit.NANOSECONDS.toMicros(data.getEndTimestamp());
            switch (data.getType()) {
                case ROTATION: {
                    seriesData.add((SeriesData<EventAction<SimpleEventType>>)new SeriesData(actionStart, (Object)new EventAction(actionStart, actionEnd, (Object)SimpleEventType.ROTATION)));
                    break;
                }
                case UNSPECIFIED: {
                    break;
                }
                case TOUCH: {
                    seriesData.add((SeriesData<EventAction<SimpleEventType>>)new SeriesData(actionStart, (Object)new EventAction(actionStart, actionEnd, (Object)SimpleEventType.TOUCH)));
                    break;
                }
                case KEY: {
                    seriesData.add((SeriesData<EventAction<SimpleEventType>>)new SeriesData(actionStart, (Object)new KeyboardAction(actionStart, actionEnd, new KeyboardData(data.getEventData()))));
                    break;
                }
            }
        }
        return seriesData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeCurrentRangeUs";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/profilers/event/SimpleEventDataSeries";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataForXRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

