/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProviderBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.security.model.SpringSecurityVersion;
import com.intellij.spring.security.model.xml.FormLogin;
import com.intellij.spring.security.model.xml.Http;
import com.intellij.spring.security.model.xml.Logout;
import com.intellij.spring.security.util.SpringSecurityUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSecurityWebPathProvider
extends PathReferenceProviderBase {
    private static final String LOGIN_DEFAULT_3_X = "/j_spring_security_check";
    private static final String LOGOUT_DEFAULT_3_X = "/j_spring_security_logout";
    private static final String LOGIN_DEFAULT_4_X = "/login";
    private static final String LOGOUT_DEFAULT_4_X = "/logout";

    public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<PsiReference> references, boolean soft) {
        if (psiElement == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(0);
        }
        if (references == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(1);
        }
        if (JamCommonUtil.isPlainXmlFile((PsiElement)psiElement.getContainingFile())) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.core.Authentication") == null) {
            return true;
        }
        final List<String> springSecurityURLs = SpringSecurityWebPathProvider.getSpringSecurityURLs(module);
        boolean isSpringSecurityUrl = springSecurityURLs.contains(text);
        references.add((PsiReference)new PsiReferenceBase.Immediate<PsiElement>(psiElement, (PsiElement)(isSpringSecurityUrl ? psiElement : null)){

            @NotNull
            public Object[] getVariants() {
                ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>(springSecurityURLs.size());
                for (String url : springSecurityURLs) {
                    variants.add(LookupElementBuilder.create((String)url).withIcon(SpringApiIcons.Spring).withTailText(" (Spring Security)", true));
                }
                Object[] objectArray = variants.toArray(new LookupElementBuilder[0]);
                if (objectArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return objectArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/security/references/SpringSecurityWebPathProvider$1", "getVariants"));
            }
        });
        return true;
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    private static List<String> getSpringSecurityURLs(Module module) {
        SmartList urls = new SmartList();
        boolean foundCustomLogin = false;
        boolean foundCustomLogout = false;
        SpringManager springManager = SpringManager.getInstance((Project)module.getProject());
        Set configFiles = springManager.getCombinedModel(module).getConfigFiles();
        if (!configFiles.isEmpty()) {
            PsiClass logoutConfigurer = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.config.annotation.web.configurers.LogoutConfigurer");
            PsiClass loginFormConfigurer = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer");
            for (PsiFile file : configFiles) {
                if (file instanceof XmlFile) {
                    DomFileElement domFileElement;
                    if (!SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file)) || (domFileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)((XmlFile)file))) == null || !SpringDomUtils.hasElement((DomFileElement)domFileElement, Http.class)) continue;
                    List https = DomUtil.getDefinedChildrenOfType((DomElement)domFileElement.getRootElement(), Http.class, (boolean)true, (boolean)false);
                    for (Http http : https) {
                        for (FormLogin login : http.getFormLogins()) {
                            String loginUrl = login.getLoginProcessingUrl().getStringValue();
                            if (!StringUtil.isNotEmpty((String)loginUrl)) continue;
                            urls.add(loginUrl);
                            foundCustomLogin = true;
                        }
                        for (Logout logout : http.getLogouts()) {
                            String logoutUrl = logout.getLogoutUrl().getStringValue();
                            if (!StringUtil.isNotEmpty((String)logoutUrl)) continue;
                            urls.add(logoutUrl);
                            foundCustomLogout = true;
                        }
                    }
                    continue;
                }
                if (!(file instanceof PsiJavaFile)) continue;
                for (PsiClass psiClass : ((PsiJavaFile)file).getClasses()) {
                    if (!InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter")) continue;
                    for (PsiMethod configure : psiClass.findMethodsByName("configure", false)) {
                        Set<String> formLoginUrls;
                        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)configure);
                        Set<String> logoutUrls = SpringSecurityWebPathProvider.getConfiguredUrls(logoutConfigurer, "logoutUrl", localSearchScope);
                        if (!logoutUrls.isEmpty()) {
                            urls.addAll(logoutUrls);
                            foundCustomLogout = true;
                        }
                        if ((formLoginUrls = SpringSecurityWebPathProvider.getConfiguredUrls(loginFormConfigurer, "loginPage", localSearchScope)).isEmpty()) continue;
                        urls.addAll(formLoginUrls);
                        foundCustomLogin = true;
                    }
                }
            }
        }
        if (!foundCustomLogin) {
            urls.add(SpringSecurityUtil.isAtLeastVersion(module, SpringSecurityVersion.V_4_0_4) ? LOGIN_DEFAULT_4_X : LOGIN_DEFAULT_3_X);
        }
        if (!foundCustomLogout) {
            urls.add(SpringSecurityUtil.isAtLeastVersion(module, SpringSecurityVersion.V_4_0_4) ? LOGOUT_DEFAULT_4_X : LOGOUT_DEFAULT_3_X);
        }
        return urls;
    }

    @NotNull
    private static Set<String> getConfiguredUrls(@Nullable PsiClass logoutConfigurer, String methodName, LocalSearchScope localSearchScope) {
        PsiMethod[] logoutUrls;
        HashSet urls = ContainerUtil.newHashSet();
        if (logoutConfigurer != null && (logoutUrls = logoutConfigurer.findMethodsByName(methodName, false)).length == 1 && logoutUrls[0] != null) {
            for (Pair pair : StringExpressionHelper.searchStringExpressions((PsiMethod)logoutUrls[0], (SearchScope)localSearchScope, (int)0)) {
                ContainerUtil.addIfNotNull((Collection)urls, (Object)pair.getSecond());
            }
        }
        HashSet hashSet = urls;
        if (hashSet == null) {
            SpringSecurityWebPathProvider.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/references/SpringSecurityWebPathProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/references/SpringSecurityWebPathProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguredUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createReferences";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPathReference";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

