/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe.decoder.psd;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class TextEngine {
    private static final byte TOKEN_STRING_START = 40;
    private static final byte TOKEN_STRING_END = 41;
    private static final byte TOKEN_PROPERTY_START = 47;
    private static final byte TOKEN_ARRAY_START = 91;
    private static final byte TOKEN_ARRAY_END = 93;
    private static final byte TOKEN_SPACE = 32;
    private static final byte TOKEN_TAB = 9;
    private static final byte TOKEN_LINE_END = 10;
    private static final byte TOKEN_FLOAT = 46;
    private static final byte TOKEN_BOOLEAN_TRUE = 116;
    private static final byte TOKEN_BOOLEAN_FALSE = 102;
    private static final byte[] TOKEN_MAP_START = new byte[]{60, 60};
    private static final byte[] TOKEN_MAP_END = new byte[]{62, 62};
    private static final byte[] TOKEN_BIG_ENDIAN = new byte[]{-2, -1};
    private Deque<String> nameStack = new LinkedList<String>();
    private Deque<Property> stack = new LinkedList<Property>();

    TextEngine() {
    }

    private static boolean matches(byte[] l, byte[] r, int start) {
        for (int i = 0; i < r.length; ++i) {
            if (l[start + i] == r[i]) continue;
            return false;
        }
        return true;
    }

    public MapProperty parse(byte[] data) {
        MapProperty root = null;
        this.nameStack.clear();
        this.stack.clear();
        try {
            int pos = 0;
            while (pos < data.length) {
                while (pos < data.length && data[pos] == 9) {
                    ++pos;
                }
                int start = pos;
                while (pos < data.length && data[pos] != 10) {
                    ++pos;
                }
                int length = pos - start;
                if (length == 0) {
                    ++pos;
                    continue;
                }
                if (length == 2) {
                    if (TextEngine.matches(data, TOKEN_MAP_START, start)) {
                        this.stack.offerFirst(new MapProperty());
                    } else if (TextEngine.matches(data, TOKEN_MAP_END, start)) {
                        root = (MapProperty)this.stack.pollFirst();
                        this.addProperty(root);
                    }
                } else if (length == 1 && data[start] == 93) {
                    this.addProperty(this.stack.pollFirst());
                } else if (data[start] == 47) {
                    int nameStart = start + 1;
                    while (start < pos && data[start] != 32) {
                        ++start;
                    }
                    int nameEnd = start++;
                    String name = new String(data, nameStart, nameEnd - nameStart);
                    this.nameStack.offerFirst(name);
                    if (data[nameEnd] != 10) {
                        int valueLength = pos - start;
                        switch (data[start]) {
                            case 91: {
                                this.stack.offerFirst(new ListProperty());
                                if (data[pos - 1] != 93) break;
                                String value = new String(data, start + 1, valueLength - 2);
                                for (String element : value.trim().split("\\s+")) {
                                    if (element.isEmpty()) continue;
                                    this.parseNumber(element);
                                }
                                this.addProperty(this.stack.pollFirst());
                                break;
                            }
                            case 40: {
                                if (!TextEngine.matches(data, TOKEN_BIG_ENDIAN, start + 1)) break;
                                while (data[pos - 1] != 41) {
                                    ++pos;
                                    while (pos < data.length && data[pos] != 10) {
                                        ++pos;
                                    }
                                }
                                String value = new String(data, start + 3, pos - start - 4, "UTF-16BE");
                                value = value.replace('\r', '\n');
                                this.addProperty(new StringProperty(value));
                                break;
                            }
                            case 46: {
                                String value = new String(data, start, valueLength);
                                this.addProperty(new FloatProperty(Float.valueOf(Float.parseFloat(value))));
                                break;
                            }
                            case 102: 
                            case 116: {
                                String value = new String(data, start, valueLength);
                                this.addProperty(new BooleanProperty(Boolean.parseBoolean(value)));
                                break;
                            }
                            default: {
                                String value = new String(data, start, valueLength);
                                this.parseNumber(value);
                            }
                        }
                    }
                }
                ++pos;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not decode text engine data", e);
        }
        return root != null ? root : new MapProperty();
    }

    private void parseNumber(String value) {
        int decimalSeparator = value.indexOf(46);
        if (decimalSeparator == -1) {
            this.addProperty(new IntProperty(Integer.parseInt(value)));
        } else {
            this.addProperty(new FloatProperty(Float.valueOf(Float.parseFloat(value))));
        }
    }

    private void addProperty(Property property) {
        Property previous = this.stack.peekFirst();
        if (previous == null) {
            return;
        }
        switch (previous.getType()) {
            case LIST: {
                ((ListProperty)previous).list.add(property);
                break;
            }
            case MAP: {
                String name = this.nameStack.pollFirst();
                ((MapProperty)previous).map.put(name, property);
                break;
            }
            case STRING: {
                break;
            }
            case INTEGER: {
                break;
            }
            case FLOAT: {
                break;
            }
        }
    }

    public static final class FloatProperty
    implements Property<Float> {
        final Float value;

        FloatProperty(Float value) {
            this.value = value;
        }

        @Override
        public Property.Type getType() {
            return Property.Type.FLOAT;
        }

        @Override
        public Float getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class IntProperty
    implements Property<Integer> {
        final Integer value;

        IntProperty(Integer value) {
            this.value = value;
        }

        @Override
        public Property.Type getType() {
            return Property.Type.INTEGER;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class BooleanProperty
    implements Property<Boolean> {
        final Boolean value;

        BooleanProperty(Boolean value) {
            this.value = value;
        }

        @Override
        public Property.Type getType() {
            return Property.Type.BOOLEAN;
        }

        @Override
        public Boolean getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class StringProperty
    implements Property<String> {
        final String text;

        StringProperty(String text) {
            this.text = text;
        }

        @Override
        public Property.Type getType() {
            return Property.Type.STRING;
        }

        @Override
        public String getValue() {
            return this.text;
        }

        public String toString() {
            return this.text;
        }
    }

    public static final class MapProperty
    implements Property<Map<String, Property<?>>> {
        private static final Pattern PATH_PATTERN = Pattern.compile("([a-zA-Z0-9]+)\\[([0-9]+)\\]");
        final Map<String, Property<?>> map = new HashMap();

        @Override
        public Property.Type getType() {
            return Property.Type.MAP;
        }

        @Override
        public Map<String, Property<?>> getValue() {
            return this.map;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Property<?> get(String path) {
            String[] elements;
            Property<?> property = null;
            Map<String, Property<?>> currentMap = this.map;
            Pattern pattern = PATH_PATTERN;
            String[] stringArray = elements = path.split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                int index = -1;
                Matcher matcher = pattern.matcher(element);
                if (matcher.matches()) {
                    element = matcher.group(1);
                    index = Integer.parseInt(matcher.group(2));
                }
                if ((property = currentMap.get(element)) == null) {
                    return property;
                }
                switch (property.getType()) {
                    case LIST: {
                        if (index < 0) return property;
                        Property<?> item = ((ListProperty)property).list.get(index);
                        if (!(item instanceof MapProperty)) {
                            return item;
                        }
                        currentMap = ((MapProperty)item).map;
                        break;
                    }
                    case MAP: {
                        currentMap = ((MapProperty)property).map;
                        break;
                    }
                    case STRING: 
                    case INTEGER: 
                    case FLOAT: 
                    case BOOLEAN: {
                        return property;
                    }
                }
                ++n2;
            }
            return property;
        }
    }

    public static final class ListProperty
    implements Property<List<Property<?>>> {
        final List<Property<?>> list = new ArrayList();

        @Override
        public Property.Type getType() {
            return Property.Type.LIST;
        }

        @Override
        public List<Property<?>> getValue() {
            return this.list;
        }

        public float[] toFloatArray() {
            float[] a = new float[this.list.size()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = ((FloatProperty)this.list.get(i)).getValue().floatValue();
            }
            return a;
        }

        public int[] toIntArray() {
            int[] a = new int[this.list.size()];
            for (int i = 0; i < a.length; ++i) {
                a[i] = ((IntProperty)this.list.get(i)).getValue();
            }
            return a;
        }
    }

    public static interface Property<T> {
        public Type getType();

        public T getValue();

        public static enum Type {
            LIST,
            MAP,
            STRING,
            INTEGER,
            FLOAT,
            BOOLEAN;

        }
    }
}

