/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.highlighting.jam;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.seam.highlighting.jam.SeamJamModelInspectionBase;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.jam.bijection.SeamJamBijection;
import com.intellij.seam.model.jam.bijection.SeamJamInjection;
import com.intellij.seam.model.jam.bijection.SeamJamOutjection;
import com.intellij.seam.resources.SeamInspectionBundle;
import com.intellij.seam.utils.SeamCommonUtils;
import com.intellij.seam.utils.beans.ContextVariable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SeamBijectionTypeMismatchInspection
extends SeamJamModelInspectionBase {
    static final String[] myHardCodedClasses = new String[]{"javax.persistence.EntityManager"};

    @Override
    protected void checkSeamJamComponent(SeamJamComponent jamComponent, ProblemsHolder holder) {
        Module module = jamComponent.getModule();
        for (SeamJamInjection injection : jamComponent.getInjections()) {
            SeamBijectionTypeMismatchInspection.checkIncorrectContextVariableType(holder, injection, module);
        }
        for (SeamJamOutjection outjection : jamComponent.getOutjections()) {
            SeamBijectionTypeMismatchInspection.checkIncorrectContextVariableType(holder, outjection, module);
        }
    }

    private static void checkIncorrectContextVariableType(ProblemsHolder holder, SeamJamBijection bijection, Module module) {
        PsiType type = bijection.getType();
        if (type == null) {
            return;
        }
        String variableName = bijection.getName();
        if (variableName != null && !SeamCommonUtils.isElText(variableName)) {
            ContextVariable contextVariable = SeamCommonUtils.getContextVariable(variableName, module);
            if (contextVariable == null) {
                return;
            }
            PsiType contextVariableType = contextVariable.getType();
            if (!PsiType.VOID.equals((Object)contextVariableType) && !SeamBijectionTypeMismatchInspection.isAssignable(type, contextVariableType)) {
                holder.registerProblem((PsiElement)bijection.getIdentifyingAnnotation(), SeamInspectionBundle.message("bijection.context.variable.type.mismatch", contextVariableType.getPresentableText(), type.getPresentableText()), new LocalQuickFix[0]);
            }
        }
    }

    private static boolean isAssignable(PsiType type, PsiType contextVariableType) {
        if (type.isAssignableFrom(contextVariableType)) {
            return true;
        }
        for (String aClass : myHardCodedClasses) {
            if (!aClass.equals(contextVariableType.getCanonicalText())) continue;
            return contextVariableType.isAssignableFrom(type);
        }
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = SeamInspectionBundle.message("bijection.type.mismatch.inspection.name", new Object[0]);
        if (string == null) {
            SeamBijectionTypeMismatchInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SeamBijectionTypeMismatchInspection" == null) {
            SeamBijectionTypeMismatchInspection.$$$reportNull$$$0(1);
        }
        return "SeamBijectionTypeMismatchInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            SeamBijectionTypeMismatchInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/seam/highlighting/jam/SeamBijectionTypeMismatchInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

