/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.annotations.JamPsiValidity;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamChildrenQuery;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.targets.AliasingPsiTargetUtil;
import com.intellij.seam.model.SeamComponentScope;
import com.intellij.seam.model.jam.SeamJamComponentBase;
import com.intellij.seam.model.jam.SeamJamFactory;
import com.intellij.seam.model.jam.SeamJamInstall;
import com.intellij.seam.model.jam.SeamJamRole;
import com.intellij.seam.model.jam.SeamJamRoles;
import com.intellij.seam.model.jam.SeamJamUnwrap;
import com.intellij.seam.model.jam.bijection.SeamJamInjection;
import com.intellij.seam.model.jam.bijection.SeamJamOutjection;
import com.intellij.seam.model.jam.context.SeamJamBegin;
import com.intellij.seam.model.jam.context.SeamJamEnd;
import com.intellij.seam.model.jam.context.SeamJamObserver;
import com.intellij.seam.model.jam.context.SeamJamRaiseEvent;
import com.intellij.seam.model.jam.dataModel.SeamJamDataModel;
import com.intellij.seam.model.jam.dataModel.SeamJamDataModelSelection;
import com.intellij.seam.model.jam.dataModel.SeamJamDataModelSelectionIndex;
import com.intellij.seam.model.jam.jsf.SeamJamConverter;
import com.intellij.seam.model.jam.jsf.SeamJamValidator;
import com.intellij.seam.model.jam.lifecycle.SeamJamCreate;
import com.intellij.seam.model.jam.lifecycle.SeamJamDestroy;
import com.intellij.seam.utils.SeamCommonUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(typeName="Seam Component")
public abstract class SeamJamComponent
extends SeamJamComponentBase {
    public static final JamClassMeta<SeamJamComponent> META = new JamClassMeta(SeamJamComponent.class).addPomTargetProducer((seamJamComponent, consumer) -> consumer.consume((Object)seamJamComponent.getPsiTarget()));
    public static final JamStringAttributeMeta.Single<String> NAME_VALUE_META = JamAttributeMeta.singleString((String)"value");
    private static final JamAnnotationMeta ANNOTATION_META = new JamAnnotationMeta("org.jboss.seam.annotations.Name").addAttribute(NAME_VALUE_META);
    private static final JamChildrenQuery<SeamJamBegin> BEGINS_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamBegin.ANNOTATION_META, SeamJamBegin.class);
    private static final JamChildrenQuery<SeamJamEnd> ENDS_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamEnd.ANNOTATION_META, SeamJamEnd.class);
    private static final JamChildrenQuery<SeamJamObserver> OBSERVERS_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamObserver.ANNOTATION_META, SeamJamObserver.class);
    private static final JamChildrenQuery<SeamJamRaiseEvent> RAISE_EVENTS_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamRaiseEvent.ANNOTATION_META, SeamJamRaiseEvent.class);
    private static final JamChildrenQuery<SeamJamCreate> CREATES_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamCreate.ANNOTATION_META, SeamJamCreate.class);
    private static final JamChildrenQuery<SeamJamDestroy> DESTROY_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamDestroy.ANNOTATION_META, SeamJamDestroy.class);
    private static final JamChildrenQuery<SeamJamInjection.Field> IN_FIELD_QUERY = JamChildrenQuery.annotatedFields((JamAnnotationMeta)SeamJamInjection.ANNOTATION_META, SeamJamInjection.Field.class);
    private static final JamChildrenQuery<SeamJamInjection.Method> IN_METHOD_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamInjection.ANNOTATION_META, SeamJamInjection.Method.class);
    private static final JamChildrenQuery<SeamJamOutjection.Field> OUT_FIELD_QUERY = JamChildrenQuery.annotatedFields((JamAnnotationMeta)SeamJamOutjection.ANNOTATION_META, SeamJamOutjection.Field.class);
    private static final JamChildrenQuery<SeamJamOutjection.Method> OUT_METHOD_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamOutjection.ANNOTATION_META, SeamJamOutjection.Method.class);
    private static final JamChildrenQuery<SeamJamDataModel.Method> DM_METHOD_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamDataModel.ANNOTATION_META, SeamJamDataModel.Method.META);
    private static final JamChildrenQuery<SeamJamDataModel.Field> DM_FIELD_QUERY = JamChildrenQuery.annotatedFields((JamAnnotationMeta)SeamJamDataModel.ANNOTATION_META, SeamJamDataModel.Field.META);
    private static final JamChildrenQuery<SeamJamDataModelSelection.Method> DM_SELECTION_METHOD_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamDataModelSelection.ANNOTATION_META, SeamJamDataModelSelection.Method.class);
    private static final JamChildrenQuery<SeamJamDataModelSelection.Field> DM_SELECTION_FIELD_QUERY = JamChildrenQuery.annotatedFields((JamAnnotationMeta)SeamJamDataModelSelection.ANNOTATION_META, SeamJamDataModelSelection.Field.class);
    private static final JamChildrenQuery<SeamJamDataModelSelectionIndex.Method> DM_SELECTION_INDEX_METHOD_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamDataModelSelectionIndex.ANNOTATION_META, SeamJamDataModelSelectionIndex.Method.class);
    private static final JamChildrenQuery<SeamJamDataModelSelectionIndex.Field> DM_SELECTION_INDEX_FIELD_QUERY = JamChildrenQuery.annotatedFields((JamAnnotationMeta)SeamJamDataModelSelectionIndex.ANNOTATION_META, SeamJamDataModelSelectionIndex.Field.class);
    private static final JamChildrenQuery<SeamJamUnwrap> UNWRAP_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamUnwrap.ANNOTATION_META, SeamJamUnwrap.class);
    private static final JamChildrenQuery<SeamJamFactory> FACTORY_QUERY = JamChildrenQuery.annotatedMethods((JamAnnotationMeta)SeamJamFactory.ANNOTATION_META, SeamJamFactory.META);

    @Override
    @NotNull
    public String getComponentName() {
        String nameValue = this.getNamedAttributeValue();
        String string = StringUtil.isEmptyOrSpaces((String)nameValue) ? this.getDefaultName() : nameValue;
        if (string == null) {
            SeamJamComponent.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private String getNamedAttributeValue() {
        JamStringAttributeElement<String> namedStringAttributeElement = this.getNamedStringAttributeElement();
        if (namedStringAttributeElement == null) {
            return null;
        }
        return namedStringAttributeElement.getStringValue();
    }

    @Nullable
    protected JamStringAttributeElement<String> getNamedStringAttributeElement() {
        return (JamStringAttributeElement)ANNOTATION_META.getAttribute((PsiModifierListOwner)this.getPsiElement(), NAME_VALUE_META);
    }

    @NotNull
    public String getDefaultName() {
        String string = StringUtil.decapitalize((String)this.getPsiElement().getName());
        if (string == null) {
            SeamJamComponent.$$$reportNull$$$0(1);
        }
        return string;
    }

    public PsiElement getIdentifyingPsiElement() {
        return PomService.convertToPsi((Project)this.getProject(), (PomTarget)this.getPsiTarget());
    }

    private Project getProject() {
        return this.getPsiElement().getProject();
    }

    public PsiTarget getPsiTarget() {
        JamStringAttributeElement<String> namedAttributeValue = this.getNamedStringAttributeElement();
        if (namedAttributeValue == null || StringUtil.isEmptyOrSpaces((String)namedAttributeValue.getStringValue())) {
            return this.getAliasingPsiTarget();
        }
        return new JamPomTarget((JamElement)this, namedAttributeValue);
    }

    private PsiTarget getAliasingPsiTarget() {
        return new AliasingPsiTarget((PsiNamedElement)this.getPsiElement()){

            public String getNameAlias(@Nullable String delegatePsiTargetName) {
                return StringUtil.decapitalize((String)delegatePsiTargetName);
            }

            @NotNull
            public AliasingPsiTarget setAliasName(@NotNull String newAliasName) {
                if (newAliasName == null) {
                    1.$$$reportNull$$$0(0);
                }
                AliasingPsiTargetUtil.renameTargets((AliasingPsiTarget)this, (String)StringUtil.capitalize((String)newAliasName));
                AliasingPsiTarget aliasingPsiTarget = super.setAliasName(newAliasName);
                if (aliasingPsiTarget == null) {
                    1.$$$reportNull$$$0(1);
                }
                return aliasingPsiTarget;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newAliasName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/seam/model/jam/SeamJamComponent$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/seam/model/jam/SeamJamComponent$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "setAliasName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "setAliasName";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @JamPsiConnector
    @NotNull
    public abstract PsiClass getPsiElement();

    @JamPsiValidity
    public abstract boolean isValid();

    @NotNull
    public List<SeamJamFactory> getFactories() {
        List list = FACTORY_QUERY.findChildren(this.getPsiRef());
        if (list == null) {
            SeamJamComponent.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<SeamJamRole> getRoles() {
        List list = JamCommonUtil.getElementsIncludingSingle((PsiModifierListOwner)this.getPsiElement(), (JamAnnotationMeta)SeamJamRoles.ANNOTATION_META, SeamJamRoles.ROLES_COLLECTION_ATTRIBUTE);
        if (list == null) {
            SeamJamComponent.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public SeamJamValidator getValidator() {
        return (SeamJamValidator)JamService.getJamService((Project)this.getProject()).getJamElement((PsiElement)this.getPsiElement(), new JamMemberMeta[]{SeamJamValidator.META});
    }

    @Nullable
    public SeamJamConverter getConverter() {
        return (SeamJamConverter)JamService.getJamService((Project)this.getProject()).getJamElement((PsiElement)this.getPsiElement(), new JamMemberMeta[]{SeamJamConverter.META});
    }

    @NotNull
    public List<SeamJamInjection> getInjections() {
        ArrayList<SeamJamInjection> injections = new ArrayList<SeamJamInjection>();
        injections.addAll(IN_FIELD_QUERY.findChildren(this.getPsiRef()));
        injections.addAll(IN_METHOD_QUERY.findChildren(this.getPsiRef()));
        ArrayList<SeamJamInjection> arrayList = injections;
        if (arrayList == null) {
            SeamJamComponent.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public List<SeamJamOutjection> getOutjections() {
        ArrayList<SeamJamOutjection> outjections = new ArrayList<SeamJamOutjection>();
        outjections.addAll(OUT_FIELD_QUERY.findChildren(this.getPsiRef()));
        outjections.addAll(OUT_METHOD_QUERY.findChildren(this.getPsiRef()));
        ArrayList<SeamJamOutjection> arrayList = outjections;
        if (arrayList == null) {
            SeamJamComponent.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public List<? extends SeamJamUnwrap> getUnwraps() {
        List list = UNWRAP_QUERY.findChildren(this.getPsiRef());
        if (list == null) {
            SeamJamComponent.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<SeamJamCreate> getCreates() {
        List list = CREATES_QUERY.findChildren(this.getPsiRef());
        if (list == null) {
            SeamJamComponent.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<SeamJamDestroy> getDestroys() {
        List list = DESTROY_QUERY.findChildren(this.getPsiRef());
        if (list == null) {
            SeamJamComponent.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public List<SeamJamBegin> getBegins() {
        List list = BEGINS_QUERY.findChildren(this.getPsiRef());
        if (list == null) {
            SeamJamComponent.$$$reportNull$$$0(9);
        }
        return list;
    }

    private PsiElementRef<PsiClass> getPsiRef() {
        return PsiElementRef.real((PsiElement)this.getPsiElement());
    }

    @NotNull
    public List<SeamJamEnd> getEnds() {
        List list = ENDS_QUERY.findChildren(this.getPsiRef());
        if (list == null) {
            SeamJamComponent.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<? extends SeamJamObserver> getObservers() {
        List list = OBSERVERS_QUERY.findChildren(this.getPsiRef());
        if (list == null) {
            SeamJamComponent.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<? extends SeamJamRaiseEvent> getRaiseEvents() {
        List list = RAISE_EVENTS_QUERY.findChildren(this.getPsiRef());
        if (list == null) {
            SeamJamComponent.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<? extends SeamJamDataModel> getDataModels() {
        ArrayList dataModels = new ArrayList();
        dataModels.addAll(DM_FIELD_QUERY.findChildren(this.getPsiRef()));
        dataModels.addAll(DM_METHOD_QUERY.findChildren(this.getPsiRef()));
        ArrayList arrayList = dataModels;
        if (arrayList == null) {
            SeamJamComponent.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public List<SeamJamDataModelSelection> getDataModelSelections() {
        ArrayList<SeamJamDataModelSelection> list = new ArrayList<SeamJamDataModelSelection>();
        list.addAll(DM_SELECTION_FIELD_QUERY.findChildren(this.getPsiRef()));
        list.addAll(DM_SELECTION_METHOD_QUERY.findChildren(this.getPsiRef()));
        ArrayList<SeamJamDataModelSelection> arrayList = list;
        if (arrayList == null) {
            SeamJamComponent.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public List<SeamJamDataModelSelectionIndex> getDataModelSelectionIndexes() {
        ArrayList<SeamJamDataModelSelectionIndex> list = new ArrayList<SeamJamDataModelSelectionIndex>();
        list.addAll(DM_SELECTION_INDEX_FIELD_QUERY.findChildren(this.getPsiRef()));
        list.addAll(DM_SELECTION_INDEX_METHOD_QUERY.findChildren(this.getPsiRef()));
        ArrayList<SeamJamDataModelSelectionIndex> arrayList = list;
        if (arrayList == null) {
            SeamJamComponent.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @Nullable
    public SeamJamInstall getInstall() {
        return (SeamJamInstall)JamService.getJamService((Project)this.getProject()).getJamElement((PsiElement)this.getPsiElement(), new JamMemberMeta[]{SeamJamInstall.META});
    }

    @Nullable
    public PsiAnnotation getIdentifyingAnnotation() {
        return ANNOTATION_META.getAnnotation((PsiModifierListOwner)this.getPsiElement());
    }

    @Override
    public SeamComponentScope getComponentScope() {
        PsiAnnotation scopeAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)this.getPsiElement(), (String[])new String[]{"org.jboss.seam.annotations.Scope"});
        SeamComponentScope defaultScope = this.getDefaultScope();
        if (scopeAnnotation == null) {
            return defaultScope;
        }
        SeamComponentScope value = (SeamComponentScope)((Object)AnnotationModelUtil.getEnumValue((PsiAnnotation)scopeAnnotation, (String)"value", SeamComponentScope.class).getValue());
        return value == null ? defaultScope : value;
    }

    private SeamComponentScope getDefaultScope() {
        for (EjbClassRole role : SeamCommonUtils.getEjbRoles(this)) {
            EnterpriseBean bean = role.getEnterpriseBean();
            if (!(bean instanceof SessionBean) || SeamCommonUtils.isStateful((SessionBean)bean)) continue;
            return SeamComponentScope.STATELESS;
        }
        return SeamComponentScope.CONVERSATION;
    }

    @Override
    public PsiType getComponentType() {
        PsiClass psiClass = this.getPsiElement();
        PsiType unwrapType = SeamCommonUtils.getUnwrapType(psiClass);
        return unwrapType == null ? JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass) : unwrapType;
    }

    static {
        META.addAnnotation(ANNOTATION_META);
        META.addChildrenQuery(BEGINS_QUERY);
        META.addChildrenQuery(ENDS_QUERY);
        META.addChildrenQuery(OBSERVERS_QUERY);
        META.addChildrenQuery(RAISE_EVENTS_QUERY);
        META.addChildrenQuery(CREATES_QUERY);
        META.addChildrenQuery(DESTROY_QUERY);
        META.addChildrenQuery(IN_FIELD_QUERY);
        META.addChildrenQuery(IN_METHOD_QUERY);
        META.addChildrenQuery(OUT_FIELD_QUERY);
        META.addChildrenQuery(OUT_METHOD_QUERY);
        META.addChildrenQuery(DM_FIELD_QUERY);
        META.addChildrenQuery(DM_METHOD_QUERY);
        META.addChildrenQuery(DM_SELECTION_FIELD_QUERY);
        META.addChildrenQuery(DM_SELECTION_METHOD_QUERY);
        META.addChildrenQuery(DM_SELECTION_INDEX_FIELD_QUERY);
        META.addChildrenQuery(DM_SELECTION_INDEX_METHOD_QUERY);
        META.addChildrenQuery(UNWRAP_QUERY);
        META.addChildrenQuery(FACTORY_QUERY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/seam/model/jam/SeamJamComponent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactories";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoles";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjections";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutjections";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnwraps";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreates";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDestroys";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBegins";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnds";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getObservers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRaiseEvents";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModels";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModelSelections";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataModelSelectionIndexes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

