/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.model.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.seam.model.jam.MergedSeamComponent;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SeamJamModel {
    private static final Key<CachedValue<MergedSeamComponent>> MERGED_SEAM_COMPONENT = Key.create((String)"MERGED_SEAM_COMPONENT");
    private final Module myModule;

    public static SeamJamModel getModel(@NotNull Module module) {
        if (module == null) {
            SeamJamModel.$$$reportNull$$$0(0);
        }
        return (SeamJamModel)ModuleServiceManager.getService((Module)module, SeamJamModel.class);
    }

    public SeamJamModel(@NotNull Module module) {
        if (module == null) {
            SeamJamModel.$$$reportNull$$$0(1);
        }
        this.myModule = module;
    }

    public Module getModule() {
        return this.myModule;
    }

    public List<SeamJamComponent> getAnnotatedSeamComponents(boolean showFromLibraries) {
        return this.getJamClassElements(SeamJamComponent.META, "org.jboss.seam.annotations.Name", showFromLibraries);
    }

    public <T extends JamElement> List<T> getJamClassElements(JamClassMeta<T> clazz, String anno, boolean showFromLibraries) {
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        GlobalSearchScope scope = this.getScope(showFromLibraries);
        return service.getJamClassElements(clazz, anno, scope);
    }

    private GlobalSearchScope getScope(boolean showFromLibraries) {
        return showFromLibraries ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule) : GlobalSearchScope.moduleWithDependenciesScope((Module)this.myModule);
    }

    @NotNull
    public Set<SeamJamComponent> getSeamComponents() {
        Set<SeamJamComponent> set = this.getSeamComponents(true);
        if (set == null) {
            SeamJamModel.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<SeamJamComponent> getSeamComponents(boolean mergeDomComponents) {
        Set<SeamJamComponent> set = this.getSeamComponents(mergeDomComponents, true);
        if (set == null) {
            SeamJamModel.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<SeamJamComponent> getSeamComponents(boolean mergeDomComponents, boolean fromLibs) {
        List<SeamJamComponent> annotated = this.getAnnotatedSeamComponents(fromLibs);
        HashSet<SeamJamComponent> components = new HashSet<SeamJamComponent>(annotated);
        if (mergeDomComponents) {
            components.addAll(this.getMergedComponents(annotated));
        }
        HashSet<SeamJamComponent> hashSet = components;
        if (hashSet == null) {
            SeamJamModel.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    public List<SeamJamComponent> getMergedComponents(boolean fromLibs) {
        return this.getMergedComponents(this.getAnnotatedSeamComponents(fromLibs));
    }

    public List<SeamJamComponent> getMergedComponents(List<SeamJamComponent> annotated) {
        ArrayList<SeamJamComponent> mergedComponents = new ArrayList<SeamJamComponent>();
        Module module = this.getModule();
        if (module != null) {
            List psiTypes = ContainerUtil.mapNotNull(annotated, seamJamComponent -> seamJamComponent.getComponentType());
            for (SeamDomModel model : SeamDomModelManager.getInstance(module.getProject()).getAllModels(module)) {
                for (SeamDomComponent domComponent : model.getSeamComponents()) {
                    PsiClass psiClass;
                    PsiType type;
                    if (psiTypes.contains(domComponent.getComponentType()) || !((type = domComponent.getComponentType()) instanceof PsiClassType) || (psiClass = ((PsiClassType)type).resolve()) == null) continue;
                    mergedComponents.add(this.getOrCreateMergedComponent(psiClass, domComponent));
                }
            }
        }
        return mergedComponents;
    }

    @NotNull
    private MergedSeamComponent getOrCreateMergedComponent(PsiClass psiClass, SeamDomComponent domComponent) {
        CachedValue cachedValue = (CachedValue)psiClass.getUserData(MERGED_SEAM_COMPONENT);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)psiClass.getProject()).createCachedValue(() -> {
                MergedSeamComponent mergedSeamComponent = new MergedSeamComponent(psiClass, domComponent);
                return new CachedValueProvider.Result((Object)mergedSeamComponent, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }, false);
            psiClass.putUserData(MERGED_SEAM_COMPONENT, (Object)cachedValue);
        }
        MergedSeamComponent mergedSeamComponent = (MergedSeamComponent)cachedValue.getValue();
        if (mergedSeamComponent == null) {
            SeamJamModel.$$$reportNull$$$0(5);
        }
        return mergedSeamComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/seam/model/jam/SeamJamModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/seam/model/jam/SeamJamModel";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeamComponents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMergedComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

