/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.structure;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.model.xml.SeamDomModel;
import com.intellij.seam.model.xml.SeamDomModelManager;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import com.intellij.seam.structure.SeamDomComponentNodeDescriptor;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class SeamDomModelNodeDescriptor
extends JavaeeNodeDescriptor<XmlFile> {
    @Nullable
    private final VirtualFile myParentContent;

    public SeamDomModelNodeDescriptor(Project project, NodeDescriptor parentDescriptor, Object parameters, XmlFile element, @Nullable VirtualFile parentContent) {
        super(project, parentDescriptor, parameters, (Object)element);
        this.myParentContent = parentContent;
    }

    protected String getNewNodeText() {
        VirtualFile file = ((XmlFile)this.getElement()).getVirtualFile();
        return file == null ? "" : file.getPresentableName();
    }

    protected Icon getNewIcon() {
        return ((XmlFile)this.getElement()).getIcon(0);
    }

    protected void doUpdate() {
        super.doUpdate();
        String textExt = this.getNewNodeTextExt();
        if (textExt != null) {
            this.addColoredFragment(" (" + this.getNewNodeTextExt() + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    @Nullable
    protected String getNewNodeTextExt() {
        XmlFile xmlFile = (XmlFile)this.getElement();
        if (xmlFile == null || !xmlFile.isValid() || this.myParentContent == null) {
            return null;
        }
        return VfsUtilCore.getRelativePath((VirtualFile)xmlFile.getVirtualFile(), (VirtualFile)this.myParentContent, (char)'/');
    }

    public JavaeeNodeDescriptor[] getChildren() {
        ArrayList<SeamDomComponentNodeDescriptor> children = new ArrayList<SeamDomComponentNodeDescriptor>();
        SeamDomModel model = SeamDomModelManager.getInstance(this.getProject()).getSeamModel((XmlFile)this.getElement());
        if (model != null) {
            for (SeamDomComponent domComponent : model.getSeamComponents()) {
                children.add(new SeamDomComponentNodeDescriptor(this.getProject(), (NodeDescriptor)this, this.getParameters(), domComponent));
            }
        }
        return children.toArray(JavaeeNodeDescriptor.EMPTY_ARRAY);
    }
}

