/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.structure;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.model.jam.SeamJamComponent;
import com.intellij.seam.resources.SeamBundle;
import com.intellij.seam.structure.SeamComponentNodeDescriptor;
import com.intellij.seam.structure.SeamDomModelNodeDescriptor;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class SeamModuleLibrariesNodeDescriptor
extends JavaeeNodeDescriptor<Module> {
    private final List<SeamJamComponent> myCompiledElements;
    private final List<XmlFile> myModelFiles;

    public SeamModuleLibrariesNodeDescriptor(List<SeamJamComponent> compiledElements, List<XmlFile> modelFiles, Project project, NodeDescriptor parentDescriptor, Object parameters, Module element) {
        super(project, parentDescriptor, parameters, (Object)element);
        this.myCompiledElements = compiledElements;
        this.myModelFiles = modelFiles;
    }

    protected String getNewNodeText() {
        return SeamBundle.message("seam.j2ee.structure.module.libraries", new Object[0]);
    }

    protected DeleteProvider getDeleteProvider() {
        return super.getDeleteProvider();
    }

    public JavaeeNodeDescriptor[] getChildren() {
        VirtualFile forJar;
        ArrayList<Object> nodes = new ArrayList<Object>();
        HashMap libs = new HashMap();
        HashMap modelLibs = new HashMap();
        ArrayList<SeamJamComponent> unknownLib = new ArrayList<SeamJamComponent>();
        for (SeamJamComponent compiledElement : this.myCompiledElements) {
            forJar = this.getJarFile(compiledElement.getPsiElement().getContainingFile().getVirtualFile());
            if (forJar != null) {
                if (libs.get(forJar) == null) {
                    libs.put(forJar, new ArrayList());
                }
                ((List)libs.get(forJar)).add(compiledElement);
                continue;
            }
            unknownLib.add(compiledElement);
        }
        for (XmlFile modelFile : this.myModelFiles) {
            forJar = this.getJarFile(modelFile.getVirtualFile());
            if (forJar == null) continue;
            if (modelLibs.get(forJar) == null) {
                modelLibs.put(forJar, new ArrayList());
            }
            ((List)modelLibs.get(forJar)).add(modelFile);
        }
        for (VirtualFile file : libs.keySet()) {
            nodes.add((Object)new ModuleLibNodeDescriptor(this.getProject(), (NodeDescriptor)this, this.getParameters(), file, (List)libs.get(file), (List)modelLibs.get(file)));
        }
        for (SeamJamComponent seamComponent : unknownLib) {
            nodes.add((Object)new SeamComponentNodeDescriptor(seamComponent, this, this.getParameters()));
        }
        return nodes.toArray(JavaeeNodeDescriptor.EMPTY_ARRAY);
    }

    private VirtualFile getJarFile(VirtualFile file) {
        VirtualFile forJar = JarFileSystem.getInstance().getVirtualFileForJar(file);
        return forJar;
    }

    protected Icon getNewIcon() {
        return PlatformIcons.LIBRARY_ICON;
    }

    public int getWeight() {
        return 10000;
    }

    private static class ModuleLibNodeDescriptor
    extends JavaeeNodeDescriptor<VirtualFile> {
        private final List<SeamJamComponent> mySeamComponents;
        private final List<XmlFile> myXmlFiles;

        private ModuleLibNodeDescriptor(Project project, NodeDescriptor parentDescriptor, Object parameters, VirtualFile element, @Nullable List<SeamJamComponent> seamComponents, @Nullable List<XmlFile> xmlFiles) {
            super(project, parentDescriptor, parameters, (Object)element);
            this.mySeamComponents = seamComponents;
            this.myXmlFiles = xmlFiles;
        }

        protected String getNewNodeText() {
            return ((VirtualFile)this.getElement()).getName();
        }

        public JavaeeNodeDescriptor[] getChildren() {
            ArrayList<Object> nodes = new ArrayList<Object>();
            if (this.myXmlFiles != null) {
                for (XmlFile xmlFile : this.myXmlFiles) {
                    nodes.add((Object)new SeamDomModelNodeDescriptor(this.getProject(), (NodeDescriptor)this, this.getParameters(), xmlFile, JarFileSystem.getInstance().getJarRootForLocalFile((VirtualFile)this.getElement())));
                }
            }
            if (this.mySeamComponents != null) {
                for (SeamJamComponent seamComponent : this.mySeamComponents) {
                    nodes.add((Object)new SeamComponentNodeDescriptor(seamComponent, this, this.getParameters()));
                }
            }
            return nodes.toArray(JavaeeNodeDescriptor.EMPTY_ARRAY);
        }

        protected Icon getNewIcon() {
            return ((VirtualFile)this.getElement()).getFileType().getIcon();
        }
    }
}

