/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.editorActions;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlSequenceLiteral;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FreeMarkerBackspaceHandler
extends BackspaceHandlerDelegate {
    private Character myRemoving;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        PsiElement element;
        if (file == null) {
            FreeMarkerBackspaceHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FreeMarkerBackspaceHandler.$$$reportNull$$$0(1);
        }
        if (!FtlPsiUtil.hasFtlViewProvider(file)) {
            return;
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        if (offset == 0) {
            return;
        }
        Document document = editor.getDocument();
        if (offset >= document.getTextLength() - 1) {
            return;
        }
        char next = document.getCharsSequence().charAt(offset + 1);
        this.myRemoving = null;
        if (c == '{' && next == '}') {
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            element = file.findElementAt(offset - 1);
            if (element == null) {
                return;
            }
            if (!FreeMarkerBackspaceHandler.needsRightBrace(element)) {
                return;
            }
            this.myRemoving = Character.valueOf('}');
        }
        if (c == '[' && next == ']') {
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            element = file.findElementAt(offset);
            if (element == null) {
                return;
            }
            if (!FreeMarkerBackspaceHandler.needsRightBracket(element)) {
                return;
            }
            this.myRemoving = Character.valueOf(']');
        }
    }

    public static boolean needsRightBrace(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        IElementType type = node.getElementType();
        return type == FtlElementTypes.EL_START || type == FtlElementTypes.NUM_EL_START || type == FtlElementTypes.LEFT_BRACE;
    }

    public static boolean needsRightBracket(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        if (node.getElementType() != FtlElementTypes.LEFT_BRACKET) {
            return false;
        }
        FtlDirectiveStyle style = ((FtlFile)element.getContainingFile()).getDirectiveStyle();
        if (style == FtlDirectiveStyle.ANGLE) {
            return false;
        }
        PsiElement parent = element.getParent();
        return parent instanceof FtlSequenceLiteral && parent.getTextLength() == 2;
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        if (this.myRemoving != null) {
            int offset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            int prev = offset == 0 ? 32 : (int)document.getCharsSequence().charAt(offset - 1);
            boolean removePreceding = this.myRemoving.charValue() == '}' && (prev == 36 || prev == 35);
            document.deleteString(removePreceding ? offset - 1 : offset, offset + 1);
            this.myRemoving = null;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/freemarker/editorActions/FreeMarkerBackspaceHandler";
        objectArray[2] = "beforeCharDeleted";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

