/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.editorActions;

import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;

public class FreeMarkerQuoteHandler
extends SimpleTokenSetQuoteHandler {
    public FreeMarkerQuoteHandler() {
        super(new IElementType[]{FtlElementTypes.SINGLE_QUOTE, FtlElementTypes.DOUBLE_QUOTE, FtlElementTypes.R_SINGLE_QUOTE, FtlElementTypes.R_DOUBLE_QUOTE});
    }

    private static int getTokenLength(IElementType type) {
        if (type == FtlElementTypes.R_SINGLE_QUOTE || type == FtlElementTypes.R_DOUBLE_QUOTE) {
            return 2;
        }
        return 1;
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (this.myLiteralTokenSet.contains(iterator.getTokenType())) {
            if (iterator.getEnd() - iterator.getStart() != 1) {
                return false;
            }
            return !this._isOpeningQuote(iterator);
        }
        return false;
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        if (this.myLiteralTokenSet.contains(iterator.getTokenType())) {
            if (offset != iterator.getStart() + FreeMarkerQuoteHandler.getTokenLength(iterator.getTokenType()) - 1) {
                return false;
            }
            return this._isOpeningQuote(iterator);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _isOpeningQuote(HighlighterIterator iterator) {
        iterator.retreat();
        try {
            if (iterator.atEnd()) {
                boolean bl = true;
                return bl;
            }
            IElementType type = iterator.getTokenType();
            if (this.myLiteralTokenSet.contains(type) || ((Object)((Object)FtlElementTypes.STRING_TEXT)).equals(type) || ((Object)((Object)FtlElementTypes.EL_END)).equals(type) || ((Object)((Object)FtlElementTypes.CHAR_ESCAPE)).equals(type)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            iterator.advance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNonClosedLiteral(Editor editor, HighlighterIterator iterator, int offset) {
        int start = iterator.getStart();
        try {
            Document doc = editor.getDocument();
            CharSequence chars = doc.getCharsSequence();
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            while (!iterator.atEnd() && iterator.getStart() < lineEnd) {
                IElementType tokenType = iterator.getTokenType();
                if (this.myLiteralTokenSet.contains(tokenType) && (iterator.getStart() >= iterator.getEnd() - FreeMarkerQuoteHandler.getTokenLength(tokenType) || chars.charAt(iterator.getEnd() - 1) != '\"' && chars.charAt(iterator.getEnd() - 1) != '\'')) {
                    boolean bl = true;
                    return bl;
                }
                iterator.advance();
            }
        }
        finally {
            while (iterator.atEnd() || iterator.getStart() != start) {
                iterator.retreat();
            }
        }
        return false;
    }
}

