/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.MethodTextOccurrenceProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class FtlMethodUsageSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public FtlMethodUsageSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            FtlMethodUsageSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            FtlMethodUsageSearcher.$$$reportNull$$$0(1);
        }
        PsiMethod method = queryParameters.getMethod();
        PsiFile containingFile = method.getContainingFile();
        PsiClass psiClass = method.getContainingClass();
        if (containingFile == null || psiClass == null) {
            return;
        }
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (!FtlPsiUtil.hasFtlViewProvider(containingFile)) {
            return;
        }
        FtlFile ftlFile = (FtlFile)fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        if (ftlFile == null || !ftlFile.isImplicitlyIncluded()) {
            return;
        }
        if (!PropertyUtilBase.hasGetterName((PsiMethod)method) || method.getParameterList().getParametersCount() != 1) {
            return;
        }
        SearchScope searchScope = queryParameters.getEffectiveSearchScope();
        if (searchScope instanceof GlobalSearchScope) {
            GlobalSearchScope restrictedScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{FtlFileType.INSTANCE});
            String propName = PropertyUtilBase.getPropertyNameByGetter((PsiMethod)method);
            queryParameters.getOptimizer().searchWord(propName, (SearchScope)restrictedScope, (short)8, true, (PsiElement)method, (RequestResultProcessor)new MethodTextOccurrenceProcessor(psiClass, true, new PsiMethod[]{method}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/freemarker/psi/FtlMethodUsageSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

