/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.ISystemImage;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.avdmanager.AvdUiAction;
import com.android.tools.idea.avdmanager.AvdWizardUtils;
import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.icons.AllIcons;
import java.awt.event.ActionEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/avdmanager/ColdBootNowAction;", "Lcom/android/tools/idea/avdmanager/AvdUiAction;", "avdInfoProvider", "Lcom/android/tools/idea/avdmanager/AvdUiAction$AvdInfoProvider;", "(Lcom/android/tools/idea/avdmanager/AvdUiAction$AvdInfoProvider;)V", "actionPerformed", "", "actionEvent", "Ljava/awt/event/ActionEvent;", "isEnabled", "", "intellij.android"})
public final class ColdBootNowAction
extends AvdUiAction {
    @Override
    public void actionPerformed(@NotNull ActionEvent actionEvent) {
        Intrinsics.checkParameterIsNotNull((Object)actionEvent, (String)"actionEvent");
        AvdInfo avdInfo = this.getAvdInfo();
        if (avdInfo == null) {
            return;
        }
        AvdInfo origAvdInfo = avdInfo;
        ISystemImage iSystemImage = origAvdInfo.getSystemImage();
        if (iSystemImage == null) {
            return;
        }
        ISystemImage origSystemImage = iSystemImage;
        Map coldBootProperties = new LinkedHashMap();
        Map map = origAvdInfo.getProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"origAvdInfo.properties");
        coldBootProperties.putAll(map);
        coldBootProperties.put("fastboot.forceColdBoot", "once");
        AvdInfo coldBootAvdInfo = new AvdInfo(origAvdInfo.getName(), origAvdInfo.getIniFile(), origAvdInfo.getDataFolderPath(), origSystemImage, coldBootProperties);
        AvdManagerConnection.getDefaultAvdManagerConnection().startAvd(this.myAvdInfoProvider.getProject(), coldBootAvdInfo);
    }

    @Override
    public boolean isEnabled() {
        return this.getAvdInfo() != null && AvdWizardUtils.emulatorSupportsFastBoot(AndroidSdks.getInstance().tryToChooseSdkHandler());
    }

    public ColdBootNowAction(@NotNull AvdUiAction.AvdInfoProvider avdInfoProvider) {
        Intrinsics.checkParameterIsNotNull((Object)avdInfoProvider, (String)"avdInfoProvider");
        super(avdInfoProvider, "Cold Boot Now", "Force one cold boot", AllIcons.Actions.Menu_open);
    }
}

