/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.adtui.workbench.AutoHide;
import com.android.tools.adtui.workbench.Side;
import com.android.tools.adtui.workbench.Split;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.editor.NlEditor;
import com.android.tools.idea.common.model.NlLayoutType;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.naveditor.structure.DestinationList;
import com.android.tools.idea.naveditor.surface.NavDesignSurface;
import com.android.tools.idea.startup.DelayedInitialization;
import com.android.tools.idea.uibuilder.mockup.editor.MockupToolDefinition;
import com.android.tools.idea.uibuilder.palette.NlPaletteDefinition;
import com.android.tools.idea.uibuilder.property.NlPropertyPanelDefinition;
import com.android.tools.idea.uibuilder.structure.NlComponentTreeDefinition;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlEditorPanel
extends WorkBench<DesignSurface> {
    private final NlEditor myEditor;
    private final Project myProject;
    private final VirtualFile myFile;
    private final DesignSurface mySurface;
    private final JPanel myContentPanel;
    private boolean myIsActive;

    public NlEditorPanel(@NotNull NlEditor editor, @NotNull Project project, @NotNull VirtualFile file) {
        if (editor == null) {
            NlEditorPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            NlEditorPanel.$$$reportNull$$$0(1);
        }
        if (file == null) {
            NlEditorPanel.$$$reportNull$$$0(2);
        }
        super(project, "NELE_EDITOR", (FileEditor)editor);
        this.setOpaque(true);
        this.myEditor = editor;
        this.myProject = project;
        this.myFile = file;
        XmlFile psiFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(project, file);
        assert (psiFile != null) : file;
        this.myContentPanel = new JPanel(new BorderLayout());
        if (NlLayoutType.typeOf(psiFile) == NlLayoutType.NAV) {
            this.mySurface = new NavDesignSurface(project, (Disposable)editor);
        } else {
            this.mySurface = new NlDesignSurface(project, false, (Disposable)editor);
            ((NlDesignSurface)this.mySurface).setCentered(true);
        }
        this.setLoadingText("Waiting for build to finish...");
        if (Projects.isBuildWithGradle(project)) {
            DelayedInitialization.getInstance(project).runAfterBuild(this::initNeleModel, this::buildError);
        } else {
            this.initNeleModel();
        }
    }

    private void buildError() {
        this.loadingStopped("Design editor is unavailable until a successful build");
    }

    private void initNeleModel() {
        DumbService.getInstance((Project)this.myProject).smartInvokeLater(this::initNeleModelOnEventDispatchThread);
    }

    private void initNeleModelOnEventDispatchThread() {
        if (Disposer.isDisposed((Disposable)this.myEditor) || this.myContentPanel.getComponentCount() > 0) {
            return;
        }
        XmlFile psiFile = (XmlFile)AndroidPsiUtils.getPsiFileSafely(this.myProject, this.myFile);
        assert (psiFile != null);
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)psiFile);
        assert (facet != null);
        NlModel model = NlModel.create(this.mySurface, (Disposable)this.myEditor, facet, psiFile);
        this.mySurface.setModel(model);
        Disposer.register((Disposable)this.myEditor, (Disposable)this.mySurface);
        JComponent toolbarComponent = this.mySurface.getActionManager().createToolbar(model);
        this.myContentPanel.add((Component)toolbarComponent, "North");
        this.myContentPanel.add(this.mySurface);
        ArrayList<ToolWindowDefinition> tools = new ArrayList<ToolWindowDefinition>(4);
        tools.add(new NlPropertyPanelDefinition(facet, Side.RIGHT, Split.TOP, AutoHide.DOCKED));
        if (NlLayoutType.typeOf(psiFile) == NlLayoutType.NAV) {
            tools.add(new DestinationList.DestinationListDefinition());
        } else {
            tools.add(new NlPaletteDefinition(this.myProject, Side.LEFT, Split.TOP, AutoHide.DOCKED));
            tools.add(new NlComponentTreeDefinition(this.myProject, Side.LEFT, Split.BOTTOM, AutoHide.DOCKED));
            if (StudioFlags.NELE_MOCKUP_EDITOR.get().booleanValue()) {
                tools.add(new MockupToolDefinition(Side.RIGHT, Split.TOP, AutoHide.AUTO_HIDE));
            }
        }
        this.init(this.myContentPanel, this.mySurface, tools);
        if (this.myIsActive) {
            model.activate((Object)this);
        }
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySurface.getPreferredFocusedComponent();
    }

    public void activate() {
        this.mySurface.activate();
        this.myIsActive = true;
    }

    public void deactivate() {
        this.mySurface.deactivate();
        this.myIsActive = false;
    }

    @NotNull
    public DesignSurface getSurface() {
        DesignSurface designSurface = this.mySurface;
        if (designSurface == null) {
            NlEditorPanel.$$$reportNull$$$0(3);
        }
        return designSurface;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/editor/NlEditorPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/editor/NlEditorPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

