/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.SystemInfo;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DesignSurfaceActionHandler
implements DeleteProvider,
CutProvider,
CopyProvider,
PasteProvider {
    private final DesignSurface mySurface;

    public DesignSurfaceActionHandler(@NotNull DesignSurface surface) {
        if (surface == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(0);
        }
        this.mySurface = surface;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        NlModel model;
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(1);
        }
        if ((model = this.mySurface.getModel()) == null) {
            return;
        }
        CopyPasteManager.getInstance().setContents((Transferable)CopyCutTransferable.createCopyTransferable(model.getSelectionAsTransferable()));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(2);
        }
        return this.hasNonEmptySelection();
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(3);
        }
        return true;
    }

    public void performCut(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(4);
        }
        if (SystemInfo.isMac) {
            this.performCopy(dataContext);
            this.deleteElement(dataContext);
            return;
        }
        NlModel model = this.mySurface.getModel();
        if (model == null) {
            return;
        }
        CopyPasteManager.getInstance().setContents((Transferable)CopyCutTransferable.createCutTransferable(model.getSelectionAsTransferable()));
        this.deleteElement(dataContext);
    }

    public boolean isCutEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(5);
        }
        return this.hasNonEmptySelection();
    }

    public boolean isCutVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(6);
        }
        return true;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        SceneView sceneView;
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(7);
        }
        if ((sceneView = this.mySurface.getCurrentSceneView()) == null) {
            return;
        }
        SelectionModel selectionModel = sceneView.getSelectionModel();
        NlModel model = sceneView.getModel();
        model.delete((Collection<NlComponent>)selectionModel.getSelection());
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(8);
        }
        return this.hasNonEmptySelection();
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(9);
        }
        this.pasteOperation(false);
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(10);
        }
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DesignSurfaceActionHandler.$$$reportNull$$$0(11);
        }
        return this.pasteOperation(true);
    }

    private boolean hasNonEmptySelection() {
        SceneView sceneView = this.mySurface.getCurrentSceneView();
        return sceneView != null && !sceneView.getSelectionModel().isEmpty();
    }

    private boolean pasteOperation(boolean checkOnly) {
        DragType dragType;
        DnDTransferItem dndTransferItem;
        NlComponent before;
        ImmutableList<NlComponent> components;
        NlComponent receiver;
        SceneView sceneView = this.mySurface.getCurrentSceneView();
        if (sceneView == null) {
            return false;
        }
        ImmutableList<NlComponent> selection = sceneView.getSelectionModel().getSelection();
        NlComponent nlComponent = receiver = !selection.isEmpty() ? (NlComponent)selection.get(0) : null;
        if (receiver == null && (components = sceneView.getModel().getComponents()).size() == 1) {
            receiver = (NlComponent)components.get(0);
        }
        if (receiver == null) {
            return false;
        }
        NlModel model = sceneView.getModel();
        ViewHandlerManager handlerManager = ViewHandlerManager.get(model.getProject());
        ViewHandler handler = handlerManager.getHandler(receiver);
        if (handler instanceof ViewGroupHandler) {
            before = receiver.getChild(0);
        } else {
            before = receiver.getNextSibling();
            if ((receiver = receiver.getParent()) == null) {
                return false;
            }
        }
        if (!SystemInfo.isMac) {
            CopyCutTransferable item = DesignSurfaceActionHandler.getClipboardData(checkOnly);
            DnDTransferItem dnDTransferItem = dndTransferItem = item != null ? item.getDndTransferItem() : null;
            if (dndTransferItem == null) {
                return false;
            }
            dragType = item.isCut() ? DragType.MOVE : DragType.PASTE;
        } else {
            dragType = DragType.PASTE;
            dndTransferItem = DesignSurfaceActionHandler.getMacClipboardData();
            if (dndTransferItem == null) {
                return false;
            }
        }
        InsertType insertType = model.determineInsertType(dragType, dndTransferItem, checkOnly);
        List<NlComponent> pasted = NlModelHelperKt.createComponents(model, sceneView, dndTransferItem, insertType);
        if (!model.canAddComponents(pasted, receiver, before)) {
            return false;
        }
        if (checkOnly) {
            return true;
        }
        model.addComponents(pasted, receiver, before, insertType);
        return true;
    }

    @Nullable
    private static CopyCutTransferable getClipboardData(boolean checkOnly) {
        CopyPasteManager instance = CopyPasteManager.getInstance();
        Transferable contents = instance.getContents();
        if (contents == null || !(contents instanceof CopyCutTransferable)) {
            return null;
        }
        CopyCutTransferable transferItem = (CopyCutTransferable)contents;
        if (!checkOnly && transferItem.isCut()) {
            transferItem.consumeCut();
            return new CopyCutTransferable(transferItem.myTransferable, true);
        }
        return transferItem;
    }

    @Nullable
    private static DnDTransferItem getMacClipboardData() {
        try {
            Object data = CopyPasteManager.getInstance().getContents(ItemTransferable.DESIGNER_FLAVOR);
            if (!(data instanceof DnDTransferItem)) {
                return null;
            }
            return (DnDTransferItem)data;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/surface/DesignSurfaceActionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "performCut";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isCutEnabled";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCutVisible";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "performPaste";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isPastePossible";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isPasteEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CopyCutTransferable
    implements Transferable {
        private final Transferable myTransferable;
        private boolean myCut;

        private CopyCutTransferable(@NotNull Transferable transferable, boolean isCut) {
            if (transferable == null) {
                CopyCutTransferable.$$$reportNull$$$0(0);
            }
            this.myTransferable = transferable;
            this.myCut = isCut;
        }

        @NotNull
        private static CopyCutTransferable createCutTransferable(@NotNull Transferable transferable) {
            if (transferable == null) {
                CopyCutTransferable.$$$reportNull$$$0(1);
            }
            CopyCutTransferable copyCutTransferable = new CopyCutTransferable(transferable, true);
            if (copyCutTransferable == null) {
                CopyCutTransferable.$$$reportNull$$$0(2);
            }
            return copyCutTransferable;
        }

        @NotNull
        private static CopyCutTransferable createCopyTransferable(@NotNull Transferable transferable) {
            if (transferable == null) {
                CopyCutTransferable.$$$reportNull$$$0(3);
            }
            CopyCutTransferable copyCutTransferable = new CopyCutTransferable(transferable, false);
            if (copyCutTransferable == null) {
                CopyCutTransferable.$$$reportNull$$$0(4);
            }
            return copyCutTransferable;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.myTransferable.getTransferDataFlavors();
        }

        @Override
        public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
            if (flavor == null) {
                CopyCutTransferable.$$$reportNull$$$0(5);
            }
            return this.myTransferable.isDataFlavorSupported(flavor);
        }

        @Override
        public Object getTransferData(@NotNull DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor == null) {
                CopyCutTransferable.$$$reportNull$$$0(6);
            }
            return this.myTransferable.getTransferData(dataFlavor);
        }

        public boolean isCut() {
            return this.myCut;
        }

        private void consumeCut() {
            this.myCut = false;
        }

        @Nullable
        private DnDTransferItem getDndTransferItem() {
            try {
                Object data = this.getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                return data instanceof DnDTransferItem ? (DnDTransferItem)data : null;
            }
            catch (UnsupportedFlavorException | IOException e) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "transferable";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/surface/DesignSurfaceActionHandler$CopyCutTransferable";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flavor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataFlavor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/surface/DesignSurfaceActionHandler$CopyCutTransferable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCutTransferable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCopyTransferable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createCutTransferable";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createCopyTransferable";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isDataFlavorSupported";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTransferData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

