/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.debugger;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.Location;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunPositionManager
extends PositionManagerImpl {
    private static Logger LOG = Logger.getInstance(InstantRunPositionManager.class);
    private Map<AndroidVersion, VirtualFile> mySourceFoldersByApiLevel;

    public InstantRunPositionManager(DebugProcessImpl debugProcess) {
        super(debugProcess);
    }

    @Nullable
    protected PsiFile getPsiFileByLocation(Project project, Location location) {
        PsiFile file = super.getPsiFileByLocation(project, location);
        if (file == null) {
            return null;
        }
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return file;
        }
        AndroidVersion version = InstantRunPositionManager.getAndroidVersionFromDebugSession(project);
        if (version == null) {
            LOG.debug("getPsiFileByLocation returned null because cannot determine version from device.");
            return file;
        }
        PsiFile source = this.getApiSpecificPsi(project, file, version);
        return source == null ? file : source;
    }

    @Nullable
    protected PsiFile getApiSpecificPsi(@NotNull Project project, @NotNull PsiFile file, @NotNull AndroidVersion version) {
        if (project == null) {
            InstantRunPositionManager.$$$reportNull$$$0(0);
        }
        if (file == null) {
            InstantRunPositionManager.$$$reportNull$$$0(1);
        }
        if (version == null) {
            InstantRunPositionManager.$$$reportNull$$$0(2);
        }
        if (!AndroidSdks.getInstance().isInAndroidSdk((PsiElement)file)) {
            return null;
        }
        String relPath = InstantRunPositionManager.getRelPathFromSourceRoot(project, file);
        if (relPath == null) {
            LOG.debug("getApiSpecificPsi returned null because relPath is null for file: " + file.getName());
            return null;
        }
        return this.getSourceForApiLevel(project, version, relPath);
    }

    @Nullable
    private static AndroidVersion getAndroidVersionFromDebugSession(@NotNull Project project) {
        XDebugSession session;
        if (project == null) {
            InstantRunPositionManager.$$$reportNull$$$0(3);
        }
        if ((session = XDebuggerManager.getInstance((Project)project).getCurrentSession()) == null) {
            return null;
        }
        return (AndroidVersion)session.getDebugProcess().getProcessHandler().getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL);
    }

    @Nullable
    private PsiFile getSourceForApiLevel(@NotNull Project project, @NotNull AndroidVersion version, @NotNull String relPath) {
        VirtualFile sourceFolder;
        if (project == null) {
            InstantRunPositionManager.$$$reportNull$$$0(4);
        }
        if (version == null) {
            InstantRunPositionManager.$$$reportNull$$$0(5);
        }
        if (relPath == null) {
            InstantRunPositionManager.$$$reportNull$$$0(6);
        }
        if ((sourceFolder = this.getSourceFolder(version)) == null) {
            return null;
        }
        VirtualFile vfile = sourceFolder.findFileByRelativePath(relPath);
        if (vfile == null) {
            LOG.debug("getSourceForApiLevel returned null because " + relPath + " is not present in " + sourceFolder);
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(vfile);
    }

    @Nullable
    private VirtualFile getSourceFolder(@NotNull AndroidVersion version) {
        if (version == null) {
            InstantRunPositionManager.$$$reportNull$$$0(7);
        }
        if (this.mySourceFoldersByApiLevel == null) {
            this.mySourceFoldersByApiLevel = InstantRunPositionManager.createSourcesByApiLevel();
            if (this.mySourceFoldersByApiLevel.get(version) == null) {
                LOG.debug("getSourceFolder returned null for version: " + version);
            }
        }
        return this.mySourceFoldersByApiLevel.get(version);
    }

    private static Map<AndroidVersion, VirtualFile> createSourcesByApiLevel() {
        Collection<? extends LocalPackage> sourcePackages = InstantRunPositionManager.getAllPlatformSourcePackages();
        HashMap sourcesByApi = Maps.newHashMap();
        for (LocalPackage localPackage : sourcePackages) {
            TypeDetails typeDetails = localPackage.getTypeDetails();
            if (!(typeDetails instanceof DetailsTypes.ApiDetailsType)) {
                LOG.warn("Unable to get type details for source package @ " + localPackage.getLocation().getPath());
                continue;
            }
            DetailsTypes.ApiDetailsType details = (DetailsTypes.ApiDetailsType)typeDetails;
            AndroidVersion version = details.getAndroidVersion();
            VirtualFile sourceFolder = VfsUtil.findFileByIoFile((File)localPackage.getLocation(), (boolean)false);
            if (sourceFolder == null || !sourceFolder.isValid()) continue;
            sourcesByApi.put(version, sourceFolder);
        }
        return ImmutableMap.copyOf((Map)sourcesByApi);
    }

    private static Collection<? extends LocalPackage> getAllPlatformSourcePackages() {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(InstantRunPositionManager.class));
        return sdkManager.getPackages().getLocalPackagesForPrefix("sources");
    }

    @Nullable
    private static String getRelPathFromSourceRoot(@NotNull Project project, @NotNull PsiFile file) {
        ProjectFileIndex fileIndex;
        VirtualFile sourceRoot;
        if (project == null) {
            InstantRunPositionManager.$$$reportNull$$$0(8);
        }
        if (file == null) {
            InstantRunPositionManager.$$$reportNull$$$0(9);
        }
        if ((sourceRoot = (fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project)).getSourceRootForFile(file.getVirtualFile())) == null) {
            LOG.debug("Could not determine source root for file: " + file.getVirtualFile().getPath());
            return null;
        }
        return VfsUtilCore.getRelativePath((VirtualFile)file.getVirtualFile(), (VirtualFile)sourceRoot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/fd/debugger/InstantRunPositionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getApiSpecificPsi";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAndroidVersionFromDebugSession";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceForApiLevel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceFolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelPathFromSourceRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

