/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model.ide.android;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.Library;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.idea.gradle.project.model.ide.android.IdeMavenCoordinates;
import com.android.tools.idea.gradle.project.model.ide.android.ModelCache;
import com.android.tools.idea.gradle.project.model.ide.android.level2.BuildFolderPaths;
import com.android.utils.FileUtils;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class IdeLibraries {
    private IdeLibraries() {
    }

    @NotNull
    public static String computeAddress(@NotNull Library library) {
        block6: {
            String string;
            if (library == null) {
                IdeLibraries.$$$reportNull$$$0(0);
            }
            try {
                if (library.getProject() == null || !(library instanceof AndroidLibrary)) break block6;
                string = library.getProject() + "::" + ((AndroidLibrary)library).getProjectVariant();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (string == null) {
                IdeLibraries.$$$reportNull$$$0(1);
            }
            return string;
        }
        IdeMavenCoordinates coordinate = IdeLibraries.computeResolvedCoordinate(library, new ModelCache());
        String artifactId = StringUtil.trimStart((String)coordinate.getArtifactId(), (String)":");
        artifactId = artifactId.replace(':', '.');
        String address = coordinate.getGroupId() + ":" + artifactId + ":" + coordinate.getVersion();
        String classifier = coordinate.getClassifier();
        if (classifier != null) {
            address = address + ":" + classifier;
        }
        String packaging = coordinate.getPackaging();
        address = address + "@" + packaging;
        String string = address.intern();
        if (string == null) {
            IdeLibraries.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isLocalAarModule(@NotNull AndroidLibrary androidLibrary, @NotNull BuildFolderPaths buildFolderPaths) {
        String projectPath;
        if (androidLibrary == null) {
            IdeLibraries.$$$reportNull$$$0(3);
        }
        if (buildFolderPaths == null) {
            IdeLibraries.$$$reportNull$$$0(4);
        }
        if ((projectPath = androidLibrary.getProject()) == null) {
            return false;
        }
        File buildFolderPath = buildFolderPaths.findBuildFolderPath(projectPath);
        return buildFolderPath != null && !FileUtils.isFileInDirectory((File)androidLibrary.getBundle(), (File)buildFolderPath);
    }

    @NotNull
    public static IdeMavenCoordinates computeResolvedCoordinate(@NotNull Library library, @NotNull ModelCache modelCache) {
        if (library == null) {
            IdeLibraries.$$$reportNull$$$0(5);
        }
        if (modelCache == null) {
            IdeLibraries.$$$reportNull$$$0(6);
        }
        if (library.getResolvedCoordinates() != null) {
            IdeMavenCoordinates ideMavenCoordinates = modelCache.computeIfAbsent(library.getResolvedCoordinates(), coordinates -> {
                if (modelCache == null) {
                    IdeLibraries.$$$reportNull$$$0(9);
                }
                return new IdeMavenCoordinates((MavenCoordinates)coordinates, modelCache);
            });
            if (ideMavenCoordinates == null) {
                IdeLibraries.$$$reportNull$$$0(7);
            }
            return ideMavenCoordinates;
        }
        File jarFile = library instanceof JavaLibrary ? ((JavaLibrary)library).getJarFile() : ((AndroidLibrary)library).getBundle();
        IdeMavenCoordinates ideMavenCoordinates = new IdeMavenCoordinates(jarFile, new ModelCache());
        if (ideMavenCoordinates == null) {
            IdeLibraries.$$$reportNull$$$0(8);
        }
        return ideMavenCoordinates;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/ide/android/IdeLibraries";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidLibrary";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFolderPaths";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/ide/android/IdeLibraries";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAddress";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeResolvedCoordinate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeAddress";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLocalAarModule";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeResolvedCoordinate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$computeResolvedCoordinate$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

