/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SdkMerger;
import com.android.tools.idea.sdk.SdkPaths;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.GuiUtils;
import java.io.File;
import java.io.IOException;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkSync {
    private static final String ERROR_DIALOG_TITLE = "Sync Android SDKs";
    @NotNull
    private final IdeSdks myIdeSdks;

    @NotNull
    public static SdkSync getInstance() {
        SdkSync sdkSync = (SdkSync)ServiceManager.getService(SdkSync.class);
        if (sdkSync == null) {
            SdkSync.$$$reportNull$$$0(0);
        }
        return sdkSync;
    }

    public SdkSync(@NotNull IdeSdks ideSdks) {
        if (ideSdks == null) {
            SdkSync.$$$reportNull$$$0(1);
        }
        this.myIdeSdks = ideSdks;
    }

    public void syncIdeAndProjectAndroidSdks(@NotNull LocalProperties localProperties) {
        if (localProperties == null) {
            SdkSync.$$$reportNull$$$0(2);
        }
        this.syncIdeAndProjectAndroidSdk(localProperties, new FindValidSdkPathTask(this.myIdeSdks), null);
        this.syncIdeAndProjectAndroidNdk(localProperties);
    }

    public void syncIdeAndProjectAndroidSdks(@NotNull Project project) throws IOException {
        if (project == null) {
            SdkSync.$$$reportNull$$$0(3);
        }
        LocalProperties localProperties = new LocalProperties(project);
        this.syncIdeAndProjectAndroidSdk(localProperties, new FindValidSdkPathTask(this.myIdeSdks), project);
        this.syncIdeAndProjectAndroidNdk(localProperties);
    }

    @VisibleForTesting
    void syncIdeAndProjectAndroidSdk(@NotNull LocalProperties localProperties, @NotNull FindValidSdkPathTask findSdkPathTask, @Nullable Project project) {
        if (localProperties == null) {
            SdkSync.$$$reportNull$$$0(4);
        }
        if (findSdkPathTask == null) {
            SdkSync.$$$reportNull$$$0(5);
        }
        if (localProperties.hasAndroidDirProperty()) {
            return;
        }
        File ideAndroidSdkPath = this.myIdeSdks.getAndroidSdkPath();
        File projectAndroidSdkPath = localProperties.getAndroidSdkPath();
        if (ideAndroidSdkPath != null) {
            if (projectAndroidSdkPath == null) {
                SdkSync.setProjectSdk(localProperties, ideAndroidSdkPath);
                return;
            }
            SdkPaths.ValidationResult validationResult = SdkPaths.validateAndroidSdk(projectAndroidSdkPath, true);
            if (!validationResult.success) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    if (localProperties == null) {
                        SdkSync.$$$reportNull$$$0(17);
                    }
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        String error = validationResult.message;
                        if (StringUtil.isEmpty((String)error)) {
                            error = String.format("The path \n'%1$s'\ndoes not refer to a valid Android SDK.", projectAndroidSdkPath.getPath());
                        }
                        String format = "%1$s\n\nAndroid Studio will use this Android SDK instead:\n'%2$s'\nand will modify the project's local.properties file.";
                        Messages.showErrorDialog((String)String.format(format, error, ideAndroidSdkPath.getPath()), (String)ERROR_DIALOG_TITLE);
                    }
                    SdkSync.setProjectSdk(localProperties, ideAndroidSdkPath);
                });
                return;
            }
        } else {
            if (projectAndroidSdkPath == null || !this.myIdeSdks.isValidAndroidSdkPath(projectAndroidSdkPath)) {
                File selectedPath = findSdkPathTask.selectValidSdkPath();
                if (selectedPath == null) {
                    throw new ExternalSystemException("Unable to continue until an Android SDK is specified");
                }
                this.setIdeSdk(localProperties, selectedPath);
                return;
            }
            this.setIdeSdk(localProperties, projectAndroidSdkPath);
            return;
        }
        if (!FileUtil.filesEqual((File)ideAndroidSdkPath, (File)projectAndroidSdkPath)) {
            String msg = String.format("The project and Android Studio point to different Android SDKs.\n\nAndroid Studio's default SDK is in:\n%1$s\n\nThe project's SDK (specified in local.properties) is in:\n%2$s\n\nTo keep results consistent between IDE and command line builds, only one path can be used. Do you want to:\n\n[1] Use Android Studio's default SDK (modifies the project's local.properties file.)\n\n[2] Use the project's SDK (modifies Android Studio's default.)\n\nNote that switching SDKs could cause compile errors if the selected SDK doesn't have the necessary Android platforms or build tools.", ideAndroidSdkPath.getPath(), projectAndroidSdkPath.getPath());
            ApplicationManager.getApplication().invokeAndWait(() -> {
                int result;
                if (localProperties == null) {
                    SdkSync.$$$reportNull$$$0(16);
                }
                if ((result = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Android SDK Manager", (String)msg).yesText("Use Android Studio's SDK")).noText("Use Project's SDK")).project(project)).show()) == 0) {
                    SdkSync.setProjectSdk(localProperties, ideAndroidSdkPath);
                } else {
                    this.setIdeSdk(localProperties, projectAndroidSdkPath);
                }
                if (AndroidPlugin.isGuiTestingMode() && !AndroidPlugin.getGuiTestSuiteState().isSkipSdkMerge()) {
                    SdkSync.mergeIfNeeded(projectAndroidSdkPath, ideAndroidSdkPath);
                }
            });
        }
    }

    private void syncIdeAndProjectAndroidNdk(@NotNull LocalProperties localProperties) {
        if (localProperties == null) {
            SdkSync.$$$reportNull$$$0(6);
        }
        File projectAndroidNdkPath = localProperties.getAndroidNdkPath();
        File ideAndroidNdkPath = this.myIdeSdks.getAndroidNdkPath();
        if (projectAndroidNdkPath != null) {
            if (!SdkPaths.validateAndroidNdk((File)projectAndroidNdkPath, (boolean)false).success) {
                if (ideAndroidNdkPath != null) {
                    Logger.getInstance(SdkSync.class).warn(String.format("Replacing invalid NDK path %1$s with %2$s", projectAndroidNdkPath, ideAndroidNdkPath));
                    SdkSync.setProjectNdk(localProperties, ideAndroidNdkPath);
                    return;
                }
                Logger.getInstance(SdkSync.class).warn(String.format("Removing invalid NDK path: %s", projectAndroidNdkPath));
                SdkSync.setProjectNdk(localProperties, null);
            }
            return;
        }
        SdkSync.setProjectNdk(localProperties, ideAndroidNdkPath);
    }

    private static void setProjectNdk(@NotNull LocalProperties localProperties, @Nullable File ndkPath) {
        File currentNdkPath;
        if (localProperties == null) {
            SdkSync.$$$reportNull$$$0(7);
        }
        if (FileUtil.filesEqual((File)(currentNdkPath = localProperties.getAndroidNdkPath()), (File)ndkPath)) {
            return;
        }
        localProperties.setAndroidNdkPath(ndkPath);
        try {
            localProperties.save();
        }
        catch (IOException e) {
            String msg = String.format("Unable to save '%1$s'", localProperties.getPropertiesFilePath().getPath());
            throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
        }
    }

    private void setIdeSdk(@NotNull LocalProperties localProperties, @NotNull File projectAndroidSdkPath) {
        if (localProperties == null) {
            SdkSync.$$$reportNull$$$0(8);
        }
        if (projectAndroidSdkPath == null) {
            SdkSync.$$$reportNull$$$0(9);
        }
        SdkSync.setProjectSdk(localProperties, projectAndroidSdkPath);
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (projectAndroidSdkPath == null) {
                SdkSync.$$$reportNull$$$0(14);
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (projectAndroidSdkPath == null) {
                    SdkSync.$$$reportNull$$$0(15);
                }
                this.myIdeSdks.setAndroidSdkPath(projectAndroidSdkPath, null);
            });
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private static void setProjectSdk(@NotNull LocalProperties localProperties, @NotNull File androidSdkPath) {
        if (localProperties == null) {
            SdkSync.$$$reportNull$$$0(10);
        }
        if (androidSdkPath == null) {
            SdkSync.$$$reportNull$$$0(11);
        }
        if (FileUtil.filesEqual((File)localProperties.getAndroidSdkPath(), (File)androidSdkPath)) {
            return;
        }
        localProperties.setAndroidSdkPath(androidSdkPath);
        try {
            localProperties.save();
        }
        catch (IOException e) {
            String msg = String.format("Unable to save '%1$s'", localProperties.getPropertiesFilePath().getPath());
            throw new ExternalSystemException(msg, (Throwable)e, new String[0]);
        }
    }

    private static void mergeIfNeeded(final @NotNull File sourceSdk, final @NotNull File destSdk) {
        String msg;
        int result;
        if (sourceSdk == null) {
            SdkSync.$$$reportNull$$$0(12);
        }
        if (destSdk == null) {
            SdkSync.$$$reportNull$$$0(13);
        }
        if (SdkMerger.hasMergeableContent(sourceSdk, destSdk) && (result = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Merge SDKs", (String)(msg = String.format("The Android SDK at\n\n%1$s\n\nhas packages not in your project's SDK at\n\n%2$s\n\nWould you like to copy into the project SDK?", sourceSdk.getPath(), destSdk.getPath()))).yesText("Copy")).noText("Do not copy")).show()) == 0) {
            new Task.Backgroundable(null, "Merging Android SDKs", false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    SdkMerger.mergeSdks(sourceSdk, destSdk, indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/gradle/project/sync/SdkSync$1", "run"));
                }
            }.queue();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/SdkSync";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideSdks";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findSdkPathTask";
                break;
            }
            case 9: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectAndroidSdkPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidSdkPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceSdk";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destSdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/SdkSync";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "syncIdeAndProjectAndroidSdks";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "syncIdeAndProjectAndroidSdk";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "syncIdeAndProjectAndroidNdk";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setProjectNdk";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setIdeSdk";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setProjectSdk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mergeIfNeeded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setIdeSdk$3";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$syncIdeAndProjectAndroidSdk$1";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$syncIdeAndProjectAndroidSdk$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class FindValidSdkPathTask {
        @NotNull
        private final IdeSdks myIdeSdks;

        FindValidSdkPathTask(@NotNull IdeSdks ideSdks) {
            if (ideSdks == null) {
                FindValidSdkPathTask.$$$reportNull$$$0(0);
            }
            this.myIdeSdks = ideSdks;
        }

        @Nullable
        File selectValidSdkPath() {
            Ref pathRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(() -> this.findValidSdkPath((Ref<File>)pathRef));
            return (File)pathRef.get();
        }

        private void findValidSdkPath(@NotNull Ref<File> pathRef) {
            Sdk jdk;
            if (pathRef == null) {
                FindValidSdkPathTask.$$$reportNull$$$0(1);
            }
            String jdkPath = (jdk = this.myIdeSdks.getJdk()) != null ? jdk.getHomePath() : null;
            SelectSdkDialog dialog = new SelectSdkDialog(jdkPath, null);
            dialog.setModal(true);
            if (!dialog.showAndGet()) {
                String msg = "An Android SDK is needed to continue. Would you like to try again?";
                if (Messages.showYesNoDialog((String)msg, (String)SdkSync.ERROR_DIALOG_TITLE, null) == 0) {
                    this.findValidSdkPath(pathRef);
                }
                return;
            }
            File path = new File(dialog.getAndroidHome());
            if (!this.myIdeSdks.isValidAndroidSdkPath(path)) {
                String format = "The path\n'%1$s'\ndoes not refer to a valid Android SDK. Would you like to try again?";
                if (Messages.showYesNoDialog((String)String.format(format, path.getPath()), (String)SdkSync.ERROR_DIALOG_TITLE, null) == 0) {
                    this.findValidSdkPath(pathRef);
                }
                return;
            }
            pathRef.set((Object)path);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ideSdks";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathRef";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/SdkSync$FindValidSdkPathTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findValidSdkPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

