/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.idea;

import com.android.tools.idea.gradle.project.GradleProjectSyncData;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.sync.GradleSync;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.idea.ProjectSetUpTask;
import com.android.tools.idea.gradle.project.sync.idea.data.DataNodeCaches;
import com.android.tools.idea.gradle.project.sync.setup.post.PostSyncProjectSetup;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleProjectOpenProcessor;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class IdeaGradleSync
implements GradleSync {
    private static final boolean SYNC_WITH_CACHED_MODEL_ONLY = SystemProperties.getBooleanProperty((String)"studio.sync.with.cached.model.only", (boolean)false);
    @NotNull
    private final Project myProject;

    public IdeaGradleSync(@NotNull Project project) {
        if (project == null) {
            IdeaGradleSync.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Override
    public void sync(@NotNull GradleSyncInvoker.Request request, @Nullable GradleSyncListener listener) {
        String externalProjectPath;
        LinkedHashSet androidProjectCandidatesPaths;
        PostSyncProjectSetup.Request setupRequest;
        boolean newProject;
        block10: {
            block8: {
                Collection projectsSettings;
                block9: {
                    DataNodeCaches dataNodeCaches;
                    DataNode<ProjectData> cache;
                    GradleProjectSyncData syncData;
                    if (request == null) {
                        IdeaGradleSync.$$$reportNull$$$0(1);
                    }
                    this.myProject.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, (Object)true);
                    newProject = request.isNewOrImportedProject();
                    if ((SYNC_WITH_CACHED_MODEL_ONLY || request.isUseCachedGradleModels()) && (syncData = GradleProjectSyncData.getInstance(this.myProject)) != null && syncData.canUseCachedProjectData() && (cache = (dataNodeCaches = DataNodeCaches.getInstance(this.myProject)).getCachedProjectData()) != null && !dataNodeCaches.isCacheMissingModels(cache)) {
                        PostSyncProjectSetup.Request setupRequest2 = new PostSyncProjectSetup.Request();
                        setupRequest2.setUsingCachedGradleModels(true).setGenerateSourcesAfterSync(false).setLastSyncTimestamp(syncData.getLastGradleSyncTimestamp());
                        IdeaGradleSync.setSkipAndroidPluginUpgrade(request, setupRequest2);
                        ProjectSetUpTask setUpTask = new ProjectSetUpTask(this.myProject, setupRequest2, listener, newProject, true, true);
                        setUpTask.onSuccess(cache);
                        return;
                    }
                    setupRequest = new PostSyncProjectSetup.Request();
                    setupRequest.setGenerateSourcesAfterSync(request.isGenerateSourcesOnSuccess()).setCleanProjectAfterSync(request.isCleanProject());
                    IdeaGradleSync.setSkipAndroidPluginUpgrade(request, setupRequest);
                    androidProjectCandidatesPaths = ContainerUtil.newLinkedHashSet();
                    if (!request.isNewOrImportedProject()) break block8;
                    GradleSettings gradleSettings = GradleSettings.getInstance((Project)this.myProject);
                    projectsSettings = gradleSettings.getLinkedProjectsSettings();
                    if (!projectsSettings.isEmpty()) break block9;
                    GradleProjectOpenProcessor gradleProjectOpenProcessor = (GradleProjectOpenProcessor)Extensions.findExtension((ExtensionPointName)ProjectOpenProcessor.EXTENSION_POINT_NAME, GradleProjectOpenProcessor.class);
                    if (this.myProject.getBasePath() != null && gradleProjectOpenProcessor.canOpenProject(this.myProject.getBaseDir())) {
                        GradleProjectSettings projectSettings = new GradleProjectSettings();
                        String externalProjectPath2 = ExternalSystemApiUtil.toCanonicalPath((String)this.myProject.getBasePath());
                        projectSettings.setExternalProjectPath(externalProjectPath2);
                        gradleSettings.setLinkedProjectsSettings((Collection)ContainerUtil.list((Object[])new GradleProjectSettings[]{projectSettings}));
                        androidProjectCandidatesPaths.add(externalProjectPath2);
                    }
                    break block10;
                }
                if (projectsSettings.size() != 1) break block10;
                androidProjectCandidatesPaths.add(((GradleProjectSettings)projectsSettings.iterator().next()).getExternalProjectPath());
                break block10;
            }
            for (Module module : ProjectFacetManager.getInstance((Project)this.myProject).getModulesWithFacet(GradleFacet.getFacetTypeId())) {
                String projectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                ContainerUtil.addIfNotNull((Collection)androidProjectCandidatesPaths, (Object)projectPath);
            }
        }
        if (androidProjectCandidatesPaths.isEmpty() && GradleSettings.getInstance((Project)this.myProject).getLinkedProjectsSettings().isEmpty() && (new File(externalProjectPath = ExternalSystemApiUtil.toCanonicalPath((String)Projects.getBaseDirPath(this.myProject).getPath()), "build.gradle").isFile() || new File(externalProjectPath, "settings.gradle").isFile())) {
            androidProjectCandidatesPaths.add(externalProjectPath);
        }
        if (androidProjectCandidatesPaths.isEmpty()) {
            if (listener != null) {
                listener.syncSkipped(this.myProject);
            }
            return;
        }
        for (String rootPath : androidProjectCandidatesPaths) {
            ProjectSetUpTask setUpTask = new ProjectSetUpTask(this.myProject, setupRequest, listener, newProject, newProject, false);
            ProgressExecutionMode executionMode = request.getProgressExecutionMode();
            ExternalSystemUtil.refreshProject((Project)this.myProject, (ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (String)rootPath, (ExternalProjectRefreshCallback)setUpTask, (boolean)false, (ProgressExecutionMode)executionMode, (boolean)true);
        }
    }

    private static void setSkipAndroidPluginUpgrade(@NotNull GradleSyncInvoker.Request syncRequest, @NotNull PostSyncProjectSetup.Request setupRequest) {
        if (syncRequest == null) {
            IdeaGradleSync.$$$reportNull$$$0(2);
        }
        if (setupRequest == null) {
            IdeaGradleSync.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && syncRequest.isSkipAndroidPluginUpgrade()) {
            setupRequest.setSkipAndroidPluginUpgrade();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncRequest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setupRequest";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/idea/IdeaGradleSync";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "sync";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setSkipAndroidPluginUpgrade";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

