/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.builder.model.level2.Library;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.model.ide.android.level2.IdeDependencies;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.DependencySet;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class DependenciesExtractor {
    @NotNull
    public static DependenciesExtractor getInstance() {
        DependenciesExtractor dependenciesExtractor = (DependenciesExtractor)ServiceManager.getService(DependenciesExtractor.class);
        if (dependenciesExtractor == null) {
            DependenciesExtractor.$$$reportNull$$$0(0);
        }
        return dependenciesExtractor;
    }

    @NotNull
    public DependencySet extractFrom(@NotNull IdeVariant variant) {
        if (variant == null) {
            DependenciesExtractor.$$$reportNull$$$0(1);
        }
        DependencySet dependencies2 = new DependencySet();
        for (IdeBaseArtifact testArtifact : variant.getTestArtifacts()) {
            DependenciesExtractor.populate(dependencies2, testArtifact, DependencyScope.TEST);
        }
        IdeAndroidArtifact mainArtifact = variant.getMainArtifact();
        DependenciesExtractor.populate(dependencies2, mainArtifact, DependencyScope.COMPILE);
        DependencySet dependencySet = dependencies2;
        if (dependencySet == null) {
            DependenciesExtractor.$$$reportNull$$$0(2);
        }
        return dependencySet;
    }

    @NotNull
    public DependencySet extractFrom(@NotNull IdeBaseArtifact artifact, @NotNull DependencyScope scope) {
        if (artifact == null) {
            DependenciesExtractor.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(4);
        }
        DependencySet dependencies2 = new DependencySet();
        DependenciesExtractor.populate(dependencies2, artifact, scope);
        DependencySet dependencySet = dependencies2;
        if (dependencySet == null) {
            DependenciesExtractor.$$$reportNull$$$0(5);
        }
        return dependencySet;
    }

    private static void populate(@NotNull DependencySet dependencies2, @NotNull IdeBaseArtifact artifact, @NotNull DependencyScope scope) {
        if (dependencies2 == null) {
            DependenciesExtractor.$$$reportNull$$$0(6);
        }
        if (artifact == null) {
            DependenciesExtractor.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(8);
        }
        IdeDependencies artifactDependencies = artifact.getLevel2Dependencies();
        for (Library library : artifactDependencies.getJavaLibraries()) {
            LibraryDependency libraryDependency = new LibraryDependency(library.getArtifact(), library.getArtifactAddress(), scope);
            libraryDependency.addPath(LibraryDependency.PathType.BINARY, library.getArtifact());
            dependencies2.add(libraryDependency);
        }
        for (Library library : artifactDependencies.getAndroidLibraries()) {
            dependencies2.add(DependenciesExtractor.createLibraryDependencyFromAndroidLibrary(library, scope));
        }
        for (Library library : artifactDependencies.getModuleDependencies()) {
            String gradleProjectPath = library.getProjectPath();
            if (gradleProjectPath == null || gradleProjectPath.isEmpty()) continue;
            ModuleDependency dependency = new ModuleDependency(gradleProjectPath, scope);
            dependencies2.add(dependency);
        }
    }

    @NotNull
    private static LibraryDependency createLibraryDependencyFromAndroidLibrary(@NotNull Library library, @NotNull DependencyScope scope) {
        if (library == null) {
            DependenciesExtractor.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            DependenciesExtractor.$$$reportNull$$$0(10);
        }
        LibraryDependency dependency = new LibraryDependency(library.getArtifact(), DependenciesExtractor.getDependencyName(library, "-"), scope);
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getJarFile());
        dependency.addPath(LibraryDependency.PathType.BINARY, library.getResFolder());
        for (String localJar : library.getLocalJars()) {
            dependency.addPath(LibraryDependency.PathType.BINARY, localJar);
        }
        LibraryDependency libraryDependency = dependency;
        if (libraryDependency == null) {
            DependenciesExtractor.$$$reportNull$$$0(11);
        }
        return libraryDependency;
    }

    @NotNull
    public static String getDependencyName(@NotNull Library library, @NotNull String separator) {
        String artifactAddress;
        GradleCoordinate coordinates;
        if (library == null) {
            DependenciesExtractor.$$$reportNull$$$0(12);
        }
        if (separator == null) {
            DependenciesExtractor.$$$reportNull$$$0(13);
        }
        if ((coordinates = GradleCoordinate.parseCoordinateString((String)(artifactAddress = library.getArtifactAddress()))) != null) {
            String name = coordinates.getArtifactId();
            GradleVersion version = coordinates.getVersion();
            if (version != null && !"unspecified".equals(version.toString())) {
                name = name + separator + version;
            }
            assert (name != null);
            if (StringUtil.isNotEmpty((String)coordinates.getGroupId())) {
                String string = coordinates.getGroupId() + ":" + name;
                if (string == null) {
                    DependenciesExtractor.$$$reportNull$$$0(14);
                }
                return string;
            }
            String string = name;
            if (string == null) {
                DependenciesExtractor.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = StringUtil.trimLeading((String)artifactAddress, (char)':');
        if (string == null) {
            DependenciesExtractor.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public static String getDependencyDisplayName(@NotNull Library library) {
        String artifactAddress;
        GradleCoordinate coordinates;
        if (library == null) {
            DependenciesExtractor.$$$reportNull$$$0(17);
        }
        if ((coordinates = GradleCoordinate.parseCoordinateString((String)(artifactAddress = library.getArtifactAddress()))) != null) {
            GradleVersion version;
            int index;
            String groupSuffix;
            String groupId;
            String name = coordinates.getArtifactId();
            if (name == null) {
                name = "?";
            }
            if (!name.contains("-") && (groupId = coordinates.getGroupId()) != null && !(groupSuffix = groupId.substring((index = groupId.lastIndexOf(46)) + 1)).equals(name)) {
                name = groupSuffix + ":" + name;
            }
            if ((version = coordinates.getVersion()) != null && !"unspecified".equals(version.toString())) {
                name = name + ":" + version;
            }
            String string = name;
            if (string == null) {
                DependenciesExtractor.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = StringUtil.trimLeading((String)artifactAddress, (char)':');
        if (string == null) {
            DependenciesExtractor.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependenciesExtractor";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractFrom";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLibraryDependencyFromAndroidLibrary";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencyDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractFrom";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLibraryDependencyFromAndroidLibrary";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDependencyDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

