/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModuleAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.xml.util.XmlStringUtil;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsAndroidModuleAnalyzer
extends PsModuleAnalyzer<PsAndroidModule> {
    private static final Pattern URL_PATTERN = Pattern.compile("\\(?http://[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]");

    public PsAndroidModuleAnalyzer(@NotNull PsContext context) {
        if (context == null) {
            PsAndroidModuleAnalyzer.$$$reportNull$$$0(0);
        }
        super(context);
    }

    @Override
    protected void doAnalyze(@NotNull PsAndroidModule module, @NotNull PsIssueCollection issueCollection) {
        if (module == null) {
            PsAndroidModuleAnalyzer.$$$reportNull$$$0(1);
        }
        if (issueCollection == null) {
            PsAndroidModuleAnalyzer.$$$reportNull$$$0(2);
        }
        ArrayListMultimap issuesByData = ArrayListMultimap.create();
        AndroidModuleModel gradleModel = module.getGradleModel();
        Collection syncIssues = gradleModel.getAndroidProject().getSyncIssues();
        for (SyncIssue syncIssue : syncIssues) {
            String data = Strings.nullToEmpty((String)syncIssue.getData());
            issuesByData.put((Object)data, (Object)syncIssue);
        }
        PsModulePath modulePath = new PsModulePath(module);
        module.forEachDependency(arg_0 -> this.lambda$doAnalyze$0((Multimap)issuesByData, modulePath, issueCollection, arg_0));
    }

    @VisibleForTesting
    @NotNull
    static PsIssue createIssueFrom(@NotNull SyncIssue syncIssue, @NotNull PsPath path, @Nullable PsPath extraPath) {
        if (syncIssue == null) {
            PsAndroidModuleAnalyzer.$$$reportNull$$$0(3);
        }
        if (path == null) {
            PsAndroidModuleAnalyzer.$$$reportNull$$$0(4);
        }
        String message = XmlStringUtil.escapeString((String)syncIssue.getMessage());
        Matcher matcher = URL_PATTERN.matcher(message);
        boolean result = matcher.find();
        while (result) {
            String url = matcher.group();
            message = message.replace(url, "<a href='" + url + "'>" + url + "</a>");
            result = matcher.find();
        }
        PsIssue issue2 = new PsIssue(message, path, PsIssueType.PROJECT_ANALYSIS, PsAndroidModuleAnalyzer.getSeverity(syncIssue));
        issue2.setExtraPath(extraPath);
        PsIssue psIssue = issue2;
        if (psIssue == null) {
            PsAndroidModuleAnalyzer.$$$reportNull$$$0(5);
        }
        return psIssue;
    }

    @NotNull
    private static PsIssue.Severity getSeverity(@NotNull SyncIssue issue2) {
        if (issue2 == null) {
            PsAndroidModuleAnalyzer.$$$reportNull$$$0(6);
        }
        int severity = issue2.getSeverity();
        switch (severity) {
            case 2: {
                PsIssue.Severity severity2 = PsIssue.Severity.ERROR;
                if (severity2 == null) {
                    PsAndroidModuleAnalyzer.$$$reportNull$$$0(7);
                }
                return severity2;
            }
            case 1: {
                PsIssue.Severity severity3 = PsIssue.Severity.WARNING;
                if (severity3 == null) {
                    PsAndroidModuleAnalyzer.$$$reportNull$$$0(8);
                }
                return severity3;
            }
        }
        PsIssue.Severity severity4 = PsIssue.Severity.INFO;
        if (severity4 == null) {
            PsAndroidModuleAnalyzer.$$$reportNull$$$0(9);
        }
        return severity4;
    }

    @Override
    @NotNull
    public Class<PsAndroidModule> getSupportedModelType() {
        if (PsAndroidModule.class == null) {
            PsAndroidModuleAnalyzer.$$$reportNull$$$0(10);
        }
        return PsAndroidModule.class;
    }

    private /* synthetic */ void lambda$doAnalyze$0(Multimap issuesByData, PsModulePath modulePath, @NotNull PsIssueCollection issueCollection, PsAndroidDependency dependency) {
        if (issueCollection == null) {
            PsAndroidModuleAnalyzer.$$$reportNull$$$0(11);
        }
        if (dependency instanceof PsLibraryDependency && dependency.isDeclared()) {
            PsLibraryDependency libraryDependency = (PsLibraryDependency)((Object)dependency);
            PsLibraryDependencyNavigationPath path = new PsLibraryDependencyNavigationPath(this.getContext(), libraryDependency);
            PsArtifactDependencySpec resolvedSpec = libraryDependency.getResolvedSpec();
            String issueKey = resolvedSpec.getGroup() + ":" + resolvedSpec.getName();
            Collection librarySyncIssues = issuesByData.get((Object)issueKey);
            for (SyncIssue syncIssue : librarySyncIssues) {
                PsIssue issue2 = PsAndroidModuleAnalyzer.createIssueFrom(syncIssue, path, modulePath);
                issueCollection.add(issue2);
            }
            this.analyzeDeclaredDependency(libraryDependency, modulePath, issueCollection);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueCollection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssue";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/daemon/analysis/PsAndroidModuleAnalyzer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createIssueFrom";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedModelType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doAnalyze";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createIssueFrom";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doAnalyze$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

