/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon.analysis;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.daemon.analysis.PsModelAnalyzer;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsIssueType;
import com.android.tools.idea.gradle.structure.model.PsLibraryDependency;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsModulePath;
import com.android.tools.idea.gradle.structure.navigation.PsLibraryDependencyNavigationPath;
import com.android.tools.idea.gradle.structure.quickfix.PsLibraryDependencyVersionQuickFixPath;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class PsModuleAnalyzer<T extends PsModule>
extends PsModelAnalyzer<T> {
    private static final Pattern URL_PATTERN = Pattern.compile("\\(?http://[-A-Za-z0-9+&@#/%?=~_()|!:,.;]*[-A-Za-z0-9+&@#/%=~_()|]");
    @NotNull
    private final PsContext myContext;

    protected PsModuleAnalyzer(@NotNull PsContext context) {
        if (context == null) {
            PsModuleAnalyzer.$$$reportNull$$$0(0);
        }
        this.myContext = context;
    }

    protected void analyzeDeclaredDependency(@NotNull PsLibraryDependency dependency, @NotNull PsModulePath modulePath, @NotNull PsIssueCollection issueCollection) {
        String message;
        if (dependency == null) {
            PsModuleAnalyzer.$$$reportNull$$$0(1);
        }
        if (modulePath == null) {
            PsModuleAnalyzer.$$$reportNull$$$0(2);
        }
        if (issueCollection == null) {
            PsModuleAnalyzer.$$$reportNull$$$0(3);
        }
        PsArtifactDependencySpec resolvedSpec = dependency.getResolvedSpec();
        PsLibraryDependencyNavigationPath path = new PsLibraryDependencyNavigationPath(this.myContext, dependency);
        PsArtifactDependencySpec declaredSpec = dependency.getDeclaredSpec();
        assert (declaredSpec != null);
        String declaredVersion = declaredSpec.getVersion();
        if (declaredVersion != null && declaredVersion.endsWith("+")) {
            message = "Avoid using '+' in version numbers; can lead to unpredictable and unrepeatable builds.";
            PsIssue issue2 = new PsIssue(message, "", path, PsIssueType.PROJECT_ANALYSIS, PsIssue.Severity.WARNING);
            issue2.setExtraPath(modulePath);
            PsLibraryDependencyVersionQuickFixPath quickFix = new PsLibraryDependencyVersionQuickFixPath(dependency);
            issue2.setQuickFixPath(quickFix);
            issueCollection.add(issue2);
        }
        if (dependency.hasPromotedVersion()) {
            message = "Gradle promoted library version from " + declaredVersion + " to " + resolvedSpec.getVersion();
            String description = "To resolve version conflicts, Gradle by default uses the newest version of a dependency. <a href='https://docs.gradle.org/current/userguide/dependency_management.html'>Open Gradle documentation</a>";
            PsIssue issue3 = new PsIssue(message, description, path, PsIssueType.PROJECT_ANALYSIS, PsIssue.Severity.INFO);
            issue3.setExtraPath(modulePath);
            issueCollection.add(issue3);
        }
    }

    @NotNull
    protected PsContext getContext() {
        PsContext psContext = this.myContext;
        if (psContext == null) {
            PsModuleAnalyzer.$$$reportNull$$$0(4);
        }
        return psContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueCollection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/structure/daemon/analysis/PsModuleAnalyzer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/structure/daemon/analysis/PsModuleAnalyzer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "analyzeDeclaredDependency";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

