/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.tools.idea.lint.DefaultLintQuickFix;
import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.inspections.lint.AndroidLintInspectionBase;
import org.jetbrains.android.inspections.lint.AndroidLintQuickFix;
import org.jetbrains.android.inspections.lint.AndroidQuickfixContexts;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintCheckResultInspection
extends AndroidLintInspectionBase {
    public AndroidLintCheckResultInspection() {
        super(AndroidBundle.message("android.lint.inspections.check.result", new Object[0]), SupportAnnotationDetector.CHECK_RESULT);
    }

    @Override
    @NotNull
    public AndroidLintQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message, @Nullable LintFix fixData) {
        String suggest;
        if (startElement == null) {
            AndroidLintCheckResultInspection.$$$reportNull$$$0(0);
        }
        if (endElement == null) {
            AndroidLintCheckResultInspection.$$$reportNull$$$0(1);
        }
        if (message == null) {
            AndroidLintCheckResultInspection.$$$reportNull$$$0(2);
        }
        if ((suggest = (String)LintFix.getData((LintFix)fixData, String.class)) != null) {
            AndroidLintQuickFix[] androidLintQuickFixArray = new AndroidLintQuickFix[]{new ReplaceCallFix(suggest)};
            if (androidLintQuickFixArray == null) {
                AndroidLintCheckResultInspection.$$$reportNull$$$0(3);
            }
            return androidLintQuickFixArray;
        }
        AndroidLintQuickFix[] androidLintQuickFixArray = super.getQuickFixes(startElement, endElement, message, fixData);
        if (androidLintQuickFixArray == null) {
            AndroidLintCheckResultInspection.$$$reportNull$$$0(4);
        }
        return androidLintQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/lint/AndroidLintCheckResultInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/lint/AndroidLintCheckResultInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ReplaceCallFix
    extends DefaultLintQuickFix {
        private final String mySuggest;

        public ReplaceCallFix(@NotNull String suggest) {
            if (suggest == null) {
                ReplaceCallFix.$$$reportNull$$$0(0);
            }
            super(null);
            this.mySuggest = suggest;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = String.format("Call %1$s instead", this.getMethodName());
            if (string == null) {
                ReplaceCallFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private String getMethodName() {
            assert (this.mySuggest.startsWith("#"));
            int start = 1;
            int parameters = this.mySuggest.indexOf(40, start);
            if (parameters == -1) {
                parameters = this.mySuggest.length();
            }
            return this.mySuggest.substring(start, parameters).trim();
        }

        @Override
        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
            TextRange range;
            PsiReferenceExpression methodExpression;
            PsiElement referenceNameElement;
            if (startElement == null) {
                ReplaceCallFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                ReplaceCallFix.$$$reportNull$$$0(3);
            }
            if (context == null) {
                ReplaceCallFix.$$$reportNull$$$0(4);
            }
            if (!startElement.isValid()) {
                return;
            }
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiMethodCallExpression.class, (boolean)false);
            if (methodCall == null) {
                return;
            }
            PsiFile file = methodCall.getContainingFile();
            if (file == null) {
                return;
            }
            Document document = FileDocumentManager.getInstance().getDocument(file.getVirtualFile());
            if (document != null && (referenceNameElement = (methodExpression = methodCall.getMethodExpression()).getReferenceNameElement()) != null && (range = referenceNameElement.getTextRange()) != null) {
                String name = this.getMethodName();
                if (name.startsWith("enforce") && methodExpression.getReferenceName() != null && methodExpression.getReferenceName().startsWith("check")) {
                    PsiExpressionList argumentList = methodCall.getArgumentList();
                    int offset = argumentList.getTextOffset() + argumentList.getTextLength() - 1;
                    document.insertString(offset, (CharSequence)", \"TODO: message if thrown\"");
                }
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)name);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suggest";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/lint/AndroidLintCheckResultInspection$ReplaceCallFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/lint/AndroidLintCheckResultInspection$ReplaceCallFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

