/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.navigator.nodes.android;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.navigator.AndroidProjectViewPane;
import com.android.tools.idea.navigator.nodes.android.AndroidJniFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidManifestsGroupNode;
import com.android.tools.idea.navigator.nodes.android.AndroidResFolderNode;
import com.android.tools.idea.navigator.nodes.android.AndroidSourceTypeNode;
import com.android.tools.idea.res.SampleDataResourceRepository;
import com.google.common.collect.HashMultimap;
import com.intellij.codeInsight.dataflow.SetUtil;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ProjectViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidSourceType;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModuleNode
extends ProjectViewModuleNode {
    private final AndroidProjectViewPane myProjectViewPane;

    public AndroidModuleNode(@NotNull Project project, @NotNull Module module, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane) {
        if (project == null) {
            AndroidModuleNode.$$$reportNull$$$0(0);
        }
        if (module == null) {
            AndroidModuleNode.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            AndroidModuleNode.$$$reportNull$$$0(2);
        }
        if (projectViewPane == null) {
            AndroidModuleNode.$$$reportNull$$$0(3);
        }
        super(project, module, settings);
        this.myProjectViewPane = projectViewPane;
    }

    @NotNull
    private Module getModule() {
        Module module = (Module)this.getValue();
        assert (module != null);
        Module module2 = module;
        if (module2 == null) {
            AndroidModuleNode.$$$reportNull$$$0(4);
        }
        return module2;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        AndroidFacet facet = AndroidFacet.getInstance(this.getModule());
        if (facet == null || facet.getAndroidModel() == null) {
            Collection collection = super.getChildren();
            if (collection == null) {
                AndroidModuleNode.$$$reportNull$$$0(5);
            }
            return collection;
        }
        Collection<AbstractTreeNode> collection = AndroidModuleNode.getChildren(facet, this.getSettings(), this.myProjectViewPane, AndroidProjectViewPane.getSourceProviders(facet));
        if (collection == null) {
            AndroidModuleNode.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    static Collection<AbstractTreeNode> getChildren(@NotNull AndroidFacet facet, @NotNull ViewSettings settings, @NotNull AndroidProjectViewPane projectViewPane, @NotNull List<IdeaSourceProvider> providers) {
        if (facet == null) {
            AndroidModuleNode.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            AndroidModuleNode.$$$reportNull$$$0(8);
        }
        if (projectViewPane == null) {
            AndroidModuleNode.$$$reportNull$$$0(9);
        }
        if (providers == null) {
            AndroidModuleNode.$$$reportNull$$$0(10);
        }
        Project project = facet.getModule().getProject();
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get(facet);
        HashMultimap<AndroidSourceType, VirtualFile> sourcesByType = AndroidModuleNode.getSourcesBySourceType(providers, androidModuleModel);
        NdkModuleModel ndkModuleModel = NdkModuleModel.get(facet.getModule());
        for (AndroidSourceType sourceType : sourcesByType.keySet()) {
            if (sourceType == AndroidSourceType.CPP && ndkModuleModel != null) continue;
            if (sourceType == AndroidSourceType.MANIFEST) {
                result.add((AbstractTreeNode)new AndroidManifestsGroupNode(project, facet, settings, sourcesByType.get((Object)sourceType)));
                continue;
            }
            if (sourceType == AndroidSourceType.RES) {
                result.add((AbstractTreeNode)new AndroidResFolderNode(project, facet, settings, sourcesByType.get((Object)sourceType), projectViewPane));
                continue;
            }
            if (sourceType == AndroidSourceType.SHADERS && (androidModuleModel == null || !androidModuleModel.getFeatures().isShadersSupported())) continue;
            result.add((AbstractTreeNode)new AndroidSourceTypeNode(project, facet, settings, sourceType, sourcesByType.get((Object)sourceType), projectViewPane));
        }
        if (ndkModuleModel != null) {
            result.add((AbstractTreeNode)new AndroidJniFolderNode(project, ndkModuleModel, settings));
        }
        if (StudioFlags.NELE_SAMPLE_DATA.get().booleanValue()) {
            try {
                PsiDirectory sampleDataPsi;
                VirtualFile sampleDataDirectory = SampleDataResourceRepository.getSampleDataDir(facet, false);
                PsiDirectory psiDirectory = sampleDataPsi = sampleDataDirectory != null ? PsiManager.getInstance((Project)project).findDirectory(sampleDataDirectory) : null;
                if (sampleDataPsi != null) {
                    result.add((AbstractTreeNode)new PsiDirectoryNode(project, sampleDataPsi, settings));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ArrayList<AbstractTreeNode> arrayList = result;
        if (arrayList == null) {
            AndroidModuleNode.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static HashMultimap<AndroidSourceType, VirtualFile> getSourcesBySourceType(@NotNull List<IdeaSourceProvider> providers, @Nullable AndroidModuleModel androidModel) {
        if (providers == null) {
            AndroidModuleNode.$$$reportNull$$$0(12);
        }
        HashMultimap sourcesByType = HashMultimap.create();
        HashSet<VirtualFile> allSources = new HashSet<VirtualFile>();
        for (AndroidSourceType sourceType : AndroidSourceType.values()) {
            Set<VirtualFile> sources;
            if (sourceType == AndroidSourceType.SHADERS && (androidModel == null || !androidModel.getFeatures().isShadersSupported()) || (sources = AndroidModuleNode.getSources(sourceType, providers)).isEmpty()) continue;
            if (SetUtil.intersect(allSources, sources).isEmpty()) {
                sourcesByType.putAll((Object)sourceType, sources);
            } else if (!allSources.containsAll(sources)) {
                sources.removeAll(allSources);
                sourcesByType.putAll((Object)sourceType, sources);
            }
            allSources.addAll(sources);
        }
        HashMultimap hashMultimap = sourcesByType;
        if (hashMultimap == null) {
            AndroidModuleNode.$$$reportNull$$$0(13);
        }
        return hashMultimap;
    }

    @NotNull
    private static Set<VirtualFile> getSources(@NotNull AndroidSourceType sourceType, @NotNull Iterable<IdeaSourceProvider> providers) {
        if (sourceType == null) {
            AndroidModuleNode.$$$reportNull$$$0(14);
        }
        if (providers == null) {
            AndroidModuleNode.$$$reportNull$$$0(15);
        }
        HashSet<VirtualFile> sources = new HashSet<VirtualFile>();
        for (IdeaSourceProvider provider : providers) {
            sources.addAll(sourceType.getSources(provider));
        }
        HashSet<VirtualFile> hashSet = sources;
        if (hashSet == null) {
            AndroidModuleNode.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @Nullable
    public Comparable getSortKey() {
        return this.getModule().getName();
    }

    @Nullable
    public Comparable getTypeSortKey() {
        return this.getSortKey();
    }

    @Nullable
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        return String.format("%1$s (Android)", this.getModule().getName());
    }

    public void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            AndroidModuleNode.$$$reportNull$$$0(17);
        }
        super.update(presentation);
        presentation.setIcon(GradleUtil.getModuleIcon(this.getModule()));
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectViewPane";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/navigator/nodes/android/AndroidModuleNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/navigator/nodes/android/AndroidModuleNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 5: 
            case 6: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourcesBySourceType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 16: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourcesBySourceType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSources";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

