/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.ideahost;

import com.android.tools.idea.help.StudioHelpManagerImpl;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.ui.wizard.deprecated.StudioWizardLayout;
import com.android.tools.idea.wizard.model.ModelWizard;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.intellij.ide.util.newProjectWizard.WizardDelegate;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.AbstractWizard;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.DialogEarthquakeShaker;
import com.intellij.openapi.util.Disposer;
import java.awt.Window;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class IdeaWizardAdapter
implements ModelWizard.WizardListener,
WizardDelegate,
Disposable {
    @NotNull
    private final ListenerManager myListeners;
    @NotNull
    private final ModelWizardDialog.CustomLayout myCustomLayout;
    @NotNull
    private final AbstractWizard myHostWizard;
    @NotNull
    private final ModelWizard myGuestWizard;

    IdeaWizardAdapter(@NotNull AbstractWizard host, @NotNull ModelWizard guest) {
        if (host == null) {
            IdeaWizardAdapter.$$$reportNull$$$0(0);
        }
        if (guest == null) {
            IdeaWizardAdapter.$$$reportNull$$$0(1);
        }
        this.myListeners = new ListenerManager();
        this.myCustomLayout = new StudioWizardLayout();
        this.myHostWizard = host;
        this.myGuestWizard = guest;
        this.myGuestWizard.addResultListener(this);
        this.myListeners.listenAll(this.myGuestWizard.canGoBack(), this.myGuestWizard.canGoForward(), this.myGuestWizard.onLastStep()).withAndFire(this::updateButtons);
        Disposer.register((Disposable)this.myHostWizard.getDisposable(), (Disposable)this);
        Disposer.register((Disposable)this, (Disposable)this.myGuestWizard);
        Disposer.register((Disposable)this, (Disposable)this.myCustomLayout);
    }

    private void updateButtons() {
        this.myHostWizard.updateButtons(((Boolean)this.myGuestWizard.onLastStep().get()).booleanValue(), ((Boolean)this.myGuestWizard.canGoForward().get()).booleanValue(), (Boolean)this.myGuestWizard.canGoBack().get() == false);
    }

    @Override
    public void onWizardFinished(@NotNull ModelWizard.WizardResult result) {
        if (result == null) {
            IdeaWizardAdapter.$$$reportNull$$$0(2);
        }
        this.myHostWizard.close(1, result.isFinished());
    }

    @Override
    public void onWizardAdvanceError(@NotNull Exception e) {
        if (e == null) {
            IdeaWizardAdapter.$$$reportNull$$$0(3);
        }
        DialogEarthquakeShaker.shake((Window)this.myHostWizard.getWindow());
    }

    public void doNextAction() {
        assert (((Boolean)this.myGuestWizard.canGoForward().get()).booleanValue());
        this.myGuestWizard.goForward();
        this.updateButtons();
    }

    public void doPreviousAction() {
        assert (((Boolean)this.myGuestWizard.canGoBack().get()).booleanValue());
        this.myGuestWizard.goBack();
        this.updateButtons();
    }

    public void doFinishAction() {
        assert (((Boolean)this.myGuestWizard.canGoForward().get()).booleanValue());
        assert (((Boolean)this.myGuestWizard.onLastStep().get()).booleanValue());
        this.myGuestWizard.goForward();
        this.updateButtons();
    }

    public boolean canProceed() {
        return (Boolean)this.myGuestWizard.canGoForward().get();
    }

    public void dispose() {
        this.myListeners.releaseAll();
        this.myGuestWizard.removeResultListener(this);
    }

    @NotNull
    public ModuleWizardStep getProxyStep() {
        ModuleWizardStep moduleWizardStep = new ModuleWizardStep(){

            public JComponent getComponent() {
                return IdeaWizardAdapter.this.myCustomLayout.decorate(IdeaWizardAdapter.this.myGuestWizard.getTitleHeader(), IdeaWizardAdapter.this.myGuestWizard.getContentPanel());
            }

            public void updateDataModel() {
            }

            @Nullable
            public String getHelpId() {
                return StudioHelpManagerImpl.STUDIO_HELP_PREFIX + "studio/projects/create-project.html";
            }
        };
        if (moduleWizardStep == null) {
            IdeaWizardAdapter.$$$reportNull$$$0(4);
        }
        return moduleWizardStep;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guest";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/ideahost/IdeaWizardAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/ideahost/IdeaWizardAdapter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onWizardFinished";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onWizardAdvanceError";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

