/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.npw.module;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.UpdatablePackage;
import com.android.tools.adtui.LabelWithEditButton;
import com.android.tools.adtui.util.FormScalingUtil;
import com.android.tools.adtui.validation.Validator;
import com.android.tools.adtui.validation.ValidatorPanel;
import com.android.tools.idea.gradle.npw.project.GradleAndroidProjectPaths;
import com.android.tools.idea.npw.FormFactor;
import com.android.tools.idea.npw.module.AppNameToModuleNameExpression;
import com.android.tools.idea.npw.module.FormFactorApiComboBox;
import com.android.tools.idea.npw.module.NewModuleModel;
import com.android.tools.idea.npw.platform.AndroidVersionsInfo;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.npw.project.DomainToPackageExpression;
import com.android.tools.idea.npw.project.NewProjectModel;
import com.android.tools.idea.npw.template.ChooseActivityTypeStep;
import com.android.tools.idea.npw.template.RenderTemplateModel;
import com.android.tools.idea.npw.template.TemplateValueInjector;
import com.android.tools.idea.npw.validator.ModuleValidator;
import com.android.tools.idea.observable.BindingsManager;
import com.android.tools.idea.observable.ListenerManager;
import com.android.tools.idea.observable.ObservableValue;
import com.android.tools.idea.observable.core.BoolValueProperty;
import com.android.tools.idea.observable.core.ObservableBool;
import com.android.tools.idea.observable.core.StringValueProperty;
import com.android.tools.idea.observable.ui.SelectedItemProperty;
import com.android.tools.idea.observable.ui.TextProperty;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.InstallSelectedPackagesStep;
import com.android.tools.idea.sdk.wizard.LicenseAgreementModel;
import com.android.tools.idea.sdk.wizard.LicenseAgreementStep;
import com.android.tools.idea.ui.wizard.StudioWizardStepPanel;
import com.android.tools.idea.ui.wizard.WizardUtils;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.android.tools.idea.wizard.model.SkippableWizardStep;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureAndroidModuleStep
extends SkippableWizardStep<NewModuleModel> {
    private final AndroidVersionsInfo myAndroidVersionsInfo;
    private final List<UpdatablePackage> myInstallRequests;
    private final List<RemotePackage> myInstallLicenseRequests;
    private final BindingsManager myBindings;
    private final ListenerManager myListeners;
    @NotNull
    private final StudioWizardStepPanel myRootPanel;
    @NotNull
    private ValidatorPanel myValidatorPanel;
    @NotNull
    private final FormFactor myFormFactor;
    private final int myMinSdkLevel;
    private final boolean myIsLibrary;
    private final boolean myIsInstantApp;
    private FormFactorApiComboBox mySdkControls;
    private JTextField myModuleName;
    private JPanel myPanel;
    private JTextField myAppName;
    private LabelWithEditButton myPackageName;
    @NotNull
    private RenderTemplateModel myRenderModel;

    public ConfigureAndroidModuleStep(@NotNull NewModuleModel model, @NotNull FormFactor formFactor, int minSdkLevel, boolean isLibrary, boolean isInstantApp, @NotNull String title) {
        if (model == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(0);
        }
        if (formFactor == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(1);
        }
        if (title == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(2);
        }
        super(model, title, formFactor.getIcon());
        this.$$$setupUI$$$();
        this.myAndroidVersionsInfo = new AndroidVersionsInfo();
        this.myInstallRequests = new ArrayList<UpdatablePackage>();
        this.myInstallLicenseRequests = new ArrayList<RemotePackage>();
        this.myBindings = new BindingsManager();
        this.myListeners = new ListenerManager();
        this.myFormFactor = formFactor;
        this.myMinSdkLevel = minSdkLevel;
        this.myIsLibrary = isLibrary;
        this.myIsInstantApp = isInstantApp;
        StringValueProperty companyDomain = new StringValueProperty(NewProjectModel.getInitialDomain(false));
        TextProperty packageNameText = new TextProperty(this.myPackageName);
        TextProperty moduleNameText = new TextProperty(this.myModuleName);
        DomainToPackageExpression computedPackageName = new DomainToPackageExpression(companyDomain, model.applicationName());
        BoolValueProperty isPackageNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(packageNameText, computedPackageName, isPackageNameSynced);
        this.myBindings.bind(model.packageName(), packageNameText);
        this.myListeners.receive(packageNameText, value -> isPackageNameSynced.set(value.equals(computedPackageName.get())));
        NewModuleModel moduleModel = (NewModuleModel)this.getModel();
        Project project = moduleModel.getProject().getValue();
        AppNameToModuleNameExpression computedModuleName = new AppNameToModuleNameExpression(project, model.applicationName());
        BoolValueProperty isModuleNameSynced = new BoolValueProperty(true);
        this.myBindings.bind(moduleNameText, computedModuleName, isModuleNameSynced);
        this.myBindings.bind(model.moduleName(), moduleNameText);
        this.myListeners.receive(moduleNameText, value -> isModuleNameSynced.set(value.equals(computedModuleName.get())));
        this.myBindings.bindTwoWay(new TextProperty(this.myAppName), model.applicationName());
        this.myValidatorPanel = new ValidatorPanel((Disposable)this, (JComponent)this.myPanel);
        this.myValidatorPanel.registerValidator((ObservableValue)model.applicationName(), value -> {
            if (model == null) {
                ConfigureAndroidModuleStep.$$$reportNull$$$0(6);
            }
            if (value.isEmpty()) {
                return new Validator.Result(Validator.Severity.ERROR, AndroidBundle.message("android.wizard.validate.empty.application.name", new Object[0]));
            }
            if (!((Boolean)model.isLibrary().get()).booleanValue() && !Character.isUpperCase(value.charAt(0))) {
                return new Validator.Result(Validator.Severity.INFO, AndroidBundle.message("android.wizard.validate.lowercase.application.name", new Object[0]));
            }
            return Validator.Result.OK;
        });
        this.myValidatorPanel.registerValidator((ObservableValue)model.moduleName(), (Validator)new ModuleValidator(project));
        this.myValidatorPanel.registerValidator((ObservableValue)model.packageName(), value -> Validator.Result.fromNullableMessage((String)WizardUtils.validatePackageName(value)));
        AndroidSourceSet dummySourceSet = GradleAndroidProjectPaths.createDummySourceSet();
        this.myRenderModel = new RenderTemplateModel(moduleModel, null, dummySourceSet, AndroidBundle.message("android.wizard.activity.add", this.myFormFactor.id));
        this.myBindings.bind(this.myRenderModel.androidSdkInfo(), new SelectedItemProperty(this.mySdkControls));
        this.myRootPanel = new StudioWizardStepPanel((JPanel)this.myValidatorPanel);
        FormScalingUtil.scaleComponentTree(this.getClass(), (JComponent)this.myRootPanel);
    }

    @Override
    @NotNull
    protected Collection<? extends ModelWizardStep> createDependentSteps() {
        ChooseActivityTypeStep chooseActivityStep = new ChooseActivityTypeStep((NewModuleModel)this.getModel(), this.myRenderModel, this.myFormFactor, Lists.newArrayList());
        chooseActivityStep.setShouldShow(!this.myIsLibrary || this.myIsInstantApp);
        LicenseAgreementStep licenseAgreementStep = new LicenseAgreementStep(new LicenseAgreementModel(AndroidVersionsInfo.getSdkManagerLocalPath()), this.myInstallLicenseRequests);
        InstallSelectedPackagesStep installPackagesStep = new InstallSelectedPackagesStep(this.myInstallRequests, new HashSet<LocalPackage>(), AndroidSdks.getInstance().tryToChooseSdkHandler(), false);
        ArrayList arrayList = Lists.newArrayList((Object[])new ModelWizardStep[]{chooseActivityStep, licenseAgreementStep, installPackagesStep});
        if (arrayList == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    protected void onEntering() {
        this.myAndroidVersionsInfo.load();
        this.myAndroidVersionsInfo.loadTargetVersions(this.myFormFactor, this.myMinSdkLevel, items -> this.mySdkControls.init(this.myFormFactor, items));
    }

    @Override
    @NotNull
    protected ObservableBool canGoForward() {
        ObservableBool observableBool = this.myValidatorPanel.hasErrors().not();
        if (observableBool == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(4);
        }
        return observableBool;
    }

    @Override
    protected void onProceeding() {
        NewModuleModel moduleModel = (NewModuleModel)this.getModel();
        moduleModel.getTemplateValues().put(this.myFormFactor.id + "included", true);
        ((NewModuleModel)this.getModel()).moduleName().set(this.myModuleName.getText());
        Project project = moduleModel.getProject().getValue();
        File moduleRoot = new File(project.getBasePath(), (String)moduleModel.moduleName().get());
        this.myRenderModel.getSourceSet().set(GradleAndroidProjectPaths.createDefaultSourceSetAt(moduleRoot));
        if (this.myIsLibrary) {
            moduleModel.setDefaultRenderTemplateValues(this.myRenderModel, project);
            new TemplateValueInjector(moduleModel.getTemplateValues()).setProjectDefaults(project, (String)moduleModel.applicationName().get(), this.myIsInstantApp);
        }
        this.myInstallRequests.clear();
        this.myInstallLicenseRequests.clear();
        List<AndroidVersionsInfo.VersionItem> installItems = Collections.singletonList(this.myRenderModel.androidSdkInfo().getValue());
        this.myInstallRequests.addAll(this.myAndroidVersionsInfo.loadInstallPackageList(installItems));
        this.myInstallLicenseRequests.addAll(this.myInstallRequests.stream().map(UpdatablePackage::getRemote).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    protected JComponent getComponent() {
        StudioWizardStepPanel studioWizardStepPanel = this.myRootPanel;
        if (studioWizardStepPanel == null) {
            ConfigureAndroidModuleStep.$$$reportNull$$$0(5);
        }
        return studioWizardStepPanel;
    }

    @Override
    @Nullable
    protected JComponent getPreferredFocusComponent() {
        return this.myAppName;
    }

    private void createUIComponents() {
        this.mySdkControls = new FormFactorApiComboBox();
    }

    @Override
    public void dispose() {
        this.myBindings.releaseAll();
        this.myListeners.releaseAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formFactor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/npw/module/ConfigureAndroidModuleStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/npw/module/ConfigureAndroidModuleStep";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependentSteps";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "canGoForward";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        LabelWithEditButton labelWithEditButton;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(13, 1, new Insets(0, 5, 0, 0), -1, -1, false, false));
        this.myAppName = jTextField2 = new JTextField();
        jTextField2.setName("ModuleName");
        jPanel.add((Component)jTextField2, new GridConstraints(2, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myPackageName = labelWithEditButton = new LabelWithEditButton();
        labelWithEditButton.setName("PackageName");
        jPanel.add((Component)labelWithEditButton, new GridConstraints(8, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myModuleName = jTextField = new JTextField();
        ((Component)jTextField).setVisible(true);
        jPanel.add((Component)jTextField, new GridConstraints(5, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        FormFactorApiComboBox formFactorApiComboBox = this.mySdkControls;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        formFactorApiComboBox.setModel(defaultComboBoxModel);
        jPanel.add((Component)formFactorApiComboBox, new GridConstraints(11, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jLabel.getFont());
        if (font != null) {
            jLabel.setFont(font);
        }
        jLabel.setText("Package name");
        jPanel.add((Component)jLabel, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        Font font2 = this.$$$getFont$$$(null, 1, -1, jLabel2.getFont());
        if (font2 != null) {
            jLabel2.setFont(font2);
        }
        jLabel2.setText("Module name");
        jLabel2.setDisplayedMnemonic('M');
        jLabel2.setDisplayedMnemonicIndex(0);
        ((Component)jLabel2).setVisible(true);
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        Font font3 = this.$$$getFont$$$(null, 1, -1, jLabel3.getFont());
        if (font3 != null) {
            jLabel3.setFont(font3);
        }
        jLabel3.setText("Application/Library name");
        jLabel3.setDisplayedMnemonic('A');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 16), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(6, 0, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 16), null));
        JLabel jLabel4 = new JLabel();
        Font font4 = this.$$$getFont$$$(null, 1, -1, jLabel4.getFont());
        if (font4 != null) {
            jLabel4.setFont(font4);
        }
        jLabel4.setText("Minimum SDK");
        jPanel.add((Component)jLabel4, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(12, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, new GridConstraints(9, 0, 1, 1, 0, 0, 1, 0, null, new Dimension(-1, 16), null));
        JBLabel jBLabel = new JBLabel();
        Font font5 = this.$$$getFont$$$(null, 1, 20, jBLabel.getFont());
        if (font5 != null) {
            jBLabel.setFont(font5);
        }
        jBLabel.setText("Configure the new module");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(-1, 50), null));
        jLabel2.setLabelFor(jTextField);
        jLabel3.setLabelFor(jTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

